/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.api.block.engine;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import valkyrienwarfare.addon.control.tileentity.TileEntityPropellerEngine;
import valkyrienwarfare.api.IBlockForceProvider;
import valkyrienwarfare.api.Vector;

public abstract class BlockAirshipEngine
extends Block
implements IBlockForceProvider,
ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public double enginePower = 4000.0;

    public BlockAirshipEngine(Material materialIn, double enginePower) {
        super(materialIn);
        this.enginePower = enginePower;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        return i;
    }

    @Override
    public Vector getBlockForceInShipSpace(World world, BlockPos pos, IBlockState state, Entity shipEntity, double secondsToApply) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        Vector acting = new Vector(0.0, 0.0, 0.0);
        if (!world.func_175640_z(pos)) {
            return acting;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityPropellerEngine) {
            ((TileEntityPropellerEngine)tileEntity).setThrust(this.getEnginePower(world, pos, state, shipEntity));
            ((TileEntityPropellerEngine)tileEntity).updateTicksSinceLastRecievedSignal();
            return ((TileEntityPropellerEngine)tileEntity).getForceOutputUnoriented(secondsToApply);
        }
        return acting;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public double getEnginePower(World world, BlockPos pos, IBlockState state, Entity shipEntity) {
        return this.enginePower;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        Vector normalVector = new Vector(1.0, 0.0, 0.0);
        IBlockState state = this.func_176203_a(meta);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case DOWN: {
                normalVector = new Vector(0.0, 1.0, 0.0);
                break;
            }
            case UP: {
                normalVector = new Vector(0.0, -1.0, 0.0);
                break;
            }
            case EAST: {
                normalVector = new Vector(-1.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                normalVector = new Vector(0.0, 0.0, 1.0);
                break;
            }
            case WEST: {
                normalVector = new Vector(1.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                normalVector = new Vector(0.0, 0.0, -1.0);
            }
        }
        return new TileEntityPropellerEngine(normalVector, true, this.enginePower);
    }
}

