/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.api.block.ethercompressor;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.nodenetwork.BasicForceNodeTileEntity;
import valkyrienwarfare.addon.control.tileentity.TileEntityHoverController;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public abstract class TileEntityEtherCompressor
extends BasicForceNodeTileEntity {
    public Vector linearThrust = new Vector();
    public Vector angularThrust = new Vector();
    private BlockPos controllerPos;

    public TileEntityEtherCompressor() {
        this.func_145829_t();
    }

    public TileEntityEtherCompressor(Vector normalForceVector, double power) {
        super(normalForceVector, false, power);
        this.func_145829_t();
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(BlockPos toSet) {
        this.controllerPos = toSet;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        int controllerPosX = compound.func_74762_e("controllerPosX");
        int controllerPosY = compound.func_74762_e("controllerPosY");
        int controllerPosZ = compound.func_74762_e("controllerPosZ");
        this.controllerPos = new BlockPos(controllerPosX, controllerPosY, controllerPosZ);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound toReturn = super.func_189515_b(compound);
        if (this.controllerPos != null) {
            toReturn.func_74768_a("controllerPosX", this.controllerPos.func_177958_n());
            toReturn.func_74768_a("controllerPosY", this.controllerPos.func_177956_o());
            toReturn.func_74768_a("controllerPosZ", this.controllerPos.func_177952_p());
        }
        return toReturn;
    }

    @Override
    public boolean isForceOutputOriented() {
        return false;
    }

    @Override
    public Vector getForceOutputUnoriented(double secondsToApply) {
        if (this.controllerPos == null) {
            Vector output = super.getForceOutputUnoriented(secondsToApply);
            return output;
        }
        TileEntity controllerTile = this.field_145850_b.func_175625_s(this.controllerPos);
        if (controllerTile != null && controllerTile instanceof TileEntityHoverController) {
            TileEntityHoverController controller = (TileEntityHoverController)controllerTile;
            PhysicsObject physObj = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)this.field_145850_b, (BlockPos)this.field_174879_c).wrapping;
            Vector notToReturn = controller.getForceForEngine(this, this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), physObj, secondsToApply);
            this.currentThrust = notToReturn.length() / secondsToApply;
        }
        return super.getForceOutputUnoriented(secondsToApply);
    }
}

