/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.chunkmanagement;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ChunkSet {
    public World world;
    public int centerX;
    public int centerZ;
    public int radius;
    public int minX;
    public int maxX;
    public int minZ;
    public int maxZ;
    public boolean[][] chunkOccupiedInLocal;

    public ChunkSet(int x, int z, int size) {
        this.centerX = x;
        this.centerZ = z;
        this.radius = size;
        this.minX = this.centerX - this.radius;
        this.maxX = this.centerX + this.radius;
        this.minZ = this.centerZ - this.radius;
        this.maxZ = this.centerZ + this.radius;
        this.chunkOccupiedInLocal = new boolean[this.radius * 2 + 1][this.radius * 2 + 1];
    }

    public ChunkSet(NBTTagCompound readFrom) {
        this(readFrom.func_74762_e("centerX"), readFrom.func_74762_e("centerZ"), readFrom.func_74762_e("radius"));
    }

    public void writeToNBT(NBTTagCompound toSave) {
        toSave.func_74768_a("centerX", this.centerX);
        toSave.func_74768_a("centerZ", this.centerZ);
        toSave.func_74768_a("radius", this.radius);
    }

    public boolean isChunkEnclosedInMaxSet(int chunkX, int chunkZ) {
        boolean inX = chunkX >= this.centerX - 12 && chunkX <= this.centerX + 12;
        boolean inZ = chunkZ >= this.centerZ - 12 && chunkZ <= this.centerZ + 12;
        return inX && inZ;
    }

    public boolean isChunkEnclosedInSet(int chunkX, int chunkZ) {
        boolean inX = chunkX >= this.minX && chunkX <= this.maxX;
        boolean inZ = chunkZ >= this.minZ && chunkZ <= this.maxZ;
        return inX && inZ;
    }

    public String toString() {
        return this.centerX + ":" + this.centerZ + ":" + this.radius;
    }

    public boolean equals(Object o) {
        if (o instanceof ChunkSet) {
            ChunkSet other = (ChunkSet)o;
            return other.centerX == this.centerX && other.centerZ == this.centerZ && other.radius == this.radius;
        }
        return false;
    }
}

