/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.chunkmanagement;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.world.World;
import valkyrienwarfare.chunkmanagement.PhysicsChunkManager;
import valkyrienwarfare.interaction.BlockPosToShipUUIDData;
import valkyrienwarfare.interaction.ShipNameUUIDData;
import valkyrienwarfare.interaction.ShipUUIDToPosData;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class DimensionPhysicsChunkManager {
    private HashMap<World, PhysicsChunkManager> managerPerWorld = new HashMap();
    private PhysicsChunkManager cachedManager;

    public void initWorld(World toInit) {
        if (!this.managerPerWorld.containsKey(toInit)) {
            this.managerPerWorld.put(toInit, new PhysicsChunkManager(toInit));
        }
    }

    public PhysicsChunkManager getManagerForWorld(World world) {
        if (world == null) {
            return null;
        }
        if (this.cachedManager == null || this.cachedManager.worldObj != world) {
            this.cachedManager = this.managerPerWorld.get(world);
            if (this.cachedManager == null) {
                this.initWorld(world);
                this.cachedManager = this.managerPerWorld.get(world);
            }
        }
        return this.cachedManager;
    }

    public void removeWorld(World world) {
        this.managerPerWorld.remove(world);
    }

    public void registerChunksForShip(PhysicsWrapperEntity wrapper) {
        World shipWorld = wrapper.field_70170_p;
        BlockPosToShipUUIDData data = BlockPosToShipUUIDData.get(shipWorld);
        data.addShipToPersistantMap(wrapper);
    }

    public void removeRegistedChunksForShip(PhysicsWrapperEntity wrapper) {
        World shipWorld = wrapper.field_70170_p;
        BlockPosToShipUUIDData data = BlockPosToShipUUIDData.get(shipWorld);
        data.removeShipFromPersistantMap(wrapper);
    }

    public UUID getShipIDManagingPos_Persistant(World worldFor, int chunkX, int chunkZ) {
        BlockPosToShipUUIDData data = BlockPosToShipUUIDData.get(worldFor);
        return data.getShipUUIDFromPos(chunkX, chunkZ);
    }

    public ShipUUIDToPosData.ShipPositionData getShipPosition_Persistant(World worldFor, UUID shipID) {
        ShipUUIDToPosData data = ShipUUIDToPosData.get(worldFor);
        return data.getShipPositionData(shipID);
    }

    public void updateShipPosition(PhysicsWrapperEntity wrapper) {
        World shipWorld = wrapper.field_70170_p;
        ShipUUIDToPosData data = ShipUUIDToPosData.get(shipWorld);
        data.updateShipPosition(wrapper);
    }

    public void removeShipPosition(PhysicsWrapperEntity wrapper) {
        World shipWorld = wrapper.field_70170_p;
        ShipUUIDToPosData data = ShipUUIDToPosData.get(shipWorld);
        data.removeShipFromMap(wrapper);
    }

    public void removeShipNameRegistry(PhysicsWrapperEntity wrapper) {
        World shipWorld = wrapper.field_70170_p;
        ShipNameUUIDData data = ShipNameUUIDData.get(shipWorld);
        data.removeShipFromRegistry(wrapper);
    }
}

