/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.chunkmanagement;

import net.minecraft.world.World;
import valkyrienwarfare.chunkmanagement.ChunkKeysWorldData;
import valkyrienwarfare.chunkmanagement.ChunkSet;

public class PhysicsChunkManager {
    public static int xChunkStartingPos = -1870000;
    public static int zChunkStartingPos = -1870000;
    public static int maxChunkRadius = 12;
    public World worldObj;
    public int nextChunkSetKey;
    public int chunkSetIncrement;
    public int distanceBetweenSets = 1;
    public ChunkKeysWorldData data;

    public PhysicsChunkManager(World worldFor) {
        this.worldObj = worldFor;
        this.chunkSetIncrement = maxChunkRadius * 2 + this.distanceBetweenSets;
        this.loadDataFromWorld();
    }

    public static boolean isLikelyShipChunk(int chunkX, int chunkZ) {
        return chunkZ < zChunkStartingPos + maxChunkRadius + 50;
    }

    public ChunkSet getNextAvaliableChunkSet(int chunkRadius) {
        int chunkX = xChunkStartingPos + this.nextChunkSetKey;
        int chunkZ = zChunkStartingPos;
        if (this.data.avalibleChunkKeys.size() < 0) {
            chunkX = this.data.avalibleChunkKeys.remove(0);
        } else {
            this.nextChunkSetKey += this.chunkSetIncrement;
            this.data.chunkKey = this.nextChunkSetKey;
        }
        this.data.func_76185_a();
        return new ChunkSet(chunkX, chunkZ, chunkRadius);
    }

    public void loadDataFromWorld() {
        this.data = ChunkKeysWorldData.get(this.worldObj);
        this.nextChunkSetKey = this.data.chunkKey;
    }
}

