/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.collision;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.EntityPolygon;
import valkyrienwarfare.collision.EntityPolygonCollider;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.collision.ShipPolygon;
import valkyrienwarfare.interaction.EntityDraggable;
import valkyrienwarfare.interaction.IDraggable;
import valkyrienwarfare.math.BigBastardMath;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.physicsmanagement.WorldPhysObjectManager;

public class EntityCollisionInjector {
    private static final double errorSignificance = 0.001;

    public static IntermediateMovementVariableStorage alterEntityMovement(Entity entity, MoverType type, double dx, double dy, double dz) {
        Vector dxyz;
        Vector velVec = new Vector(dx, dy, dz);
        double origDx = dx;
        double origDy = dy;
        double origDz = dz;
        double origPosX = entity.field_70165_t;
        double origPosY = entity.field_70163_u;
        double origPosZ = entity.field_70161_v;
        boolean isLiving = entity instanceof EntityLivingBase;
        boolean isMoving = false;
        if (isLiving) {
            EntityLivingBase living = (EntityLivingBase)entity;
            isMoving = (double)Math.abs(living.field_70701_bs) > 0.01 || (double)Math.abs(living.field_70702_br) > 0.01;
        }
        Vec3d velocity = new Vec3d(dx, dy, dz);
        EntityPolygon playerBeforeMove = new EntityPolygon(entity.func_174813_aQ(), entity);
        ArrayList<Polygon> colPolys = EntityCollisionInjector.getCollidingPolygonsAndDoBlockCols(entity, velocity);
        PhysicsWrapperEntity worldBelow = null;
        IDraggable draggable = EntityDraggable.getDraggableFromEntity(entity);
        Vector total = new Vector();
        double posOffestX = 0.0;
        double posOffestY = 0.0;
        double posOffestZ = 0.0;
        for (Polygon poly : colPolys) {
            if (!(poly instanceof ShipPolygon)) continue;
            ShipPolygon shipPoly = (ShipPolygon)poly;
            try {
                boolean isStep;
                EntityPolygonCollider fast = new EntityPolygonCollider(playerBeforeMove, shipPoly, shipPoly.normals, velVec.getAddition(total));
                if (fast.seperated) continue;
                worldBelow = shipPoly.shipFrom.wrapper;
                Vector response = fast.collisions[fast.minDistanceIndex].getResponse();
                double stepSquared = entity.field_70138_W * entity.field_70138_W;
                boolean bl = isStep = isLiving && entity.field_70122_E;
                if (response.Y >= 0.0 && BigBastardMath.canStandOnNormal(fast.potentialSeperatingAxes[fast.minDistanceIndex])) {
                    response = new Vector(0.0, -fast.collisions[fast.minDistanceIndex].penetrationDistance / fast.potentialSeperatingAxes[fast.minDistanceIndex].Y, 0.0);
                }
                if (isStep) {
                    EntityLivingBase living = (EntityLivingBase)entity;
                    if ((double)Math.abs(living.field_70701_bs) > 0.01 || (double)Math.abs(living.field_70702_br) > 0.01) {
                        for (int i = 3; i < 6; ++i) {
                            Vector tempResponse = fast.collisions[i].getResponse();
                            if (!(tempResponse.Y > 0.0) || !BigBastardMath.canStandOnNormal(fast.collisions[i].axis) || !(tempResponse.lengthSq() < stepSquared)) continue;
                            if (tempResponse.lengthSq() < 0.1) {
                                response = tempResponse;
                                continue;
                            }
                            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(tempResponse.X, tempResponse.Y, tempResponse.Z);
                            entity.func_174826_a(axisalignedbb);
                            response.zero();
                            entity.func_174829_m();
                        }
                    }
                }
                if (Math.abs(response.X) > 0.01) {
                    total.X += response.X;
                }
                if (Math.abs(response.Y) > 0.01) {
                    total.Y += response.Y;
                }
                if (Math.abs(response.Z) > 0.01) {
                    total.Z += response.Z;
                }
                entity.field_70165_t += response.X;
                entity.field_70163_u += response.Y;
                entity.field_70161_v += response.Z;
                posOffestX += response.X;
                posOffestY += response.Y;
                posOffestZ += response.Z;
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(response.X, response.Y, response.Z);
                entity.func_174826_a(axisalignedbb);
                entity.func_174829_m();
            }
            catch (Exception fast) {}
        }
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(-posOffestX, -posOffestY, -posOffestZ);
        entity.func_174826_a(axisalignedbb);
        entity.func_174829_m();
        draggable.setWorldBelowFeet(worldBelow);
        if (worldBelow == null) {
            return null;
        }
        boolean alreadyOnGround = entity.field_70122_E && (dy += total.Y) == origDy && origDy < 0.0;
        Vector original = new Vector(origDx, origDy, origDz);
        Vector newMov = new Vector((dx += total.X) - origDx, dy - origDy, (dz += total.Z) - origDz);
        entity.field_70123_F = original.dot(newMov) < 0.0;
        entity.field_70124_G = EntityCollisionInjector.isDifSignificant(dy, origDy);
        entity.field_70122_E = entity.field_70124_G && origDy < 0.0 || alreadyOnGround;
        entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
        double motionYBefore = entity.field_70181_x;
        float oldFallDistance = entity.field_70143_R;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase base = (EntityLivingBase)entity;
            base.field_70181_x = dy;
            if (base.func_70617_f_()) {
                boolean flag;
                float f9 = 0.15f;
                base.field_70159_w = MathHelper.func_151237_a((double)base.field_70159_w, (double)-0.15f, (double)0.15f);
                base.field_70179_y = MathHelper.func_151237_a((double)base.field_70179_y, (double)-0.15f, (double)0.15f);
                base.field_70143_R = 0.0f;
                if (base.field_70181_x < -0.15) {
                    base.field_70181_x = -0.15;
                }
                boolean bl = flag = base.func_70093_af() && base instanceof EntityPlayer;
                if (flag && base.field_70181_x < 0.0) {
                    base.field_70181_x = 0.0;
                }
            }
            dxyz = new Vector(dx, base.field_70181_x, dz);
        } else {
            dxyz = new Vector(dx, dy, dz);
        }
        Vector origDxyz = new Vector(origDx, origDy, origDz);
        Vector origPosXyz = new Vector(origPosX, origPosY, origPosZ);
        if (worldBelow != null) {
            // empty if block
        }
        return new IntermediateMovementVariableStorage(dxyz, origDxyz, origPosXyz, alreadyOnGround, motionYBefore, oldFallDistance);
    }

    public static void alterEntityMovementPost(Entity entity, IntermediateMovementVariableStorage storage) {
        int i5;
        int l4;
        double dx = storage.dxyz.X;
        double dy = storage.dxyz.Y;
        double dz = storage.dxyz.Z;
        double origDx = storage.origDxyz.X;
        double origDy = storage.origDxyz.Y;
        double origDz = storage.origDxyz.Z;
        double origPosX = storage.origPosXyz.X;
        double origPosY = storage.origPosXyz.Y;
        double origPosZ = storage.origPosXyz.Z;
        boolean alreadyOnGround = storage.alreadyOnGround;
        double motionYBefore = storage.motionYBefore;
        float oldFallDistance = storage.oldFallDistance;
        IDraggable draggable = EntityDraggable.getDraggableFromEntity(entity);
        PhysicsWrapperEntity worldBelow = draggable.getWorldBelowFeet();
        entity.field_70123_F = EntityCollisionInjector.motionInterfering(dx, origDx) || EntityCollisionInjector.motionInterfering(dz, origDz);
        entity.field_70124_G = EntityCollisionInjector.isDifSignificant(dy, origDy);
        entity.field_70122_E = entity.field_70124_G && origDy < 0.0 || alreadyOnGround || entity.field_70122_E;
        entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
        Vector entityPosInShip = new Vector(entity.field_70165_t, entity.field_70163_u - (double)0.2f, entity.field_70161_v, worldBelow.wrapping.coordTransform.wToLTransform);
        int j4 = MathHelper.func_76128_c((double)entityPosInShip.X);
        BlockPos blockpos = new BlockPos(j4, l4 = MathHelper.func_76128_c((double)entityPosInShip.Y), i5 = MathHelper.func_76128_c((double)entityPosInShip.Z));
        IBlockState iblockstate = entity.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (block instanceof BlockSlime && !entity.field_70134_J) {
            entity.field_70181_x = motionYBefore;
        }
        entity.field_70143_R = oldFallDistance;
        if (entity instanceof EntityLivingBase && !entity.field_70170_p.field_72995_K && entity.field_70143_R > 3.0f && entity.field_70122_E) {
            float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
            if (!iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)entity.field_70170_p, blockpos)) {
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(150.0 * d0);
                if (!iblockstate.func_177230_c().addLandingEffects(iblockstate, (WorldServer)entity.field_70170_p, blockpos, iblockstate, (EntityLivingBase)entity, i)) {
                    ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, i, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
                }
            }
        }
        if (entity.field_70122_E) {
            if (entity.field_70143_R > 0.0f) {
                iblockstate.func_177230_c().func_180658_a(entity.field_70170_p, blockpos, entity, entity.field_70143_R);
            }
            entity.field_70143_R = 0.0f;
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70143_R = (float)((double)entity.field_70143_R - entity.field_70181_x);
        }
        if (entity instanceof EntityPlayer && !entity.func_184218_aH()) {
            double d12 = entity.field_70165_t - origPosX;
            double d13 = entity.field_70163_u - origPosY;
            double d14 = entity.field_70161_v - origPosZ;
            if (block != Blocks.field_150468_ap) {
                d13 = 0.0;
            }
            if (dy != origDy) {
                block.func_176216_a(entity.field_70170_p, entity);
            }
            if (block != null && entity.field_70122_E) {
                block.func_176199_a(entity.field_70170_p, blockpos, entity);
            }
            if (entity.field_82151_R > (float)entity.field_70150_b && iblockstate.func_185904_a() != Material.field_151579_a) {
                entity.field_70150_b = (int)entity.field_82151_R + 1;
                SoundType soundtype = block.getSoundType(entity.field_70170_p.func_180495_p(blockpos), entity.field_70170_p, blockpos, entity);
                if (entity.field_70170_p.func_180495_p(blockpos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                    soundtype = Blocks.field_150431_aC.func_185467_w();
                    entity.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                } else if (!block.func_176223_P().func_185904_a().func_76224_d()) {
                    entity.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                }
            }
        }
        if (dx != origDx) {
            entity.field_70159_w = dx;
        }
        if (!(dy == origDy || entity.field_70181_x > 0.0 && dy > 0.0)) {
            entity.field_70181_x = 0.0;
        }
        if (dz != origDz) {
            entity.field_70179_y = dz;
        }
    }

    public static ArrayList<Polygon> getCollidingPolygonsAndDoBlockCols(Entity entity, Vec3d velocity) {
        ArrayList<Polygon> collisions = new ArrayList<Polygon>();
        AxisAlignedBB entityBB = entity.func_174813_aQ().func_72321_a(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c).func_72314_b(1.0, 1.0, 1.0);
        WorldPhysObjectManager localPhysManager = ValkyrienWarfareMod.physicsManager.getManagerForWorld(entity.field_70170_p);
        List<PhysicsWrapperEntity> ships = localPhysManager.getNearbyPhysObjects(entityBB);
        for (PhysicsWrapperEntity wrapper : ships) {
            try {
                if (entity.func_184223_x((Entity)wrapper)) continue;
                Polygon playerInLocal = new Polygon(entityBB, wrapper.wrapping.coordTransform.wToLTransform);
                AxisAlignedBB bb = playerInLocal.getEnclosedAABB();
                if ((bb.field_72336_d - bb.field_72340_a) * (bb.field_72334_f - bb.field_72339_c) > 9898989.0) break;
                List collidingBBs = entity.field_70170_p.func_184144_a(entity, bb);
                if (entity.field_70170_p.field_72995_K || entity instanceof EntityPlayer) {
                    BigBastardMath.mergeAABBList(collidingBBs);
                }
                for (AxisAlignedBB inLocal : collidingBBs) {
                    ShipPolygon poly = new ShipPolygon(inLocal, wrapper.wrapping.coordTransform.lToWTransform, wrapper.wrapping.coordTransform.normals, wrapper.wrapping);
                    collisions.add(poly);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (PhysicsWrapperEntity wrapper : ships) {
            if (entity.func_184223_x((Entity)wrapper)) continue;
            double posX = entity.field_70165_t;
            double posY = entity.field_70163_u;
            double posZ = entity.field_70161_v;
            Vector entityPos = new Vector(posX, posY, posZ);
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.wToLTransform, entityPos);
            EntityCollisionInjector.setEntityPositionAndUpdateBB(entity, entityPos.X, entityPos.Y, entityPos.Z);
            int entityChunkX = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
            int entityChunkZ = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
            if (wrapper.wrapping.ownsChunk(entityChunkX, entityChunkZ)) {
                Chunk chunkIn = wrapper.wrapping.claimedChunks[entityChunkX - wrapper.wrapping.claimedChunks[0][0].field_76635_g][entityChunkZ - wrapper.wrapping.claimedChunks[0][0].field_76647_h];
                int chunkYIndex = MathHelper.func_76128_c((double)(entity.field_70163_u / 16.0));
                if (chunkYIndex < 0) {
                    chunkYIndex = 0;
                }
                if (chunkYIndex >= chunkIn.field_76645_j.length) {
                    chunkYIndex = chunkIn.field_76645_j.length - 1;
                }
                chunkIn.field_76645_j[chunkYIndex].add((Object)entity);
                entity.func_145775_I();
                chunkIn.field_76645_j[chunkYIndex].remove((Object)entity);
            }
            EntityCollisionInjector.setEntityPositionAndUpdateBB(entity, posX, posY, posZ);
        }
        return collisions;
    }

    public static void setEntityPositionAndUpdateBB(Entity entity, double x, double y, double z) {
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        float f = entity.field_70130_N / 2.0f;
        float f1 = entity.field_70131_O;
        entity.field_70121_D = new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f);
    }

    private static boolean isDifSignificant(double dif1, double d2) {
        return !(Math.abs(dif1 - d2) < 0.001);
    }

    private static boolean motionInterfering(double orig, double modded) {
        return Math.signum(orig) != Math.signum(modded);
    }

    public static class IntermediateMovementVariableStorage {
        public Vector dxyz;
        public Vector origDxyz;
        public Vector origPosXyz;
        public boolean alreadyOnGround;
        public double motionYBefore;
        public float oldFallDistance;

        public IntermediateMovementVariableStorage(Vector dxyz, Vector origDxyz, Vector origPosXyz, boolean alreadyOnGround, double motionYBefore, float oldFallDistance) {
            this.dxyz = dxyz;
            this.origDxyz = origDxyz;
            this.origPosXyz = origPosXyz;
            this.alreadyOnGround = alreadyOnGround;
            this.motionYBefore = motionYBefore;
            this.oldFallDistance = oldFallDistance;
        }
    }
}

