/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.collision;

import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.Polygon;

public class EntityCollisionObject {
    public final Vector axis;
    public final Polygon movable;
    public final Polygon fixed;
    public double penetrationDistance;
    public boolean seperated;
    public double[] playerMinMax;
    public double[] blockMinMax;
    public Vector entityVelocity;
    public boolean originallyCollided = false;
    public double velDot;

    public EntityCollisionObject(Polygon movable_, Polygon stationary, Vector axes, Vector entityVel) {
        this.axis = axes;
        this.movable = movable_;
        this.fixed = stationary;
        this.entityVelocity = entityVel;
        this.generateCollision();
    }

    public void generateCollision() {
        double dot;
        this.velDot = -this.entityVelocity.dot(this.axis);
        double playerMin = dot = this.axis.dot(this.movable.vertices[0]);
        double playerMax = dot;
        for (int i = 1; i < this.movable.vertices.length; ++i) {
            dot = this.axis.dot(this.movable.vertices[i]);
            if (dot < playerMin) {
                playerMin = dot;
            }
            if (!(dot > playerMax)) continue;
            playerMax = dot;
        }
        double blockMin = dot = this.axis.dot(this.fixed.vertices[0]);
        double blockMax = dot;
        for (int i = 1; i < this.fixed.vertices.length; ++i) {
            dot = this.axis.dot(this.fixed.vertices[i]);
            if (dot < blockMin) {
                blockMin = dot;
            }
            if (!(dot > blockMax)) continue;
            blockMax = dot;
        }
        double movMaxFixMin = playerMin - blockMax;
        double movMinFixMax = playerMax - blockMin;
        boolean useDefault = true;
        if (movMaxFixMin > 0.0 || movMinFixMax < 0.0) {
            useDefault = false;
        } else {
            this.originallyCollided = true;
        }
        if (this.velDot > 0.0) {
            movMaxFixMin -= this.velDot;
        } else {
            movMinFixMax -= this.velDot;
        }
        if (movMaxFixMin > 0.0 || movMinFixMax < 0.0) {
            this.seperated = true;
            this.penetrationDistance = 0.0;
            return;
        }
        this.penetrationDistance = useDefault || this.velDot == 0.0 ? (Math.abs(movMaxFixMin) < Math.abs(movMinFixMax) ? movMaxFixMin : movMinFixMax) : (Math.signum(this.velDot) != Math.signum(movMinFixMax) ? movMinFixMax : movMaxFixMin);
        this.seperated = false;
    }

    public Vector getResponse() {
        return this.axis.getProduct(-this.penetrationDistance);
    }
}

