/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.collision;

import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.EntityCollisionObject;
import valkyrienwarfare.collision.EntityPolygon;
import valkyrienwarfare.collision.Polygon;

public class EntityPolygonCollider {
    public Vector[] potentialSeperatingAxes;
    public boolean seperated = false;
    public EntityCollisionObject[] collisions;
    public int minDistanceIndex;
    public double minDistance;
    public EntityPolygon entity;
    public Polygon block;
    public Vector entityVelocity;
    public boolean originallySeperated;

    public EntityPolygonCollider(EntityPolygon movable, Polygon stationary, Vector[] axes, Vector entityVel) {
        this.potentialSeperatingAxes = axes;
        this.entity = movable;
        this.block = stationary;
        this.entityVelocity = entityVel;
        this.processData();
    }

    public void processData() {
        int i;
        this.seperated = false;
        this.collisions = new EntityCollisionObject[this.potentialSeperatingAxes.length];
        for (i = 0; i < this.collisions.length; ++i) {
            if (this.seperated) continue;
            this.collisions[i] = new EntityCollisionObject(this.entity, this.block, this.potentialSeperatingAxes[i], this.entityVelocity);
            if (this.collisions[i].seperated) {
                this.seperated = true;
                break;
            }
            if (this.collisions[i].originallyCollided) continue;
            this.originallySeperated = true;
        }
        if (!this.seperated) {
            this.minDistance = 420.0;
            for (i = 0; i < this.collisions.length; ++i) {
                if (this.originallySeperated) {
                    if (!(Math.abs((this.collisions[i].penetrationDistance - this.collisions[i].velDot) / this.collisions[i].velDot) < this.minDistance) || this.collisions[i].originallyCollided) continue;
                    this.minDistanceIndex = i;
                    this.minDistance = Math.abs((this.collisions[i].penetrationDistance - this.collisions[i].velDot) / this.collisions[i].velDot);
                    continue;
                }
                if (!(Math.abs(this.collisions[i].penetrationDistance) < this.minDistance)) continue;
                this.minDistanceIndex = i;
                this.minDistance = Math.abs(this.collisions[i].penetrationDistance);
            }
        }
    }
}

