/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.collision;

import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.math.BigBastardMath;

public class PhysCollisionObject {
    public final Vector axis;
    public final Polygon movable;
    public final Polygon fixed;
    public double penetrationDistance;
    public boolean seperated;
    public double[] playerMinMax;
    public double[] blockMinMax;
    public double movMaxFixMin;
    public double movMinFixMax;
    public Vector firstContactPoint;

    public PhysCollisionObject(Polygon movable_, Polygon stationary, Vector axes) {
        this.axis = axes;
        this.movable = movable_;
        this.fixed = stationary;
        this.generateCollision();
    }

    public void generateCollision() {
        this.playerMinMax = BigBastardMath.getMinMaxOfArray(this.movable.getProjectionOnVector(this.axis));
        this.blockMinMax = BigBastardMath.getMinMaxOfArray(this.fixed.getProjectionOnVector(this.axis));
        this.movMaxFixMin = this.playerMinMax[0] - this.blockMinMax[1];
        this.movMinFixMax = this.playerMinMax[1] - this.blockMinMax[0];
        if (this.movMaxFixMin > 0.0 || this.movMinFixMax < 0.0) {
            this.seperated = true;
            this.penetrationDistance = 0.0;
            return;
        }
        if (Math.abs(this.movMaxFixMin) > Math.abs(this.movMinFixMax)) {
            this.penetrationDistance = this.movMinFixMax;
            for (Vector v : this.movable.vertices) {
                if (v.dot(this.axis) != this.playerMinMax[1]) continue;
                this.firstContactPoint = v;
            }
        } else {
            this.penetrationDistance = this.movMaxFixMin;
            for (Vector v : this.movable.vertices) {
                if (v.dot(this.axis) != this.playerMinMax[0]) continue;
                this.firstContactPoint = v;
            }
        }
        this.seperated = false;
    }

    public Vector getSecondContactPoint() {
        if (Math.abs(this.movMaxFixMin) > Math.abs(this.movMinFixMax)) {
            for (Vector v : this.fixed.vertices) {
                if (v.dot(this.axis) != this.blockMinMax[0]) continue;
                return v;
            }
        } else {
            for (Vector v : this.fixed.vertices) {
                if (v.dot(this.axis) != this.blockMinMax[1]) continue;
                return v;
            }
        }
        return null;
    }

    public Vector getResponse() {
        return this.axis.getProduct(this.penetrationDistance);
    }

    public void setResponse(Vector v) {
        v.X = this.axis.X * this.penetrationDistance;
        v.Y = this.axis.Y * this.penetrationDistance;
        v.Z = this.axis.Z * this.penetrationDistance;
    }
}

