/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.collision;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;

public class Polygon {
    public final Vector[] vertices;
    final boolean isAxisAligned;
    public Vector velocity = new Vector(0.0, 0.0, 0.0);

    public Polygon(AxisAlignedBB bb, double[] rotationMatrix) {
        this.vertices = Polygon.getCornersForAABB(bb);
        this.isAxisAligned = false;
        for (int i = 0; i < this.vertices.length; ++i) {
            RotationMatrices.applyTransform(rotationMatrix, this.vertices[i]);
        }
    }

    public Polygon(Entity entity, double dx, double dy, double dz) {
        this(entity.func_174813_aQ());
        this.velocity = new Vector(dx, dy, dz);
    }

    public Polygon(Vector[] points) {
        this.vertices = points;
        this.isAxisAligned = false;
    }

    public Polygon(List<Polygon> polysToMerge) {
        int totalVertices = 0;
        for (Polygon p : polysToMerge) {
            totalVertices += p.vertices.length;
        }
        this.vertices = new Vector[totalVertices];
        totalVertices = 0;
        for (Polygon p : polysToMerge) {
            Vector[] vectorArray = p.vertices;
            int n = vectorArray.length;
            for (int i = 0; i < n; ++i) {
                Vector v;
                this.vertices[totalVertices] = v = vectorArray[i];
                ++totalVertices;
            }
        }
        this.isAxisAligned = false;
    }

    public Polygon(AxisAlignedBB bb) {
        this.vertices = Polygon.getCornersForAABB(bb);
        this.isAxisAligned = true;
    }

    public static Vector[] getCornersForAABB(AxisAlignedBB bb) {
        return new Vector[]{new Vector(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), new Vector(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c), new Vector(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), new Vector(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f), new Vector(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vector(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c), new Vector(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f), new Vector(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f)};
    }

    public void setAABBAndMatrix(AxisAlignedBB bb, double[] matrix) {
        this.setAABBCorners(bb);
        RotationMatrices.applyTransform(matrix, this.vertices[0]);
        RotationMatrices.applyTransform(matrix, this.vertices[1]);
        RotationMatrices.applyTransform(matrix, this.vertices[2]);
        RotationMatrices.applyTransform(matrix, this.vertices[3]);
        RotationMatrices.applyTransform(matrix, this.vertices[4]);
        RotationMatrices.applyTransform(matrix, this.vertices[5]);
        RotationMatrices.applyTransform(matrix, this.vertices[6]);
        RotationMatrices.applyTransform(matrix, this.vertices[7]);
    }

    public void setAABBCorners(AxisAlignedBB bb) {
        this.vertices[0].X = bb.field_72340_a;
        this.vertices[0].Y = bb.field_72338_b;
        this.vertices[0].Z = bb.field_72339_c;
        this.vertices[1].X = bb.field_72340_a;
        this.vertices[1].Y = bb.field_72337_e;
        this.vertices[1].Z = bb.field_72339_c;
        this.vertices[2].X = bb.field_72340_a;
        this.vertices[2].Y = bb.field_72338_b;
        this.vertices[2].Z = bb.field_72334_f;
        this.vertices[3].X = bb.field_72340_a;
        this.vertices[3].Y = bb.field_72337_e;
        this.vertices[3].Z = bb.field_72334_f;
        this.vertices[4].X = bb.field_72336_d;
        this.vertices[4].Y = bb.field_72338_b;
        this.vertices[4].Z = bb.field_72339_c;
        this.vertices[5].X = bb.field_72336_d;
        this.vertices[5].Y = bb.field_72337_e;
        this.vertices[5].Z = bb.field_72339_c;
        this.vertices[6].X = bb.field_72336_d;
        this.vertices[6].Y = bb.field_72338_b;
        this.vertices[6].Z = bb.field_72334_f;
        this.vertices[7].X = bb.field_72336_d;
        this.vertices[7].Y = bb.field_72337_e;
        this.vertices[7].Z = bb.field_72334_f;
    }

    public void offsetCorners(AxisAlignedBB bb, double x, double y, double z) {
        this.vertices[0].X = bb.field_72340_a + x;
        this.vertices[0].Y = bb.field_72338_b + y;
        this.vertices[0].Z = bb.field_72339_c + z;
        this.vertices[1].X = bb.field_72340_a + x;
        this.vertices[1].Y = bb.field_72337_e + y;
        this.vertices[1].Z = bb.field_72339_c + z;
        this.vertices[2].X = bb.field_72340_a + x;
        this.vertices[2].Y = bb.field_72338_b + y;
        this.vertices[2].Z = bb.field_72334_f + z;
        this.vertices[3].X = bb.field_72340_a + x;
        this.vertices[3].Y = bb.field_72337_e + y;
        this.vertices[3].Z = bb.field_72334_f + z;
        this.vertices[4].X = bb.field_72336_d + x;
        this.vertices[4].Y = bb.field_72338_b + y;
        this.vertices[4].Z = bb.field_72339_c + z;
        this.vertices[5].X = bb.field_72336_d + x;
        this.vertices[5].Y = bb.field_72337_e + y;
        this.vertices[5].Z = bb.field_72339_c + z;
        this.vertices[6].X = bb.field_72336_d + x;
        this.vertices[6].Y = bb.field_72338_b + y;
        this.vertices[6].Z = bb.field_72334_f + z;
        this.vertices[7].X = bb.field_72336_d + x;
        this.vertices[7].Y = bb.field_72337_e + y;
        this.vertices[7].Z = bb.field_72334_f + z;
    }

    public void offsetCornersAndTransform(AxisAlignedBB aabb, double x, double y, double z, double[] matrix) {
        this.offsetCorners(aabb, x, y, z);
        RotationMatrices.applyTransform(matrix, this.vertices[0]);
        RotationMatrices.applyTransform(matrix, this.vertices[1]);
        RotationMatrices.applyTransform(matrix, this.vertices[2]);
        RotationMatrices.applyTransform(matrix, this.vertices[3]);
        RotationMatrices.applyTransform(matrix, this.vertices[4]);
        RotationMatrices.applyTransform(matrix, this.vertices[5]);
        RotationMatrices.applyTransform(matrix, this.vertices[6]);
        RotationMatrices.applyTransform(matrix, this.vertices[7]);
    }

    public double[] getProjectionOnVector(Vector axis) {
        double[] distances = new double[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            distances[i] = axis.dot(this.vertices[i]);
        }
        return distances;
    }

    public Vector getCenter() {
        Vector center = new Vector(0.0, 0.0, 0.0);
        for (Vector v : this.vertices) {
            center.add(v);
        }
        center.multiply(1.0 / (double)this.vertices.length);
        return center;
    }

    public AxisAlignedBB getEnclosedAABB() {
        Vector c = this.vertices[0];
        double x = c.X;
        double y = c.Y;
        double z = c.Z;
        double mnX = x;
        double mnY = y;
        double mnZ = z;
        double mxX = x;
        double mxY = y;
        double mxZ = z;
        for (int i = 0; i < this.vertices.length; ++i) {
            c = this.vertices[i];
            x = c.X;
            y = c.Y;
            z = c.Z;
            if (mnX > x) {
                mnX = x;
            }
            if (mnY > y) {
                mnY = y;
            }
            if (mnZ > z) {
                mnZ = z;
            }
            if (mxX < x) {
                mxX = x;
            }
            if (mxY < y) {
                mxY = y;
            }
            if (!(mxZ < z)) continue;
            mxZ = z;
        }
        return new AxisAlignedBB(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }
}

