/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.collision;

import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.math.BigBastardMath;

public class ReverseEntityCollisionObject {
    public final Vector axis;
    public final Polygon movable;
    public final Polygon fixed;
    public double penetrationDistance;
    public boolean seperated;
    public double[] playerMinMax;
    public double[] blockMinMax;
    public Vector entityVelocity;

    public ReverseEntityCollisionObject(Polygon movable_, Polygon stationary, Vector axes, Vector entityVel) {
        this.axis = axes;
        this.movable = movable_;
        this.fixed = stationary;
        this.entityVelocity = entityVel;
        this.generateCollision();
    }

    public void generateCollision() {
        this.playerMinMax = BigBastardMath.getMinMaxOfArray(this.movable.getProjectionOnVector(this.axis));
        this.blockMinMax = BigBastardMath.getMinMaxOfArray(this.fixed.getProjectionOnVector(this.axis));
        double movMaxFixMin = this.playerMinMax[0] - this.blockMinMax[1];
        double movMinFixMax = this.playerMinMax[1] - this.blockMinMax[0];
        if (movMaxFixMin > 0.0 || movMinFixMax < 0.0) {
            this.seperated = true;
            this.penetrationDistance = 0.0;
            return;
        }
        this.penetrationDistance = Math.abs(movMaxFixMin) < Math.abs(movMinFixMax) ? movMaxFixMin : movMinFixMax;
        this.seperated = false;
    }

    public Vector getResponse() {
        return this.axis.getProduct(-this.penetrationDistance);
    }
}

