/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.collision;

import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.collision.ReverseEntityCollisionObject;

public class ReverseEntityPolyCollider {
    public Vector[] potentialSeperatingAxes;
    public boolean seperated = false;
    public ReverseEntityCollisionObject[] collisions;
    public int minDistanceIndex;
    public double minDistance;
    public Polygon entity;
    public Polygon block;
    public Vector entityVelocity;
    public boolean originallySeperated;
    public int minIndexInReverse;

    public ReverseEntityPolyCollider(Polygon movable, Polygon stationary, Vector[] axes, Vector entityVel) {
        this.potentialSeperatingAxes = axes;
        this.entity = movable;
        this.block = stationary;
        this.entityVelocity = entityVel;
        this.processData();
    }

    public void processData() {
        this.seperated = false;
        this.collisions = new ReverseEntityCollisionObject[this.potentialSeperatingAxes.length];
        for (int i = 0; i < this.collisions.length; ++i) {
            if (this.seperated) continue;
            this.collisions[i] = new ReverseEntityCollisionObject(this.entity, this.block, this.potentialSeperatingAxes[i], this.entityVelocity);
            if (!this.collisions[i].seperated) continue;
            this.seperated = true;
            break;
        }
        if (!this.seperated) {
            this.minDistance = 420.0;
            double minNegativeImpactTime = 0.0;
            for (int i = 0; i < this.collisions.length; ++i) {
                double velDot;
                double negativeTime;
                if (Math.abs(this.collisions[i].penetrationDistance) < this.minDistance) {
                    this.minDistanceIndex = i;
                    this.minDistance = Math.abs(this.collisions[i].penetrationDistance);
                }
                if (!((negativeTime = -(velDot = this.collisions[i].axis.dot(this.entityVelocity)) / this.collisions[i].penetrationDistance) < minNegativeImpactTime)) continue;
                minNegativeImpactTime = negativeTime;
                this.minIndexInReverse = i;
            }
            if (this.entityVelocity.isZero()) {
                this.minIndexInReverse = this.minDistanceIndex;
            }
        }
    }
}

