/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class AirshipSettingsCommand
extends CommandBase {
    public static final ArrayList<String> completionOptions = new ArrayList();

    public static RayTraceResult rayTraceBothSides(EntityPlayer player, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public String func_71517_b() {
        return "airshipSettings";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/airshipSettings <setting name> [value]\nAvaliable Settings: [transfer, allowPlayer, claim]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayer p;
        if (!(sender instanceof EntityPlayer)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You need to be a player to do that!"));
            return;
        }
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Usage: " + this.func_71518_a(sender)));
            return;
        }
        BlockPos pos = AirshipSettingsCommand.rayTraceBothSides(p, (p = (EntityPlayer)sender).func_184812_l_() ? 5.0 : 4.5, 1.0f).func_178782_a();
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(p.func_130014_f_(), pos);
        if (wrapper == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You need to be looking at an airship to do that!"));
            return;
        }
        if (p.field_96093_i.toString().equals(wrapper.wrapping.creator)) {
            if (args[0].equals("transfer")) {
                if (args.length == 1) {
                    return;
                }
                if (!args[1].isEmpty()) {
                    EntityPlayerMP target = server.func_184103_al().func_152612_a(args[1]);
                    if (target == null) {
                        p.func_145747_a((ITextComponent)new TextComponentString("That player is not online!"));
                        return;
                    }
                    switch (wrapper.wrapping.changeOwner((EntityPlayer)target)) {
                        case ERROR_IMPOSSIBLE_STATUS: {
                            p.func_145747_a((ITextComponent)new TextComponentString("An error occured, please report to mod devs"));
                            break;
                        }
                        case ERROR_NEWOWNER_NOT_ENOUGH: {
                            p.func_145747_a((ITextComponent)new TextComponentString("That player doesn't have enough free airship slots!"));
                            break;
                        }
                        case SUCCESS: {
                            p.func_145747_a((ITextComponent)new TextComponentString("Success! " + target.func_70005_c_() + " is the new owner of this airship!"));
                            break;
                        }
                        case ALREADY_CLAIMED: {
                            p.func_145747_a((ITextComponent)new TextComponentString("Airship already claimed"));
                        }
                    }
                    return;
                }
            } else if (args[0].equals("allowPlayer")) {
                if (args.length == 1) {
                    StringBuilder result = new StringBuilder("<");
                    Iterator<String> iter = wrapper.wrapping.allowedUsers.iterator();
                    while (iter.hasNext()) {
                        result.append(iter.next() + (iter.hasNext() ? ", " : ">"));
                    }
                    p.func_145747_a((ITextComponent)new TextComponentString(result.toString()));
                    return;
                }
                if (!args[1].isEmpty()) {
                    EntityPlayerMP target = server.func_184103_al().func_152612_a(args[1]);
                    if (target == null) {
                        p.func_145747_a((ITextComponent)new TextComponentString("That player is not online!"));
                        return;
                    }
                    if (target.field_96093_i.toString().equals(wrapper.wrapping.creator)) {
                        p.func_145747_a((ITextComponent)new TextComponentString("You can't add yourself to your own airship!"));
                        return;
                    }
                    wrapper.wrapping.allowedUsers.add(target.field_96093_i.toString());
                    p.func_145747_a((ITextComponent)new TextComponentString("Success! " + target.func_70005_c_() + " can now interact with this airship!"));
                    return;
                }
            }
        } else {
            if ((wrapper.wrapping.creator == null || wrapper.wrapping.creator.trim().isEmpty()) && args.length == 1 && args[0].equals("claim")) {
                wrapper.wrapping.creator = p.field_96093_i.toString();
                p.func_145747_a((ITextComponent)new TextComponentString("You've successfully claimed an airship!"));
                return;
            }
            p.func_145747_a((ITextComponent)new TextComponentString("You need to be the owner of an airship to change airship settings!"));
        }
        if (args[0].equals("help")) {
            for (String command : completionOptions) {
                sender.func_145747_a((ITextComponent)new TextComponentString(command));
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Usage: " + this.func_71518_a(sender)));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            ArrayList possibleArgs = (ArrayList)completionOptions.clone();
            Iterator iterator = possibleArgs.iterator();
            while (iterator.hasNext()) {
                if (((String)iterator.next()).startsWith(args[0])) continue;
                iterator.remove();
            }
            return possibleArgs;
        }
        if (args.length == 2 && args[0].startsWith("do")) {
            if (args[1].startsWith("t")) {
                return Lists.newArrayList((Object[])new String[]{"true"});
            }
            if (args[1].startsWith("f")) {
                return Lists.newArrayList((Object[])new String[]{"false"});
            }
            return Lists.newArrayList((Object[])new String[]{"true", "false"});
        }
        return null;
    }

    static {
        completionOptions.add("transfer");
        completionOptions.add("allowPlayer");
        completionOptions.add("claim");
    }
}

