/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import valkyrienwarfare.PhysicsSettings;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.Vector;

public class PhysSettingsCommand
extends CommandBase {
    public static final ArrayList<String> completionOptions = new ArrayList();

    public String func_71517_b() {
        return "physSettings";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/physSettings <setting name> [value]";
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String key;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Avaliable physics Commands:"));
            for (String command : completionOptions) {
                sender.func_145747_a((ITextComponent)new TextComponentString(command));
            }
        }
        if ((key = args[0]).equals("doSplitting")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("doSplitting=" + ValkyrienWarfareMod.doSplitting + " (Default: false)"));
                return;
            }
            if (args.length == 2) {
                boolean value;
                ValkyrienWarfareMod.doSplitting = value = Boolean.parseBoolean(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set physics splitting to " + value));
                return;
            }
        } else if (key.equals("maxShipSize")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("maxShipSize=" + ValkyrienWarfareMod.maxShipSize + " (Default: 15000)"));
                return;
            }
            if (args.length == 2) {
                int value;
                ValkyrienWarfareMod.maxShipSize = value = Integer.parseInt(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set maximum ship size to " + value));
                return;
            }
        } else if (key.equals("gravityVector")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("gravityVector=" + ValkyrienWarfareMod.gravity.toRoundedString() + " (Default: <0,-9.8,0>)"));
                return;
            }
            if (args.length == 4) {
                Vector newVector = new Vector(0.0, -9.8, 0.0);
                try {
                    if (args[1] == null || args[2] == null || args[3] == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /physSettings gravityVector <x> <y> <z>"));
                        return;
                    }
                    newVector.X = Double.parseDouble(args[1]);
                    newVector.Y = Double.parseDouble(args[2]);
                    newVector.Z = Double.parseDouble(args[3]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ValkyrienWarfareMod.gravity = newVector;
                sender.func_145747_a((ITextComponent)new TextComponentString("physics gravity set to " + newVector.toRoundedString() + " (Default: <0,-9.8,0>)"));
                return;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /physSettings gravityVector <x> <y> <z>"));
        } else if (key.equals("physicsIterations")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("physicsIterations=" + ValkyrienWarfareMod.physIter + " (Default: 10)"));
                return;
            }
            if (args.length == 2) {
                int value = Integer.parseInt(args[1]);
                if (value < 0 || value > 1000) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Please enter a value between 0 and 1000"));
                    return;
                }
                ValkyrienWarfareMod.physIter = value;
                sender.func_145747_a((ITextComponent)new TextComponentString("Set physicsIterations to " + value));
                return;
            }
        } else if (key.equals("physicsSpeed")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("physicsSpeed=" + ValkyrienWarfareMod.physSpeed + " (Default: 100%)"));
                return;
            }
            if (args.length == 2) {
                double value = Double.parseDouble(args[1].replace('%', ' '));
                if (value < 0.0 || value > 1000.0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Please enter a value between 0 and 1000"));
                    return;
                }
                ValkyrienWarfareMod.physSpeed = value * 0.05 / 100.0;
                sender.func_145747_a((ITextComponent)new TextComponentString("Set physicsSpeed to " + value + " percent"));
                return;
            }
        } else if (key.equals("doGravity")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("doGravity=" + PhysicsSettings.doGravity + " (Default: true)"));
                return;
            }
            if (args.length == 2) {
                boolean value;
                PhysicsSettings.doGravity = value = Boolean.parseBoolean(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set doGravity to " + (PhysicsSettings.doGravity ? "enabled" : "disabled")));
                return;
            }
        } else if (key.equals("doPhysicsBlocks")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("doPhysicsBlocks=" + PhysicsSettings.doPhysicsBlocks + " (Default: true)"));
                return;
            }
            if (args.length == 2) {
                boolean value;
                PhysicsSettings.doPhysicsBlocks = value = Boolean.parseBoolean(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set doPhysicsBlocks to " + (PhysicsSettings.doPhysicsBlocks ? "enabled" : "disabled")));
                return;
            }
        } else if (key.equals("doBalloons")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("doBalloons=" + PhysicsSettings.doBalloons + " (Default: true)"));
                return;
            }
            if (args.length == 2) {
                boolean value;
                PhysicsSettings.doBalloons = value = Boolean.parseBoolean(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set doBalloons to " + (PhysicsSettings.doBalloons ? "enabled" : "disabled")));
                return;
            }
        } else if (key.equals("doAirshipRotation")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("doAirshipRotation=" + PhysicsSettings.doAirshipRotation + " (Default: true)"));
                return;
            }
            if (args.length == 2) {
                boolean value;
                PhysicsSettings.doAirshipRotation = value = Boolean.parseBoolean(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set doAirshipRotation to " + (PhysicsSettings.doAirshipRotation ? "enabled" : "disabled")));
                return;
            }
        } else if (key.equals("doAirshipMovement")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("doAirshipMovement=" + PhysicsSettings.doAirshipMovement + " (Default: true)"));
                return;
            }
            if (args.length == 2) {
                boolean value;
                PhysicsSettings.doAirshipMovement = value = Boolean.parseBoolean(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set doAirshipMovement to " + (PhysicsSettings.doAirshipMovement ? "enabled" : "disabled")));
                return;
            }
        } else if (key.equals("doEtheriumLifting")) {
            if (args.length == 1) {
                sender.func_145747_a((ITextComponent)new TextComponentString("doEtheriumLifting=" + PhysicsSettings.doEtheriumLifting + " (Default: true)"));
                return;
            }
            if (args.length == 2) {
                boolean value;
                PhysicsSettings.doEtheriumLifting = value = Boolean.parseBoolean(args[1]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set doEtheriumLifting to " + (PhysicsSettings.doEtheriumLifting ? "enabled" : "disabled")));
                return;
            }
        } else {
            if (key.equals("save")) {
                ValkyrienWarfareMod.INSTANCE.saveConfig();
                sender.func_145747_a((ITextComponent)new TextComponentString("Saved phyisics settings"));
                return;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Avaliable physics Commands:"));
            for (String command : completionOptions) {
                sender.func_145747_a((ITextComponent)new TextComponentString(command));
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            ArrayList possibleArgs = (ArrayList)completionOptions.clone();
            Iterator iterator = possibleArgs.iterator();
            while (iterator.hasNext()) {
                if (((String)iterator.next()).startsWith(args[0])) continue;
                iterator.remove();
            }
            return possibleArgs;
        }
        if (args.length == 2 && args[0].startsWith("do")) {
            if (args[1].startsWith("t")) {
                return Lists.newArrayList((Object[])new String[]{"true"});
            }
            if (args[1].startsWith("f")) {
                return Lists.newArrayList((Object[])new String[]{"false"});
            }
            return Lists.newArrayList((Object[])new String[]{"true", "false"});
        }
        return null;
    }

    static {
        completionOptions.add("gravityVector");
        completionOptions.add("doSplitting");
        completionOptions.add("maxShipSize");
        completionOptions.add("physicsIterations");
        completionOptions.add("physicsSpeed");
        completionOptions.add("doGravity");
        completionOptions.add("doPhysicsBlocks");
        completionOptions.add("doBalloons");
        completionOptions.add("doAirshipRotation");
        completionOptions.add("doAirshipMovement");
        completionOptions.add("save");
        completionOptions.add("doEtheriumLifting");
    }
}

