/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.interaction;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import valkyrienwarfare.NBTUtils;
import valkyrienwarfare.chunkmanagement.ChunkSet;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class BlockPosToShipUUIDData
extends WorldSavedData {
    private static final String key = "BlockPosToShipUUIDData";
    private HashMap<Long, UUID> chunkposToShipUUID = new HashMap();
    private HashMap<UUID, ChunkSet> UUIDToChunkSet = new HashMap();

    public BlockPosToShipUUIDData(String name) {
        super(name);
    }

    public BlockPosToShipUUIDData() {
        super(key);
    }

    public static BlockPosToShipUUIDData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        BlockPosToShipUUIDData data = (BlockPosToShipUUIDData)storage.func_75742_a(BlockPosToShipUUIDData.class, key);
        if (data == null) {
            data = new BlockPosToShipUUIDData();
            world.func_72823_a(key, (WorldSavedData)data);
        }
        return data;
    }

    public UUID getShipUUIDFromPos(int chunkX, int ChunkZ) {
        long chunkPos = ChunkPos.func_77272_a((int)chunkX, (int)ChunkZ);
        return this.chunkposToShipUUID.get(chunkPos);
    }

    public void addShipToPersistantMap(PhysicsWrapperEntity toAdd) {
        UUID shipID = toAdd.getPersistentID();
        int centerX = toAdd.wrapping.ownedChunks.centerX;
        int centerZ = toAdd.wrapping.ownedChunks.centerZ;
        int radius = toAdd.wrapping.ownedChunks.radius;
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                long chunkPos = ChunkPos.func_77272_a((int)x, (int)z);
                this.chunkposToShipUUID.put(chunkPos, shipID);
            }
        }
        this.UUIDToChunkSet.put(toAdd.getPersistentID(), toAdd.wrapping.ownedChunks);
        this.func_76185_a();
    }

    public void removeShipFromPersistantMap(PhysicsWrapperEntity toRemove) {
        int centerX = toRemove.wrapping.ownedChunks.centerX;
        int centerZ = toRemove.wrapping.ownedChunks.centerZ;
        int radius = toRemove.wrapping.ownedChunks.radius;
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                long chunkPos = ChunkPos.func_77272_a((int)x, (int)z);
                this.chunkposToShipUUID.remove(chunkPos);
            }
        }
        this.UUIDToChunkSet.remove(toRemove.getPersistentID());
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound compound) {
        ByteBuffer buffer = NBTUtils.getByteBuf("WorldChunkSetUUIDMix", compound);
        while (buffer.hasRemaining()) {
            int centerX = buffer.getInt();
            int centerZ = buffer.getInt();
            byte radius = buffer.get();
            long mostBits = buffer.getLong();
            long leastBits = buffer.getLong();
            UUID persistantID = new UUID(mostBits, leastBits);
            ChunkSet set = new ChunkSet(centerX, centerZ, radius);
            this.UUIDToChunkSet.put(persistantID, set);
            for (int x = centerX - radius; x <= centerX + radius; ++x) {
                for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                    this.chunkposToShipUUID.put(ChunkPos.func_77272_a((int)x, (int)z), persistantID);
                }
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        Set<Map.Entry<UUID, ChunkSet>> entries = this.UUIDToChunkSet.entrySet();
        int byteArraySize = entries.size() * 25;
        ByteBuffer buffer = ByteBuffer.allocate(byteArraySize);
        for (Map.Entry<UUID, ChunkSet> entry : entries) {
            int centerX = entry.getValue().centerX;
            int centerZ = entry.getValue().centerZ;
            byte radius = (byte)entry.getValue().radius;
            long mostBits = entry.getKey().getMostSignificantBits();
            long leastBits = entry.getKey().getLeastSignificantBits();
            buffer.putInt(centerX);
            buffer.putInt(centerZ);
            buffer.put(radius);
            buffer.putLong(mostBits);
            buffer.putLong(leastBits);
        }
        NBTUtils.setByteBuf("WorldChunkSetUUIDMix", buffer, compound);
        return compound;
    }
}

