/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.interaction;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import valkyrienwarfare.NBTUtils;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class ShipNameUUIDData
extends WorldSavedData {
    private static final String key = "ShipNameUUIDData";
    public HashMap<String, Long> ShipNameToLongMap = new HashMap();

    public ShipNameUUIDData(String name) {
        super(name);
    }

    public ShipNameUUIDData() {
        this(key);
    }

    public static ShipNameUUIDData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        ShipNameUUIDData data = (ShipNameUUIDData)storage.func_75742_a(ShipNameUUIDData.class, key);
        if (data == null) {
            data = new ShipNameUUIDData();
            world.func_72823_a(key, (WorldSavedData)data);
        }
        return data;
    }

    public void placeShipInRegistry(PhysicsWrapperEntity wrapper, String defaultName) {
        this.ShipNameToLongMap.put(defaultName, wrapper.getPersistentID().getMostSignificantBits());
        this.func_76185_a();
    }

    public boolean renameShipInRegsitry(PhysicsWrapperEntity wrapper, String newName, String oldName) {
        if (this.ShipNameToLongMap.containsKey(newName)) {
            return false;
        }
        this.ShipNameToLongMap.put(newName, wrapper.getPersistentID().getMostSignificantBits());
        this.ShipNameToLongMap.remove(oldName);
        this.func_76185_a();
        return true;
    }

    public void removeShipFromRegistry(PhysicsWrapperEntity wrapper) {
        String customName = wrapper.func_95999_t();
        this.ShipNameToLongMap.remove(customName);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        ByteBuffer buffer = NBTUtils.getByteBuf("NameToUUIDMap", nbt);
        while (buffer.hasRemaining()) {
            int stringByteLength = buffer.get();
            byte[] stringBytes = new byte[stringByteLength];
            for (int i = 0; i < stringByteLength; ++i) {
                stringBytes[i] = buffer.get();
            }
            String shipName = new String(stringBytes, StandardCharsets.UTF_8);
            long shipUUIDMostSig = buffer.getLong();
            this.ShipNameToLongMap.put(shipName, shipUUIDMostSig);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        Set<Map.Entry<String, Long>> entryMap = this.ShipNameToLongMap.entrySet();
        int stringEntriesSize = 0;
        for (Map.Entry<String, Long> entry : entryMap) {
            byte[] stringBytes = entry.getKey().getBytes(StandardCharsets.UTF_8);
            stringEntriesSize += stringBytes.length + 9;
        }
        ByteBuffer buffer = ByteBuffer.allocate(stringEntriesSize);
        for (Map.Entry<String, Long> entry : entryMap) {
            byte[] stringBytes = entry.getKey().getBytes(StandardCharsets.UTF_8);
            buffer.put((byte)stringBytes.length);
            for (byte b : stringBytes) {
                buffer.put(b);
            }
            buffer.putLong(entry.getValue());
        }
        NBTUtils.setByteBuf("NameToUUIDMap", buffer, compound);
        return compound;
    }
}

