/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.interaction;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import valkyrienwarfare.NBTUtils;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class ShipUUIDToPosData
extends WorldSavedData {
    private static String key = "ShipUUIDToPosData";
    private HashMap<Long, ShipPositionData> dataMap = new HashMap();

    public ShipUUIDToPosData(String name) {
        super(name);
    }

    public ShipUUIDToPosData() {
        super(key);
    }

    public static ShipUUIDToPosData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        ShipUUIDToPosData data = (ShipUUIDToPosData)storage.func_75742_a(ShipUUIDToPosData.class, key);
        if (data == null) {
            data = new ShipUUIDToPosData();
            world.func_72823_a(key, (WorldSavedData)data);
        }
        return data;
    }

    public ShipPositionData getShipPositionData(UUID shipID) {
        return this.dataMap.get(shipID.getMostSignificantBits());
    }

    public ShipPositionData getShipPositionData(long mostSigBits) {
        return this.dataMap.get(mostSigBits);
    }

    public void updateShipPosition(PhysicsWrapperEntity wrapper) {
        UUID entityID = wrapper.getPersistentID();
        long key = entityID.getMostSignificantBits();
        ShipPositionData data = this.dataMap.get(key);
        if (data != null) {
            data.updateData(wrapper);
        } else {
            data = new ShipPositionData(wrapper);
            this.dataMap.put(key, data);
        }
        this.func_76185_a();
    }

    public void removeShipFromMap(PhysicsWrapperEntity wrapper) {
        UUID entityID = wrapper.getPersistentID();
        this.dataMap.remove(entityID);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        ByteBuffer buffer = NBTUtils.getByteBuf("ShipPositionByteBuf", nbt);
        while (buffer.hasRemaining()) {
            long mostBits = buffer.getLong();
            ShipPositionData data = new ShipPositionData(buffer);
            this.dataMap.put(mostBits, data);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        Set<Map.Entry<Long, ShipPositionData>> entries = this.dataMap.entrySet();
        int byteArraySize = entries.size() * 84;
        ByteBuffer buffer = ByteBuffer.allocate(byteArraySize);
        for (Map.Entry<Long, ShipPositionData> entry : entries) {
            long mostBits = entry.getKey();
            ShipPositionData posData = entry.getValue();
            buffer.putLong(mostBits);
            posData.writeToByteBuffer(buffer);
        }
        NBTUtils.setByteBuf("ShipPositionByteBuf", buffer, compound);
        return compound;
    }

    public Set<Long> getShipHalfUUIDsSet() {
        return this.dataMap.keySet();
    }

    public class ShipPositionData {
        public Vector shipPosition;
        public float[] lToWTransform;

        public ShipPositionData(PhysicsWrapperEntity wrapper) {
            this.shipPosition = new Vector(wrapper.field_70165_t, wrapper.field_70163_u, wrapper.field_70161_v);
            this.lToWTransform = RotationMatrices.convertToFloat(wrapper.wrapping.coordTransform.lToWTransform);
        }

        public ShipPositionData(ByteBuffer buffer) {
            this.shipPosition = new Vector(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
            this.lToWTransform = new float[16];
            for (int i = 0; i < 16; ++i) {
                this.lToWTransform[i] = buffer.getFloat();
            }
        }

        public void writeToByteBuffer(ByteBuffer buffer) {
            buffer.putFloat((float)this.shipPosition.X);
            buffer.putFloat((float)this.shipPosition.Y);
            buffer.putFloat((float)this.shipPosition.Z);
            for (int i = 0; i < 16; ++i) {
                buffer.putFloat(this.lToWTransform[i]);
            }
        }

        public void updateData(PhysicsWrapperEntity wrapper) {
            this.shipPosition.X = wrapper.field_70165_t;
            this.shipPosition.Y = wrapper.field_70163_u;
            this.shipPosition.Z = wrapper.field_70161_v;
            this.lToWTransform = RotationMatrices.convertToFloat(wrapper.wrapping.coordTransform.lToWTransform);
        }
    }
}

