/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.interaction;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockBreakAnim;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.combat.entity.EntityMountingWeaponBase;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class ValkyrienWarfareWorldEventListener
implements IWorldEventListener {
    private World worldObj;

    public ValkyrienWarfareWorldEventListener(World world) {
        this.worldObj = world;
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.worldObj, pos);
        if (this.worldObj.field_72995_K) {
            worldIn.func_147458_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (wrapper != null) {
                wrapper.wrapping.onSetBlockState(oldState, newState, pos);
            }
        } else if (wrapper != null) {
            // empty if block
        }
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
        int oldChunkX = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
        int oldChunkZ = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
        BlockPos posAt = new BlockPos(entityIn);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.worldObj, posAt);
        if (!(entityIn instanceof EntityFallingBlock) && wrapper != null && wrapper.wrapping.coordTransform != null) {
            if (entityIn instanceof EntityMountingWeaponBase || entityIn instanceof EntityArmorStand || entityIn instanceof EntityPig || entityIn instanceof EntityBoat) {
                wrapper.wrapping.fixEntity(entityIn, new Vector(entityIn));
                wrapper.wrapping.queueEntityForMounting(entityIn);
            }
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, wrapper.wrapping.coordTransform.lToWRotation, entityIn);
            int newChunkX = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
            int newChunkZ = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
            this.worldObj.func_72964_e(oldChunkX, oldChunkZ).func_76622_b(entityIn);
            this.worldObj.func_72964_e(newChunkX, newChunkZ).func_76612_a(entityIn);
        }
        if (entityIn instanceof PhysicsWrapperEntity) {
            ValkyrienWarfareMod.physicsManager.onShipLoad((PhysicsWrapperEntity)entityIn);
        }
        if (!(entityIn instanceof EntityFallingBlock) && wrapper != null && wrapper.wrapping.coordTransform != null) {
            if (entityIn instanceof EntityMountingWeaponBase || entityIn instanceof EntityArmorStand || entityIn instanceof EntityPig || entityIn instanceof EntityBoat) {
                wrapper.wrapping.fixEntity(entityIn, new Vector(entityIn));
                wrapper.wrapping.queueEntityForMounting(entityIn);
            }
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, wrapper.wrapping.coordTransform.lToWRotation, entityIn);
        }
    }

    public void func_72709_b(Entity entityIn) {
        if (entityIn instanceof PhysicsWrapperEntity) {
            ValkyrienWarfareMod.physicsManager.onShipUnload((PhysicsWrapperEntity)entityIn);
        }
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        if (!this.worldObj.field_72995_K) {
            for (EntityPlayer entityplayermp : this.worldObj.field_73010_i) {
                double d2;
                double d1;
                double d0;
                if (entityplayermp == null || entityplayermp.func_145782_y() == breakerId) continue;
                Vector posVector = new Vector(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.worldObj, pos);
                if (wrapper != null) {
                    RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, posVector);
                }
                if (!((d0 = posVector.X - entityplayermp.field_70165_t) * d0 + (d1 = posVector.Y - entityplayermp.field_70163_u) * d1 + (d2 = posVector.Z - entityplayermp.field_70161_v) * d2 < 1024.0)) continue;
                ((EntityPlayerMP)entityplayermp).field_71135_a.func_147359_a((Packet)new SPacketBlockBreakAnim(breakerId, pos, progress));
            }
        }
    }

    public void func_190570_a(int p_190570_1_, boolean p_190570_2_, boolean p_190570_3_, double p_190570_4_, double p_190570_6_, double p_190570_8_, double p_190570_10_, double p_190570_12_, double p_190570_14_, int ... p_190570_16_) {
    }
}

