/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.math;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;

public class BigBastardMath {
    public static final int maxArrayListFusePasses = 5;

    public static double getPitchFromVec3d(Vector vec) {
        double pitchFromRotVec = -Math.asin(vec.Y) / 0.01745329238474369;
        return pitchFromRotVec;
    }

    public static double getYawFromVec3d(Vector vec, double rotPitch) {
        double f2 = -Math.cos(-rotPitch * 0.01745329238474369);
        double yawFromRotVec = Math.atan2(vec.X / f2, vec.Z / f2);
        yawFromRotVec += Math.PI;
        return yawFromRotVec /= -0.01745329238474369;
    }

    public static AxisAlignedBB getBetweenAABB(AxisAlignedBB ship1, AxisAlignedBB ship2) {
        if (!ship1.func_72326_a(ship2)) {
            System.out.println("Tried getting relevent BB's for 2 ships not colliding!!!");
            return null;
        }
        double[] xVals = new double[4];
        double[] yVals = new double[4];
        double[] zVals = new double[4];
        xVals[0] = ship1.field_72340_a;
        xVals[1] = ship1.field_72336_d;
        xVals[2] = ship2.field_72340_a;
        xVals[3] = ship2.field_72336_d;
        yVals[0] = ship1.field_72338_b;
        yVals[1] = ship1.field_72337_e;
        yVals[2] = ship2.field_72338_b;
        yVals[3] = ship2.field_72337_e;
        zVals[0] = ship1.field_72339_c;
        zVals[1] = ship1.field_72334_f;
        zVals[2] = ship2.field_72339_c;
        zVals[3] = ship2.field_72334_f;
        Arrays.sort(xVals);
        Arrays.sort(yVals);
        Arrays.sort(zVals);
        return new AxisAlignedBB(xVals[1], yVals[1], zVals[1], xVals[2], yVals[2], zVals[2]);
    }

    public static double[] getMinMaxOfArray(double[] distances) {
        double[] minMax = new double[2];
        minMax[0] = minMax[1] = distances[0];
        for (int i = 1; i < distances.length; ++i) {
            if (distances[i] < minMax[0]) {
                minMax[0] = distances[i];
            }
            if (!(distances[i] > minMax[1])) continue;
            minMax[1] = distances[i];
        }
        return minMax;
    }

    public static double limitToRange(double input, double minimum, double maximum) {
        return Math.max(Math.min(maximum, input), minimum);
    }

    public static Vector getBodyPosWithOrientation(BlockPos pos, Vector centerOfMass, double[] rotationTransform) {
        Vector inBody = new Vector((double)pos.func_177958_n() + 0.5 - centerOfMass.X, (double)pos.func_177956_o() + 0.5 - centerOfMass.Y, (double)pos.func_177952_p() + 0.5 - centerOfMass.Z);
        RotationMatrices.doRotationOnly(rotationTransform, inBody);
        return inBody;
    }

    public static void getBodyPosWithOrientation(BlockPos pos, Vector centerOfMass, double[] rotationTransform, Vector inBody) {
        inBody.X = (double)pos.func_177958_n() + 0.5 - centerOfMass.X;
        inBody.Y = (double)pos.func_177956_o() + 0.5 - centerOfMass.Y;
        inBody.Z = (double)pos.func_177952_p() + 0.5 - centerOfMass.Z;
        RotationMatrices.doRotationOnly(rotationTransform, inBody);
    }

    public static void getBodyPosWithOrientation(Vector pos, Vector centerOfMass, double[] rotationTransform, Vector inBody) {
        inBody.X = pos.X - centerOfMass.X;
        inBody.Y = pos.Y - centerOfMass.Y;
        inBody.Z = pos.Z - centerOfMass.Z;
        RotationMatrices.doRotationOnly(rotationTransform, inBody);
    }

    public static boolean canStandOnNormal(Vector normal) {
        double radius = normal.X * normal.X + normal.Z * normal.Z;
        return radius < ValkyrienWarfareMod.standingTolerance;
    }

    public static void mergeAABBList(List<AxisAlignedBB> toFuse) {
        boolean changed = true;
        int passes = 0;
        while (changed && passes < 5) {
            changed = false;
            ++passes;
            for (int i = 0; i < toFuse.size(); ++i) {
                AxisAlignedBB bb = toFuse.get(i);
                for (int j = i + 1; j < toFuse.size(); ++j) {
                    AxisAlignedBB nextOne = toFuse.get(j);
                    if (!BigBastardMath.connected(bb, nextOne)) continue;
                    AxisAlignedBB fused = BigBastardMath.getFusedBoundingBox(bb, nextOne);
                    toFuse.remove(j);
                    toFuse.remove(i);
                    toFuse.add(fused);
                    j = toFuse.size();
                    changed = true;
                }
            }
        }
    }

    public static AxisAlignedBB getFusedBoundingBox(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        double mnX = bb1.field_72340_a;
        double mnY = bb1.field_72338_b;
        double mnZ = bb1.field_72339_c;
        double mxX = bb1.field_72336_d;
        double mxY = bb1.field_72337_e;
        double mxZ = bb1.field_72334_f;
        if (bb2.field_72340_a < mnX) {
            mnX = bb2.field_72340_a;
        }
        if (bb2.field_72338_b < mnY) {
            mnY = bb2.field_72338_b;
        }
        if (bb2.field_72339_c < mnZ) {
            mnZ = bb2.field_72339_c;
        }
        if (bb2.field_72336_d > mxX) {
            mxX = bb2.field_72336_d;
        }
        if (bb2.field_72337_e > mxY) {
            mxY = bb2.field_72337_e;
        }
        if (bb2.field_72334_f > mxZ) {
            mxZ = bb2.field_72334_f;
        }
        return new AxisAlignedBB(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }

    public static boolean connected(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return BigBastardMath.connectedInX(bb1, bb2) || BigBastardMath.connectedInY(bb1, bb2) || BigBastardMath.connectedInZ(bb1, bb2);
    }

    public static boolean connectedInX(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return BigBastardMath.intersectInX(bb1, bb2) && BigBastardMath.areXAligned(bb1, bb2);
    }

    public static boolean connectedInY(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return BigBastardMath.intersectInY(bb1, bb2) && BigBastardMath.areYAligned(bb1, bb2);
    }

    public static boolean connectedInZ(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return BigBastardMath.intersectInZ(bb1, bb2) && BigBastardMath.areZAligned(bb1, bb2);
    }

    public static boolean intersectInX(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72336_d >= bb2.field_72340_a && bb1.field_72336_d < bb2.field_72336_d || bb1.field_72340_a > bb2.field_72340_a && bb1.field_72340_a <= bb2.field_72336_d;
    }

    public static boolean intersectInY(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72337_e >= bb2.field_72338_b && bb1.field_72337_e < bb2.field_72337_e || bb1.field_72338_b > bb2.field_72338_b && bb1.field_72338_b <= bb2.field_72337_e;
    }

    public static boolean intersectInZ(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72334_f >= bb2.field_72339_c && bb1.field_72334_f < bb2.field_72334_f || bb1.field_72339_c > bb2.field_72339_c && bb1.field_72339_c <= bb2.field_72334_f;
    }

    public static boolean areXAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72338_b == bb2.field_72338_b && bb1.field_72339_c == bb2.field_72339_c && bb1.field_72337_e == bb2.field_72337_e && bb1.field_72334_f == bb2.field_72334_f;
    }

    public static boolean areYAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72340_a == bb2.field_72340_a && bb1.field_72339_c == bb2.field_72339_c && bb1.field_72336_d == bb2.field_72336_d && bb1.field_72334_f == bb2.field_72334_f;
    }

    public static boolean areZAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72340_a == bb2.field_72340_a && bb1.field_72338_b == bb2.field_72338_b && bb1.field_72336_d == bb2.field_72336_d && bb1.field_72337_e == bb2.field_72337_e;
    }
}

