/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.mixin.client.multiplayer;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveDataMemoryStorage;
import net.minecraft.world.storage.SaveHandlerMP;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

@Mixin(value={WorldClient.class})
public abstract class MixinWorldClient
extends World {
    @Shadow
    @Final
    private final NetHandlerPlayClient field_73035_a;
    @Shadow
    protected Set<ChunkPos> field_184157_a;
    @Shadow
    @Final
    private Minecraft field_73037_M;
    @Shadow
    private int field_184158_M;

    public MixinWorldClient(NetHandlerPlayClient netHandler, WorldSettings settings, int dimension, EnumDifficulty difficulty, Profiler profilerIn) {
        super((ISaveHandler)new SaveHandlerMP(), new WorldInfo(settings, "MpServer"), DimensionManager.createProviderFor((int)dimension), profilerIn, true);
        this.field_184158_M = this.field_73012_v.nextInt(12000);
        this.field_184157_a = Sets.newHashSet();
        this.field_73035_a = netHandler;
        this.func_72912_H().func_176144_a(difficulty);
        this.field_73011_w.func_76558_a((World)this);
        this.func_175652_B(new BlockPos(8, 64, 8));
        this.field_73020_y = this.func_72970_h();
        this.field_72988_C = new SaveDataMemoryStorage();
        this.func_72966_v();
        this.func_72947_a();
        this.initCapabilities();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)this));
    }

    @Overwrite
    public void func_73029_E(int posX, int posY, int posZ) {
        if (ValkyrienWarfareMod.shipsSpawnParticles) {
            int range = 15;
            AxisAlignedBB aabb = new AxisAlignedBB((double)(posX - range), (double)(posY - range), (double)(posZ - range), (double)(posX + range), (double)(posY + range), (double)(posZ + range));
            List<PhysicsWrapperEntity> physEntities = ValkyrienWarfareMod.physicsManager.getManagerForWorld((World)WorldClient.class.cast((Object)this)).getNearbyPhysObjects(aabb);
            for (PhysicsWrapperEntity wrapper : physEntities) {
                Vector playPosInShip = new Vector((double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5);
                RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.wToLTransform, playPosInShip);
                this.doVoidFogParticlesOriginal(MathHelper.func_76128_c((double)playPosInShip.X), MathHelper.func_76128_c((double)playPosInShip.Y), MathHelper.func_76128_c((double)playPosInShip.Z));
            }
        }
        this.doVoidFogParticlesOriginal(posX, posY, posZ);
    }

    @Shadow
    public abstract void func_184153_a(int var1, int var2, int var3, int var4, Random var5, boolean var6, BlockPos.MutableBlockPos var7);

    public void doVoidFogParticlesOriginal(int posX, int posY, int posZ) {
        int i = 32;
        Random random = new Random();
        ItemStack itemstack = this.field_73037_M.field_71439_g.func_184614_ca();
        boolean flag = this.field_73037_M.field_71442_b.func_178889_l() == GameType.CREATIVE && !itemstack.func_190926_b() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = 0; j < 667; ++j) {
            this.func_184153_a(posX, posY, posZ, 16, random, flag, blockpos$mutableblockpos);
            this.func_184153_a(posX, posY, posZ, 32, random, flag, blockpos$mutableblockpos);
        }
    }
}

