/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.mixin.client.renderer.entity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

@Mixin(value={RenderManager.class})
public abstract class MixinRenderManager {
    @Shadow
    public TextureManager field_78724_e;
    @Shadow
    private boolean field_178639_r;
    @Shadow
    private boolean field_85095_o;

    @Shadow
    public <T extends Entity> Render<T> func_78713_a(T entityIn) {
        return null;
    }

    @Shadow
    private void func_85094_b(Entity entityIn, double x, double y, double z, float entityYaw, float partialTicks) {
    }

    @Overwrite
    public void func_188391_a(Entity entityIn, double x, double y, double z, float yaw, float partialTicks, boolean p_188391_10_) {
        PhysicsWrapperEntity fixedOnto = ValkyrienWarfareMod.physicsManager.getShipFixedOnto(entityIn);
        if (fixedOnto != null) {
            EntityPlayer player;
            double oldPosX = entityIn.field_70165_t;
            double oldPosY = entityIn.field_70163_u;
            double oldPosZ = entityIn.field_70161_v;
            double oldLastPosX = entityIn.field_70142_S;
            double oldLastPosY = entityIn.field_70137_T;
            double oldLastPosZ = entityIn.field_70136_U;
            Vector localPosition = fixedOnto.wrapping.getLocalPositionForEntity(entityIn);
            fixedOnto.wrapping.renderer.setupTranslation(partialTicks);
            if (localPosition != null) {
                localPosition = new Vector(localPosition);
                localPosition.X -= (double)fixedOnto.wrapping.renderer.offsetPos.func_177958_n();
                localPosition.Y -= (double)fixedOnto.wrapping.renderer.offsetPos.func_177956_o();
                localPosition.Z -= (double)fixedOnto.wrapping.renderer.offsetPos.func_177952_p();
                entityIn.field_70165_t = entityIn.field_70142_S = localPosition.X;
                x = entityIn.field_70142_S;
                entityIn.field_70163_u = entityIn.field_70137_T = localPosition.Y;
                y = entityIn.field_70137_T;
                entityIn.field_70161_v = entityIn.field_70136_U = localPosition.Z;
                z = entityIn.field_70136_U;
            }
            boolean makePlayerMount = false;
            PhysicsWrapperEntity shipRidden = null;
            if (entityIn instanceof EntityPlayer && (player = (EntityPlayer)entityIn).func_70608_bn()) {
                if (player.field_184239_as instanceof PhysicsWrapperEntity) {
                    shipRidden = (PhysicsWrapperEntity)player.field_184239_as;
                }
                if (shipRidden != null) {
                    player.field_184239_as = null;
                    makePlayerMount = true;
                    Vector playerPosInLocal = new Vector(fixedOnto.wrapping.getLocalPositionForEntity(entityIn));
                    playerPosInLocal.subtract(0.5, 0.6875, 0.5);
                    playerPosInLocal.roundToWhole();
                    BlockPos bedPos = new BlockPos(playerPosInLocal.X, playerPosInLocal.Y, playerPosInLocal.Z);
                    IBlockState state = entityIn.field_70170_p.func_180495_p(bedPos);
                    Block block = state.func_177230_c();
                    float angleYaw = 0.0f;
                    if (block != null && block.isBed(state, (IBlockAccess)entityIn.field_70170_p, bedPos, entityIn)) {
                        angleYaw = block.getBedDirection(state, (IBlockAccess)entityIn.field_70170_p, bedPos).func_176736_b() * 90;
                    }
                    GL11.glRotatef((float)angleYaw, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            this.doRenderEntityOriginal(entityIn, x, y, z, yaw, partialTicks, p_188391_10_);
            if (makePlayerMount) {
                player = (EntityPlayer)entityIn;
                player.field_184239_as = shipRidden;
            }
            if (localPosition != null) {
                fixedOnto.wrapping.renderer.inverseTransform(partialTicks);
            }
            entityIn.field_70165_t = oldPosX;
            entityIn.field_70163_u = oldPosY;
            entityIn.field_70161_v = oldPosZ;
            entityIn.field_70142_S = oldLastPosX;
            entityIn.field_70137_T = oldLastPosY;
            entityIn.field_70136_U = oldLastPosZ;
        } else {
            this.doRenderEntityOriginal(entityIn, x, y, z, yaw, partialTicks, p_188391_10_);
        }
    }

    public void doRenderEntityOriginal(Entity entityIn, double x, double y, double z, float yaw, float partialTicks, boolean p_188391_10_) {
        block9: {
            Render<Entity> render = null;
            try {
                render = this.func_78713_a(entityIn);
                if (render == null || this.field_78724_e == null) break block9;
                try {
                    render.func_188297_a(this.field_178639_r);
                    render.func_76986_a(entityIn, x, y, z, yaw, partialTicks);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering entity in world"));
                }
                try {
                    if (!this.field_178639_r) {
                        render.func_76979_b(entityIn, x, y, z, yaw, partialTicks);
                    }
                }
                catch (Throwable throwable2) {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable2, (String)"Post-rendering entity in world"));
                }
                if (!this.field_85095_o || entityIn.func_82150_aj() || p_188391_10_ || Minecraft.func_71410_x().func_189648_am()) break block9;
                try {
                    this.func_85094_b(entityIn, x, y, z, yaw, partialTicks);
                }
                catch (Throwable throwable) {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering entity hitbox in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("entity being rendered");
                entityIn.func_85029_a(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
                crashreportcategory1.func_71507_a("Assigned renderer", render);
                crashreportcategory1.func_71507_a("Location", (Object)CrashReportCategory.func_85074_a((double)x, (double)y, (double)z));
                crashreportcategory1.func_71507_a("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.func_71507_a("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }
}

