/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.mixin.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.EntityPolygon;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

@Mixin(value={EntityLivingBase.class})
public abstract class MixinEntityLivingBase
extends Entity {
    public MixinEntityLivingBase(World world) {
        super(world);
    }

    @Inject(method={"dismountEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void dismountEntity(Entity entityIn, CallbackInfo info) {
        if (entityIn instanceof PhysicsWrapperEntity) {
            this.field_184239_as = null;
            this.field_70163_u += 1.45;
            info.cancel();
        }
    }

    @Overwrite
    public boolean func_70617_f_() {
        boolean vanilla = this.isOnLadderOriginalButSlightlyOptimized();
        if (vanilla) {
            return true;
        }
        if (EntityPlayer.class.isInstance((Object)this) && ((EntityPlayer)EntityPlayer.class.cast((Object)this)).func_175149_v()) {
            return false;
        }
        List<PhysicsWrapperEntity> nearbyPhys = ValkyrienWarfareMod.physicsManager.getManagerForWorld(this.field_70170_p).getNearbyPhysObjects(this.func_174813_aQ());
        for (PhysicsWrapperEntity physWrapper : nearbyPhys) {
            Vector playerPos = new Vector((Entity)EntityLivingBase.class.cast((Object)this));
            physWrapper.wrapping.coordTransform.fromGlobalToLocal(playerPos);
            int i = MathHelper.func_76128_c((double)playerPos.X);
            int j = MathHelper.func_76128_c((double)playerPos.Y);
            int k = MathHelper.func_76128_c((double)playerPos.Z);
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            EntityPolygon playerPoly = new EntityPolygon(this.func_174813_aQ(), physWrapper.wrapping.coordTransform.wToLTransform, this);
            AxisAlignedBB bb = playerPoly.getEnclosedAABB();
            int x = MathHelper.func_76128_c((double)bb.field_72340_a);
            while ((double)x < bb.field_72336_d) {
                int y = MathHelper.func_76128_c((double)bb.field_72338_b);
                while ((double)y < bb.field_72337_e) {
                    int z = MathHelper.func_76128_c((double)bb.field_72339_c);
                    while ((double)z < bb.field_72334_f) {
                        BlockPos pos = new BlockPos(x, y, z);
                        IBlockState checkState = this.field_70170_p.func_180495_p(pos);
                        if (checkState.func_177230_c().isLadder(checkState, (IBlockAccess)this.field_70170_p, pos, (EntityLivingBase)EntityLivingBase.class.cast((Object)this))) {
                            return true;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return false;
    }

    public boolean isOnLadderOriginalButSlightlyOptimized() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        return ForgeHooks.isLivingOnLadder((IBlockState)iblockstate, (World)this.field_70170_p, (BlockPos)new BlockPos(i, j, k), (EntityLivingBase)((EntityLivingBase)EntityLivingBase.class.cast((Object)this)));
    }
}

