/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.mixin.entity.player;

import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.piloting.ControllerInputType;
import valkyrienwarfare.addon.control.piloting.IShipPilot;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.interaction.ShipUUIDToPosData;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

@Mixin(value={EntityPlayer.class})
public abstract class MixinEntityPlayer
extends EntityLivingBase
implements IShipPilot {
    public PhysicsWrapperEntity pilotedShip;
    public BlockPos blockBeingControlled;
    public ControllerInputType controlInputType;

    public MixinEntityPlayer() {
        super(null);
    }

    @Overwrite
    public static BlockPos func_180467_a(World worldIn, BlockPos bedLocation, boolean forceSpawn) {
        int chunkZ;
        int chunkX = bedLocation.func_177958_n() >> 4;
        UUID shipManagingID = ValkyrienWarfareMod.chunkManager.getShipIDManagingPos_Persistant(worldIn, chunkX, chunkZ = bedLocation.func_177952_p() >> 4);
        if (shipManagingID != null) {
            ShipUUIDToPosData.ShipPositionData positionData = ValkyrienWarfareMod.chunkManager.getShipPosition_Persistant(worldIn, shipManagingID);
            if (positionData != null) {
                double[] lToWTransform = RotationMatrices.convertToDouble(positionData.lToWTransform);
                Vector bedPositionInWorld = new Vector((double)bedLocation.func_177958_n() + 0.5, (double)bedLocation.func_177956_o() + 0.5, (double)bedLocation.func_177952_p() + 0.5);
                RotationMatrices.applyTransform(lToWTransform, bedPositionInWorld);
                bedPositionInWorld.Y += 1.0;
                bedLocation = new BlockPos(bedPositionInWorld.X, bedPositionInWorld.Y, bedPositionInWorld.Z);
                return bedLocation;
            }
            System.err.println("A ship just had Chunks claimed persistant, but not any position data persistant");
        }
        return bedLocation;
    }

    @Override
    public PhysicsWrapperEntity getPilotedShip() {
        return this.pilotedShip;
    }

    @Override
    public void setPilotedShip(PhysicsWrapperEntity wrapper) {
        this.pilotedShip = wrapper;
    }

    @Override
    public boolean isPilotingShip() {
        return this.pilotedShip != null;
    }

    @Override
    public BlockPos getPosBeingControlled() {
        return this.blockBeingControlled;
    }

    @Override
    public void setPosBeingControlled(BlockPos pos) {
        this.blockBeingControlled = pos;
    }

    @Override
    public ControllerInputType getControllerInputEnum() {
        return this.controlInputType;
    }

    @Override
    public void setControllerInputEnum(ControllerInputType type) {
        this.controlInputType = type;
    }

    @Override
    public boolean isPilotingATile() {
        return this.blockBeingControlled != null;
    }

    @Override
    public boolean isPiloting() {
        return this.isPilotingShip() || this.isPilotingATile();
    }

    @Override
    public void stopPilotingEverything() {
        this.setPilotedShip(null);
        this.setPosBeingControlled(null);
        this.setControllerInputEnum(null);
    }
}

