/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.mixin.world;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physics.BlockMass;
import valkyrienwarfare.physics.PhysicsQueuedForce;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

@Mixin(value={Explosion.class})
public abstract class MixinExplosion {
    @Shadow
    @Final
    public World field_77287_j;
    @Shadow
    @Final
    public float field_77280_f;
    @Shadow
    @Final
    public double field_77284_b;
    @Shadow
    @Final
    public double field_77285_c;
    @Shadow
    @Final
    public double field_77282_d;

    @Inject(method={"doExplosionA"}, at={@At(value="RETURN")})
    public void postExplosionA(CallbackInfo callbackInfo) {
        Vector center = new Vector(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        World worldIn = this.field_77287_j;
        float radius = this.field_77280_f;
        AxisAlignedBB toCheck = new AxisAlignedBB(center.X - (double)radius, center.Y - (double)radius, center.Z - (double)radius, center.X + (double)radius, center.Y + (double)radius, center.Z + (double)radius);
        List<PhysicsWrapperEntity> shipsNear = ValkyrienWarfareMod.physicsManager.getManagerForWorld(this.field_77287_j).getNearbyPhysObjects(toCheck);
        for (PhysicsWrapperEntity ship : shipsNear) {
            Block block;
            IBlockState state;
            BlockPos pos;
            Vector inLocal = new Vector(center);
            RotationMatrices.applyTransform(ship.wrapping.coordTransform.wToLTransform, inLocal);
            Explosion expl = new Explosion(ship.field_70170_p, null, inLocal.X, inLocal.Y, inLocal.Z, radius, false, false);
            double waterRange = 0.6;
            boolean cancelDueToWater = false;
            int x = (int)Math.floor(expl.field_77284_b - waterRange);
            while ((double)x <= Math.ceil(expl.field_77284_b + waterRange)) {
                int y = (int)Math.floor(expl.field_77285_c - waterRange);
                while ((double)y <= Math.ceil(expl.field_77285_c + waterRange)) {
                    int z = (int)Math.floor(expl.field_77282_d - waterRange);
                    while ((double)z <= Math.ceil(expl.field_77282_d + waterRange)) {
                        IBlockState state2;
                        if (!cancelDueToWater && (state2 = this.field_77287_j.func_180495_p(new BlockPos(x, y, z))).func_177230_c() instanceof BlockLiquid) {
                            cancelDueToWater = true;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            expl.func_77278_a();
            double affectedPositions = 0.0;
            for (Object o : expl.field_77281_g) {
                pos = (BlockPos)o;
                state = ship.field_70170_p.func_180495_p(pos);
                block = state.func_177230_c();
                if (block.isAir(state, (IBlockAccess)worldIn, (BlockPos)o) && !ship.wrapping.explodedPositionsThisTick.contains(o)) continue;
                affectedPositions += 1.0;
            }
            if (cancelDueToWater) continue;
            for (Object o : expl.field_77281_g) {
                pos = (BlockPos)o;
                state = ship.field_70170_p.func_180495_p(pos);
                block = state.func_177230_c();
                if (block.isAir(state, (IBlockAccess)worldIn, (BlockPos)o) && !ship.wrapping.explodedPositionsThisTick.contains(o)) continue;
                if (block.func_149659_a(expl)) {
                    block.func_180653_a(ship.field_70170_p, pos, state, 1.0f / expl.field_77280_f, 0);
                }
                block.onBlockExploded(ship.field_70170_p, pos, expl);
                if (worldIn.field_72995_K) continue;
                Vector posVector = new Vector((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                ship.wrapping.coordTransform.fromLocalToGlobal(posVector);
                double mass = BlockMass.basicMass.getMassFromState(state, pos, ship.field_70170_p);
                double explosionForce = Math.sqrt(this.field_77280_f) * 1000.0 * mass;
                Vector forceVector = new Vector((double)pos.func_177958_n() + 0.5 - expl.field_77284_b, (double)pos.func_177956_o() + 0.5 - expl.field_77285_c, (double)pos.func_177952_p() + 0.5 - expl.field_77282_d);
                double vectorDist = forceVector.length();
                forceVector.normalize();
                forceVector.multiply(explosionForce / vectorDist);
                RotationMatrices.doRotationOnly(ship.wrapping.coordTransform.lToWRotation, forceVector);
                PhysicsQueuedForce queuedForce = new PhysicsQueuedForce(forceVector, posVector, false, 1);
                if (!ship.wrapping.explodedPositionsThisTick.contains(pos)) {
                    ship.wrapping.explodedPositionsThisTick.add(pos);
                }
                ship.wrapping.queueForce(queuedForce);
            }
        }
    }
}

