/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.mixin.world;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.nodenetwork.INodeProvider;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.fixes.WorldChunkloadingCrashFix;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.physicsmanagement.WorldPhysObjectManager;

@Mixin(value={World.class})
@Implements(value={@Interface(iface=WorldChunkloadingCrashFix.class, prefix="vw$", remap=Interface.Remap.NONE)})
public abstract class MixinWorld {
    private static double MAX_ENTITY_RADIUS_ALT = 2.0;
    @Shadow
    @Final
    public boolean field_72995_K;
    @Shadow
    List<IWorldEventListener> field_73021_x;
    private World thisClassAsWorld = (World)World.class.cast(this);
    @Shadow
    boolean field_147481_N;
    @Shadow
    List<TileEntity> field_147484_a;

    @Overwrite
    public void func_175720_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)World.class.cast(this), pos);
        if (wrapper != null) {
            Vector newPosVec = new Vector(xCoord, yCoord, zCoord);
            RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, newPosVec);
            xCoord = newPosVec.X;
            yCoord = newPosVec.Y;
            zCoord = newPosVec.Z;
        }
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_180442_a(particleID, ignoreRange, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
        }
    }

    @Shadow
    public IBlockState func_180495_p(BlockPos pos) {
        return null;
    }

    public RayTraceResult onRayTraceBlocks(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return this.rayTraceBlocksIgnoreShip(vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, null);
    }

    public RayTraceResult rayTraceBlocksIgnoreShip(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, PhysicsWrapperEntity toIgnore) {
        RayTraceResult vanillaTrace = this.rayTraceBlocksOriginal((World)World.class.cast(this), vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
        WorldPhysObjectManager physManager = ValkyrienWarfareMod.physicsManager.getManagerForWorld((World)World.class.cast(this));
        if (physManager == null) {
            return vanillaTrace;
        }
        Vec3d playerEyesPos = vec31;
        Vec3d playerReachVector = vec32.func_178788_d(vec31);
        AxisAlignedBB playerRangeBB = new AxisAlignedBB(vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, vec32.field_72450_a, vec32.field_72448_b, vec32.field_72449_c);
        List<PhysicsWrapperEntity> nearbyShips = physManager.getNearbyPhysObjects(playerRangeBB);
        nearbyShips.remove((Object)toIgnore);
        boolean changed = false;
        double reachDistance = playerReachVector.func_72433_c();
        double worldResultDistFromPlayer = 4.2E8;
        if (vanillaTrace != null && vanillaTrace.field_72307_f != null) {
            worldResultDistFromPlayer = vanillaTrace.field_72307_f.func_72438_d(vec31);
        }
        PhysicsWrapperEntity transformedEntity = null;
        for (PhysicsWrapperEntity wrapper : nearbyShips) {
            double shipResultDistFromPlayer;
            playerEyesPos = vec31;
            playerReachVector = vec32.func_178788_d(vec31);
            if (((World)World.class.cast((Object)this)).field_72995_K) {
                // empty if block
            }
            playerEyesPos = RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.RwToLTransform, playerEyesPos);
            playerReachVector = RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.RwToLRotation, playerReachVector);
            Vec3d playerEyesReachAdded = playerEyesPos.func_72441_c(playerReachVector.field_72450_a * reachDistance, playerReachVector.field_72448_b * reachDistance, playerReachVector.field_72449_c * reachDistance);
            RayTraceResult resultInShip = this.rayTraceBlocksOriginal((World)World.class.cast(this), playerEyesPos, playerEyesReachAdded, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
            if (resultInShip == null || resultInShip.field_72307_f == null || resultInShip.field_72313_a != RayTraceResult.Type.BLOCK || !((shipResultDistFromPlayer = resultInShip.field_72307_f.func_72438_d(playerEyesPos)) < worldResultDistFromPlayer)) continue;
            worldResultDistFromPlayer = shipResultDistFromPlayer;
            resultInShip.field_72307_f = RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.RlToWTransform, resultInShip.field_72307_f);
            vanillaTrace = resultInShip;
            transformedEntity = wrapper;
        }
        if (transformedEntity != null) {
            Vec3d hitVec2 = vanillaTrace.field_72307_f;
            vanillaTrace.field_72307_f = hitVec2 = RotationMatrices.applyTransform(transformedEntity.wrapping.coordTransform.RwToLTransform, hitVec2);
        }
        return vanillaTrace;
    }

    @Nullable
    public RayTraceResult rayTraceBlocksOriginal(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if ((!ignoreBlockWithoutBoundingBox || iblockstate.func_185890_d((IBlockAccess)world, blockpos) != Block.field_185506_k) && block.func_176209_a(iblockstate, stopOnLiquid) && (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    @Overwrite
    public RayTraceResult func_147447_a(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return this.onRayTraceBlocks(vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
    }

    @Shadow
    protected abstract boolean func_175680_a(int var1, int var2, boolean var3);

    @Shadow
    public Chunk func_72964_e(int chunkX, int chunkZ) {
        return null;
    }

    public <T extends Entity> List<T> getEntitiesWithinAABBOriginal(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        int i = MathHelper.func_76128_c((double)((aabb.field_72340_a - MAX_ENTITY_RADIUS_ALT) / 16.0));
        int j = MathHelper.func_76143_f((double)((aabb.field_72336_d + MAX_ENTITY_RADIUS_ALT) / 16.0));
        int k = MathHelper.func_76128_c((double)((aabb.field_72339_c - MAX_ENTITY_RADIUS_ALT) / 16.0));
        int l = MathHelper.func_76143_f((double)((aabb.field_72334_f + MAX_ENTITY_RADIUS_ALT) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int i1 = i; i1 < j; ++i1) {
            for (int j1 = k; j1 < l; ++j1) {
                if (!this.func_175680_a(i1, j1, true)) continue;
                this.func_72964_e(i1, j1).func_177430_a(clazz, aabb, (List)list, filter);
            }
        }
        return list;
    }

    public List<Entity> getEntitiesInAABBexcludingOriginal(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)((boundingBox.field_72340_a - MAX_ENTITY_RADIUS_ALT) / 16.0));
        int j = MathHelper.func_76128_c((double)((boundingBox.field_72336_d + MAX_ENTITY_RADIUS_ALT) / 16.0));
        int k = MathHelper.func_76128_c((double)((boundingBox.field_72339_c - MAX_ENTITY_RADIUS_ALT) / 16.0));
        int l = MathHelper.func_76128_c((double)((boundingBox.field_72334_f + MAX_ENTITY_RADIUS_ALT) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.func_175680_a(i1, j1, true)) continue;
                this.func_72964_e(i1, j1).func_177414_a(entityIn, boundingBox, (List)list, predicate);
            }
        }
        return list;
    }

    @Overwrite
    public void func_147458_c(int x1, int y1, int z1, int x2, int y2, int z2) {
        if (x2 == 1 && y1 == 0 && z2 == 1) {
            x2 = x1 + 1;
            --x1;
            y1 = y2 - 1;
            ++y2;
            z2 = z1 + 1;
            --z2;
        }
        int midX = (x1 + x2) / 2;
        int midY = (y1 + y2) / 2;
        int midZ = (z1 + z2) / 2;
        BlockPos newPos = new BlockPos(midX, midY, midZ);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)World.class.cast(this), newPos);
        if (wrapper != null && wrapper.wrapping.renderer != null) {
            wrapper.wrapping.renderer.updateRange(x1 - 1, y1 - 1, z1 - 1, x2 + 1, y2 + 1, z2 + 1);
        }
        if (wrapper == null) {
            this.markBlockRangeForRenderUpdateOriginal(x1, y1, z1, x2, y2, z2);
        }
    }

    public void markBlockRangeForRenderUpdateOriginal(int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_147585_a(x1, y1, z1, x2, y2, z2);
        }
    }

    @Overwrite
    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        List<T> toReturn = this.getEntitiesWithinAABBOriginal(clazz, aabb, filter);
        if (ValkyrienWarfareMod.physicsManager == null) {
            return toReturn;
        }
        BlockPos pos = new BlockPos((aabb.field_72340_a + aabb.field_72336_d) / 2.0, (aabb.field_72338_b + aabb.field_72337_e) / 2.0, (aabb.field_72339_c + aabb.field_72334_f) / 2.0);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)World.class.cast(this), pos);
        if (wrapper != null) {
            Polygon poly = new Polygon(aabb, wrapper.wrapping.coordTransform.lToWTransform);
            aabb = poly.getEnclosedAABB();
            toReturn.addAll(this.getEntitiesWithinAABBOriginal(clazz, aabb, filter));
            toReturn.remove((Object)wrapper);
        }
        return toReturn;
    }

    @Overwrite
    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        AxisAlignedBB axisalignedbb;
        EntityPlayer player;
        if ((boundingBox.field_72336_d - boundingBox.field_72340_a) * (boundingBox.field_72334_f - boundingBox.field_72339_c) > 1000000.0) {
            return new ArrayList<Entity>();
        }
        if (entityIn instanceof EntityPlayer && (player = (EntityPlayer)entityIn).func_184218_aH() && !player.func_184187_bx().field_70128_L && player.func_184187_bx() instanceof PhysicsWrapperEntity && boundingBox.equals((Object)(axisalignedbb = player.func_174813_aQ().func_111270_a(player.func_184187_bx().func_174813_aQ()).func_72314_b(1.0, 0.0, 1.0)))) {
            boundingBox = player.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0);
        }
        List<Entity> toReturn = this.getEntitiesInAABBexcludingOriginal(entityIn, boundingBox, predicate);
        BlockPos pos = new BlockPos((boundingBox.field_72340_a + boundingBox.field_72336_d) / 2.0, (boundingBox.field_72338_b + boundingBox.field_72337_e) / 2.0, (boundingBox.field_72339_c + boundingBox.field_72334_f) / 2.0);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)World.class.cast(this), pos);
        if (wrapper != null) {
            Polygon poly = new Polygon(boundingBox, wrapper.wrapping.coordTransform.lToWTransform);
            boundingBox = poly.getEnclosedAABB().func_186664_h(0.3);
            toReturn.addAll(this.getEntitiesInAABBexcludingOriginal(entityIn, boundingBox, predicate));
            toReturn.remove((Object)wrapper);
        }
        return toReturn;
    }

    @Inject(method={"playSound(DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FFZ)V"}, at={@At(value="HEAD")})
    public void prePlaySound(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay, CallbackInfo callbackInfo) {
        BlockPos pos = new BlockPos(x, y, z);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)World.class.cast(this), pos);
        if (wrapper != null) {
            Vector posVec = new Vector(x, y, z);
            wrapper.wrapping.coordTransform.fromLocalToGlobal(posVec);
            x = posVec.X;
            y = posVec.Y;
            z = posVec.Z;
        }
    }

    @Inject(method={"setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"}, at={@At(value="HEAD")})
    public void duringMarkAndNotifyBlock(BlockPos pos, IBlockState newState, int flags, CallbackInfoReturnable callbackInfo) {
        IBlockState oldState = this.func_180495_p(pos);
        PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos((World)World.class.cast(this), pos);
        if (wrapper != null) {
            wrapper.wrapping.onSetBlockState(oldState, newState, pos);
        }
    }

    @Inject(method={"getBiome(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/world/biome/Biome;"}, at={@At(value="HEAD")}, cancellable=true)
    public void preGetBiome(BlockPos pos, CallbackInfoReturnable<Biome> callbackInfoReturnable) {
        try {
            BlockPos realPos;
            Biome toReturn;
            if (ValkyrienWarfareMod.physicsManager == null || pos == null || this.thisClassAsWorld == null) {
                return;
            }
            PhysicsWrapperEntity wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.thisClassAsWorld, pos);
            if (wrapper != null && wrapper.wrapping != null && wrapper.wrapping.coordTransform != null && wrapper.wrapping.coordTransform.lToWTransform != null && pos != null && (toReturn = this.thisClassAsWorld.func_180494_b(realPos = RotationMatrices.applyTransform(wrapper.wrapping.coordTransform.lToWTransform, pos))) != null) {
                callbackInfoReturnable.setReturnValue(toReturn);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Overwrite
    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        PhysicsWrapperEntity wrapper;
        pos = pos.func_185334_h();
        if (tileEntityIn instanceof INodeProvider && (wrapper = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(this.thisClassAsWorld, pos)) != null) {
            ((INodeProvider)tileEntityIn).getNode().updateParentEntity(wrapper.wrapping);
        }
        if (!this.func_189509_E(pos) && tileEntityIn != null && !tileEntityIn.func_145837_r()) {
            if (this.field_147481_N) {
                tileEntityIn.func_174878_a(pos);
                if (tileEntityIn.func_145831_w() != this.thisClassAsWorld) {
                    tileEntityIn.func_145834_a(this.thisClassAsWorld);
                }
                Iterator<TileEntity> iterator = this.field_147484_a.iterator();
                while (iterator.hasNext()) {
                    TileEntity tileentity = iterator.next();
                    if (!tileentity.func_174877_v().equals((Object)pos)) continue;
                    tileentity.func_145843_s();
                    iterator.remove();
                }
                this.field_147484_a.add(tileEntityIn);
            } else {
                Chunk chunk = this.thisClassAsWorld.func_175726_f(pos);
                if (chunk != null) {
                    chunk.func_177426_a(pos, tileEntityIn);
                }
                this.thisClassAsWorld.func_175700_a(tileEntityIn);
            }
        }
    }

    @Intrinsic(displace=true)
    public Iterator<Chunk> vw$getPersistentChunkIterable(Iterator<Chunk> chunkIterator) {
        ArrayList<Chunk> persistantChunks = new ArrayList<Chunk>();
        while (chunkIterator.hasNext()) {
            Chunk chunk = chunkIterator.next();
            persistantChunks.add(chunk);
        }
        Iterator<Chunk> replacementIterator = persistantChunks.iterator();
        return this.getPersistentChunkIterable(replacementIterator);
    }

    @Shadow
    public abstract Iterator<Chunk> getPersistentChunkIterable(Iterator<Chunk> var1);

    @Shadow
    abstract boolean func_189509_E(BlockPos var1);
}

