/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class EntityRelativePositionMessage
implements IMessage {
    public Integer wrapperEntityId;
    public int listSize;
    public List<Integer> entitiesToSendIDs = new ArrayList<Integer>();
    public List<Vector> entitiesRelativePosition = new ArrayList<Vector>();

    public EntityRelativePositionMessage(PhysicsWrapperEntity wrapperEntity, List<Entity> entitiesToSendRelativePosition) {
        this.wrapperEntityId = wrapperEntity.func_145782_y();
        this.listSize = entitiesToSendRelativePosition.size();
        double[] wToLTransformationMatrix = wrapperEntity.wrapping.coordTransform.wToLTransform;
        for (int i = 0; i < entitiesToSendRelativePosition.size(); ++i) {
            Entity entity = entitiesToSendRelativePosition.get(i);
            Vector entityPosition = new Vector(entity);
            entityPosition.transform(wToLTransformationMatrix);
            this.entitiesToSendIDs.add(entity.func_145782_y());
            this.entitiesRelativePosition.add(entityPosition);
        }
    }

    public EntityRelativePositionMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        this.wrapperEntityId = packetBuf.readInt();
        this.listSize = packetBuf.readInt();
        for (int i = 0; i < this.listSize; ++i) {
            int entityID = packetBuf.readInt();
            Vector entityLocalPosition = new Vector((ByteBuf)packetBuf);
            this.entitiesToSendIDs.add(entityID);
            this.entitiesRelativePosition.add(entityLocalPosition);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        packetBuf.writeInt(this.wrapperEntityId.intValue());
        packetBuf.writeInt(this.listSize);
        for (int i = 0; i < this.listSize; ++i) {
            int entityID = this.entitiesToSendIDs.get(i);
            Vector toWrite = this.entitiesRelativePosition.get(i);
            packetBuf.writeInt(entityID);
            toWrite.writeToByteBuf((ByteBuf)packetBuf);
        }
    }
}

