/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.network;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class PhysWrapperPositionMessage
implements IMessage {
    public PhysicsWrapperEntity toSpawn;
    public int entityID;
    public double posX;
    public double posY;
    public double posZ;
    public double pitch;
    public double yaw;
    public double roll;
    public Vector centerOfMass;
    public int relativeTick;

    public PhysWrapperPositionMessage() {
    }

    public PhysWrapperPositionMessage(PhysicsWrapperEntity toSend) {
        this.toSpawn = toSend;
        this.relativeTick = toSend.field_70173_aa;
    }

    public PhysWrapperPositionMessage(PhysicsObject toRunLocally) {
        this.posX = toRunLocally.wrapper.field_70165_t;
        this.posY = toRunLocally.wrapper.field_70163_u;
        this.posZ = toRunLocally.wrapper.field_70161_v;
        this.pitch = toRunLocally.wrapper.pitch;
        this.yaw = toRunLocally.wrapper.yaw;
        this.roll = toRunLocally.wrapper.roll;
        this.centerOfMass = toRunLocally.centerCoord;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.relativeTick = buf.readInt();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.pitch = buf.readDouble();
        this.yaw = buf.readDouble();
        this.roll = buf.readDouble();
        this.centerOfMass = new Vector(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.toSpawn.func_145782_y());
        buf.writeInt(this.relativeTick);
        buf.writeDouble(this.toSpawn.field_70165_t);
        buf.writeDouble(this.toSpawn.field_70163_u);
        buf.writeDouble(this.toSpawn.field_70161_v);
        buf.writeDouble(this.toSpawn.pitch);
        buf.writeDouble(this.toSpawn.yaw);
        buf.writeDouble(this.toSpawn.roll);
        buf.writeDouble(this.toSpawn.wrapping.centerCoord.X);
        buf.writeDouble(this.toSpawn.wrapping.centerCoord.Y);
        buf.writeDouble(this.toSpawn.wrapping.centerCoord.Z);
    }
}

