/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class PlayerShipRefrenceMessage
implements IMessage {
    public Vector playerPosInLocal;
    public Vector velocityInLocal;
    public Vector playerLookVectorInLocal;
    public int shipInID;

    public PlayerShipRefrenceMessage() {
    }

    public PlayerShipRefrenceMessage(EntityPlayer playerToSend, PhysicsWrapperEntity shipOn) {
        this.playerPosInLocal = new Vector(playerToSend.field_70165_t, playerToSend.field_70163_u, playerToSend.field_70161_v);
        this.velocityInLocal = new Vector(playerToSend.field_70159_w, playerToSend.field_70181_x, playerToSend.field_70179_y);
        this.playerLookVectorInLocal = new Vector(playerToSend.func_70676_i(1.0f));
        RotationMatrices.applyTransform(shipOn.wrapping.coordTransform.wToLTransform, this.playerPosInLocal);
        RotationMatrices.doRotationOnly(shipOn.wrapping.coordTransform.wToLRotation, this.velocityInLocal);
        RotationMatrices.doRotationOnly(shipOn.wrapping.coordTransform.wToLRotation, this.playerLookVectorInLocal);
        this.shipInID = shipOn.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.playerPosInLocal = new Vector(buf);
        this.velocityInLocal = new Vector(buf);
        this.playerLookVectorInLocal = new Vector(buf);
        this.shipInID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        this.playerPosInLocal.writeToByteBuf(buf);
        this.velocityInLocal.writeToByteBuf(buf);
        this.playerLookVectorInLocal.writeToByteBuf(buf);
        buf.writeInt(this.shipInID);
    }
}

