/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.optimization;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.PhysPolygonCollider;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.optimization.CollisionInformationHolder;
import valkyrienwarfare.physcollision.WorldPhysicsCollider;
import valkyrienwarfare.relocation.SpatialDetector;

public class ShipCollisionTask
implements Callable<Void> {
    public static final int maxTasksToCheck = 45;
    public final WorldPhysicsCollider toTask;
    final int taskStartIndex;
    final int tasksToCheck;
    final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    final BlockPos.MutableBlockPos inLocalPos = new BlockPos.MutableBlockPos();
    private final Vector inWorld = new Vector();
    public ArrayList<CollisionInformationHolder> collisionInformationGenerated = new ArrayList();
    private IBlockState inWorldState;

    public ShipCollisionTask(WorldPhysicsCollider toTask, int taskStartIndex) {
        this.taskStartIndex = taskStartIndex;
        this.toTask = toTask;
        int size = toTask.cachedPotentialHits.size();
        this.tasksToCheck = taskStartIndex + 45 > size + 1 ? size + 1 - taskStartIndex : 45;
    }

    @Override
    public Void call() {
        for (int index = this.taskStartIndex; index < this.tasksToCheck + 1; ++index) {
            int integer = this.toTask.cachedPotentialHits.get(index);
            this.processNumber(integer);
        }
        return null;
    }

    private void processNumber(int integer) {
        SpatialDetector.setPosWithRespectTo(integer, this.toTask.centerPotentialHit, this.mutablePos);
        this.inWorldState = this.toTask.parent.surroundingWorldChunksCache.func_180495_p((BlockPos)this.mutablePos);
        this.inWorld.X = (double)this.mutablePos.func_177958_n() + 0.5;
        this.inWorld.Y = (double)this.mutablePos.func_177956_o() + 0.5;
        this.inWorld.Z = (double)this.mutablePos.func_177952_p() + 0.5;
        this.toTask.parent.coordTransform.fromGlobalToLocal(this.inWorld);
        int midX = MathHelper.func_76128_c((double)(this.inWorld.X + 0.5));
        int midY = MathHelper.func_76128_c((double)(this.inWorld.Y + 0.5));
        int midZ = MathHelper.func_76128_c((double)(this.inWorld.Z + 0.5));
        this.checkPosition(midX - 1, midY - 1, midZ - 1, integer);
        this.checkPosition(midX - 1, midY - 1, midZ, integer);
        this.checkPosition(midX - 1, midY - 1, midZ + 1, integer);
        this.checkPosition(midX - 1, midY, midZ - 1, integer);
        this.checkPosition(midX - 1, midY, midZ, integer);
        this.checkPosition(midX - 1, midY, midZ + 1, integer);
        this.checkPosition(midX - 1, midY + 1, midZ - 1, integer);
        this.checkPosition(midX - 1, midY + 1, midZ, integer);
        this.checkPosition(midX - 1, midY + 1, midZ + 1, integer);
        this.checkPosition(midX, midY - 1, midZ - 1, integer);
        this.checkPosition(midX, midY - 1, midZ, integer);
        this.checkPosition(midX, midY - 1, midZ + 1, integer);
        this.checkPosition(midX, midY, midZ - 1, integer);
        this.checkPosition(midX, midY, midZ, integer);
        this.checkPosition(midX, midY, midZ + 1, integer);
        this.checkPosition(midX, midY + 1, midZ - 1, integer);
        this.checkPosition(midX, midY + 1, midZ, integer);
        this.checkPosition(midX, midY + 1, midZ + 1, integer);
        this.checkPosition(midX + 1, midY - 1, midZ - 1, integer);
        this.checkPosition(midX + 1, midY - 1, midZ, integer);
        this.checkPosition(midX + 1, midY - 1, midZ + 1, integer);
        this.checkPosition(midX + 1, midY, midZ - 1, integer);
        this.checkPosition(midX + 1, midY, midZ, integer);
        this.checkPosition(midX + 1, midY, midZ + 1, integer);
        this.checkPosition(midX + 1, midY + 1, midZ - 1, integer);
        this.checkPosition(midX + 1, midY + 1, midZ, integer);
        this.checkPosition(midX + 1, midY + 1, midZ + 1, integer);
    }

    public void checkPosition(int x, int y, int z, int positionHash) {
        Chunk chunkIn = this.toTask.parent.VKChunkCache.getChunkAt(x >> 4, z >> 4);
        IBlockState inLocalState = chunkIn.func_186032_a(x, y = Math.max(0, Math.min(y, 255)), z);
        if (inLocalState.func_185904_a().func_76220_a()) {
            this.inLocalPos.func_181079_c(x, y, z);
            AxisAlignedBB inLocalBB = new AxisAlignedBB((double)this.inLocalPos.func_177958_n(), (double)this.inLocalPos.func_177956_o(), (double)this.inLocalPos.func_177952_p(), (double)(this.inLocalPos.func_177958_n() + 1), (double)(this.inLocalPos.func_177956_o() + 1), (double)(this.inLocalPos.func_177952_p() + 1));
            AxisAlignedBB inGlobalBB = new AxisAlignedBB((double)this.mutablePos.func_177958_n(), (double)this.mutablePos.func_177956_o(), (double)this.mutablePos.func_177952_p(), (double)(this.mutablePos.func_177958_n() + 1), (double)(this.mutablePos.func_177956_o() + 1), (double)(this.mutablePos.func_177952_p() + 1));
            Polygon shipInWorld = new Polygon(inLocalBB, this.toTask.parent.coordTransform.lToWTransform);
            Polygon worldPoly = new Polygon(inGlobalBB);
            PhysPolygonCollider collider = new PhysPolygonCollider(shipInWorld, worldPoly, this.toTask.parent.coordTransform.normals);
            if (!collider.seperated) {
                CollisionInformationHolder holder = new CollisionInformationHolder(collider, this.mutablePos.func_177958_n(), this.mutablePos.func_177956_o(), this.mutablePos.func_177952_p(), this.inLocalPos.func_177958_n(), this.inLocalPos.func_177956_o(), this.inLocalPos.func_177952_p(), this.inWorldState, inLocalState);
                this.collisionInformationGenerated.add(holder);
            }
        }
    }
}

