/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physcollision;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import valkyrienwarfare.physics.BlockMass;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class BlockRammingManager {
    public static double collisionImpulseAfterRamming = 0.2;
    public static double minimumVelocityToApply = 3.0;

    public static double processBlockRamming(PhysicsWrapperEntity wrapper, double collisionSpeed, IBlockState inLocalState, IBlockState inWorldState, BlockPos inLocal, BlockPos inWorld, NestedBoolean didBlockBreakInShip, NestedBoolean didBlockBreakInWorld) {
        if (Math.abs(collisionSpeed) > 2.0) {
            double shipBlockHardness = inLocalState.func_177230_c().field_149781_w;
            double worldBlockHardness = inWorldState.func_177230_c().field_149781_w;
            double hardnessRatio = Math.pow(worldBlockHardness / shipBlockHardness, Math.abs(collisionSpeed) / 5.0);
            if (worldBlockHardness == -1.0) {
                worldBlockHardness = 100.0;
            }
            if (shipBlockHardness == -1.0) {
                shipBlockHardness = 100.0;
            }
            double arbitraryScale = 5.4;
            if (hardnessRatio < 0.01) {
                didBlockBreakInWorld.setValue(true);
                double shipBlockMass = BlockMass.basicMass.getMassFromState(inLocalState, inLocal, wrapper.field_70170_p);
                double worldBlockMass = BlockMass.basicMass.getMassFromState(inWorldState, inWorld, wrapper.field_70170_p);
                return Math.pow(worldBlockMass / worldBlockMass, arbitraryScale);
            }
            if (hardnessRatio > 100.0) {
                didBlockBreakInShip.setValue(true);
                double shipBlockMass = BlockMass.basicMass.getMassFromState(inLocalState, inLocal, wrapper.field_70170_p);
                double worldBlockMass = BlockMass.basicMass.getMassFromState(inWorldState, inWorld, wrapper.field_70170_p);
                return Math.pow(shipBlockMass / worldBlockMass, arbitraryScale);
            }
        }
        return 1.0;
    }

    public static final class NestedBoolean {
        private boolean value;

        public NestedBoolean(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }
}

