/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physcollision;

import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.PhysCollisionObject;
import valkyrienwarfare.collision.PhysPolygonCollider;

public class PolygonCollisionPointFinder {
    public static Vector[] getPointsOfCollisionForPolygons(PhysPolygonCollider collider, PhysCollisionObject somethingElse, Vector velocity) {
        double minSecondsAgo = 69.0;
        int minCollisionIndex = 0;
        int minCollisionIndexIndex = 0;
        for (int cont = 0; cont < collider.collisions.length; ++cont) {
            PhysCollisionObject toCollideWith = collider.collisions[cont];
            Vector axis = somethingElse.axis;
            double reverseVelocityAlongAxis = -velocity.dot(axis);
            double minDot = 9.999999999999E12;
            int minIndex = 0;
            for (int i = 0; i < 8; ++i) {
                Vector vertice = toCollideWith.movable.vertices[i];
                double dot = vertice.dot(axis) * reverseVelocityAlongAxis;
                if (!(dot < minDot)) continue;
                minDot = dot;
                minIndex = i;
            }
            Vector contactPoint = toCollideWith.movable.vertices[minIndex];
            double secondsAgo = 69.0;
            secondsAgo = Math.signum(reverseVelocityAlongAxis) == 1.0 ? toCollideWith.movMinFixMax / reverseVelocityAlongAxis : toCollideWith.movMaxFixMin / reverseVelocityAlongAxis;
            if (!(secondsAgo < minSecondsAgo)) continue;
            minSecondsAgo = secondsAgo;
            minCollisionIndex = cont;
            minCollisionIndexIndex = minIndex;
        }
        Vector contactPoint = collider.collisions[minCollisionIndex].movable.vertices[minCollisionIndexIndex];
        return new Vector[]{contactPoint};
    }
}

