/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physcollision;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.PhysCollisionObject;
import valkyrienwarfare.collision.PhysPolygonCollider;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.math.BigBastardMath;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physics.PhysicsCalculationsOrbital;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class ShipPhysicsCollider {
    public static double axisTolerance = 0.3;
    public PhysicsCalculations calculator;
    public World worldObj;
    public PhysicsObject parent;
    public double e = 0.35;
    private ArrayList<BlockPos> cachedPotentialHits;
    private double ticksSinceCacheUpdate = 420.0;

    public ShipPhysicsCollider(PhysicsCalculations calculations) {
        this.calculator = calculations;
        this.parent = calculations.parent;
        this.worldObj = this.parent.worldObj;
    }

    public void doShipCollision(PhysicsObject toCollideWith) {
        if (toCollideWith.physicsProcessor instanceof PhysicsCalculationsOrbital && ((PhysicsCalculationsOrbital)toCollideWith.physicsProcessor).isOrbitalPhased) {
            return;
        }
        if (this.parent.physicsProcessor instanceof PhysicsCalculationsOrbital && ((PhysicsCalculationsOrbital)this.parent.physicsProcessor).isOrbitalPhased) {
            return;
        }
        AxisAlignedBB firstBB = this.parent.collisionBB;
        AxisAlignedBB secondBB = toCollideWith.collisionBB;
        AxisAlignedBB betweenBB = BigBastardMath.getBetweenAABB(firstBB, secondBB);
        Polygon betweenBBPoly = new Polygon(betweenBB, toCollideWith.coordTransform.wToLTransform);
        List bbsInFirst = this.parent.worldObj.func_184144_a((Entity)this.parent.wrapper, betweenBBPoly.getEnclosedAABB());
        if (bbsInFirst.isEmpty()) {
            return;
        }
        Vector[] axes = this.parent.coordTransform.getSeperatingAxisWithShip(toCollideWith);
        for (AxisAlignedBB fromIter : bbsInFirst) {
            Polygon firstInWorld = new Polygon(fromIter, toCollideWith.coordTransform.lToWTransform);
            AxisAlignedBB inWorldAABB = firstInWorld.getEnclosedAABB();
            Polygon inShip2Poly = new Polygon(inWorldAABB, this.parent.coordTransform.wToLTransform);
            List bbsInSecond = this.parent.worldObj.func_184144_a((Entity)this.parent.wrapper, inShip2Poly.getEnclosedAABB());
            Iterator secondRandIter = bbsInSecond.iterator();
            while (secondRandIter.hasNext()) {
                Polygon secondInWorld = new Polygon((AxisAlignedBB)secondRandIter.next(), this.parent.coordTransform.lToWTransform);
                Vector firstCenter = firstInWorld.getCenter();
                Vector secondCenter = secondInWorld.getCenter();
                Vector inBodyFirst = new Vector(firstCenter.X - this.parent.wrapper.field_70165_t, firstCenter.Y - this.parent.wrapper.field_70163_u, firstCenter.Z - this.parent.wrapper.field_70161_v);
                Vector inBodySecond = new Vector(secondCenter.X - toCollideWith.wrapper.field_70165_t, secondCenter.Y - toCollideWith.wrapper.field_70163_u, secondCenter.Z - toCollideWith.wrapper.field_70161_v);
                Vector velAtFirst = this.parent.physicsProcessor.getVelocityAtPoint(inBodyFirst);
                Vector velAtSecond = toCollideWith.physicsProcessor.getVelocityAtPoint(inBodySecond);
                velAtFirst.subtract(velAtSecond);
                PhysPolygonCollider polyCol = new PhysPolygonCollider(firstInWorld, secondInWorld, axes);
                if (polyCol.seperated) continue;
                Vector speedAtPoint = velAtFirst;
                double xDot = Math.abs(speedAtPoint.X);
                double yDot = Math.abs(speedAtPoint.Y);
                double zDot = Math.abs(speedAtPoint.Z);
                PhysCollisionObject polyColObj = null;
                polyColObj = yDot > xDot && yDot > zDot ? (xDot > zDot ? polyCol.collisions[2] : polyCol.collisions[0]) : (xDot > zDot ? polyCol.collisions[1] : polyCol.collisions[1]);
                if (polyColObj.penetrationDistance > axisTolerance || polyColObj.penetrationDistance < -axisTolerance) {
                    polyColObj = polyCol.collisions[polyCol.minDistanceIndex];
                }
                this.processCollisionAtPoint(toCollideWith, polyColObj);
                if (Math.abs(polyColObj.movMaxFixMin) > Math.abs(polyColObj.movMinFixMax)) {
                    for (Vector v : polyColObj.movable.vertices) {
                        if (v.dot(polyColObj.axis) != polyColObj.playerMinMax[1]) continue;
                        polyColObj.firstContactPoint = v;
                    }
                } else {
                    for (Vector v : polyColObj.movable.vertices) {
                        if (v.dot(polyColObj.axis) != polyColObj.playerMinMax[0]) continue;
                        polyColObj.firstContactPoint = v;
                    }
                }
                this.processCollisionAtPoint(toCollideWith, polyColObj);
            }
        }
    }

    private void processCollisionAtPoint(PhysicsObject toCollideWith, PhysCollisionObject object) {
        double e = 0.3;
        Vector inFirstShip = new Vector(object.firstContactPoint);
        Vector inSecondShip = new Vector(object.firstContactPoint);
        inFirstShip.X -= this.parent.wrapper.field_70165_t;
        inFirstShip.Y -= this.parent.wrapper.field_70163_u;
        inFirstShip.Z -= this.parent.wrapper.field_70161_v;
        inSecondShip.X -= toCollideWith.wrapper.field_70165_t;
        inSecondShip.Y -= toCollideWith.wrapper.field_70163_u;
        inSecondShip.Z -= toCollideWith.wrapper.field_70161_v;
        Vector momentumInFirst = this.parent.physicsProcessor.getVelocityAtPoint(inFirstShip);
        Vector momentumInSecond = toCollideWith.physicsProcessor.getVelocityAtPoint(inSecondShip);
        Vector netVelocity = momentumInFirst.getSubtraction(momentumInSecond);
        e = 0.9;
        double topJ = -(e + 1.0) * netVelocity.dot(object.axis);
        double bottomJ = this.parent.physicsProcessor.invMass + toCollideWith.physicsProcessor.invMass;
        bottomJ += RotationMatrices.get3by3TransformedVec(toCollideWith.physicsProcessor.invFramedMOI, inFirstShip.cross(object.axis)).cross(inFirstShip).dot(object.axis);
        double j = topJ / (bottomJ += RotationMatrices.get3by3TransformedVec(toCollideWith.physicsProcessor.invFramedMOI, inSecondShip.cross(object.axis)).cross(inSecondShip).dot(object.axis));
        Vector responseVec = new Vector(object.axis, j);
        if (responseVec.dot(object.getResponse()) < 0.0) {
            responseVec.multiply(-1.0);
            this.parent.physicsProcessor.linearMomentum.add(responseVec);
            Vector cross = inFirstShip.cross(responseVec);
            RotationMatrices.applyTransform3by3(this.parent.physicsProcessor.invFramedMOI, cross);
            this.parent.physicsProcessor.angularVelocity.add(cross);
            responseVec.multiply(-1.0);
            toCollideWith.physicsProcessor.linearMomentum.add(responseVec);
            cross = inSecondShip.cross(responseVec);
            RotationMatrices.applyTransform3by3(toCollideWith.physicsProcessor.invFramedMOI, cross);
            toCollideWith.physicsProcessor.angularVelocity.add(cross);
        }
    }
}

