/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physcollision;

import com.jackredcreeper.cannon.blocks.BlockAirMine;
import com.jackredcreeper.cannon.world.NewExp2;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.collision.PhysCollisionObject;
import valkyrienwarfare.collision.PhysPolygonCollider;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.optimization.CollisionInformationHolder;
import valkyrienwarfare.optimization.ShipCollisionTask;
import valkyrienwarfare.physcollision.BlockRammingManager;
import valkyrienwarfare.physcollision.PolygonCollisionPointFinder;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.relocation.SpatialDetector;

public class WorldPhysicsCollider {
    private static final double expansion = 2.0;
    public static double axisTolerance = 0.3;
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private final Random rand = new Random();
    private final ArrayList<ShipCollisionTask> tasks = new ArrayList();
    public PhysicsCalculations calculator;
    public World worldObj;
    public PhysicsObject parent;
    public double collisionCacheTickUpdateFrequency = 1.0;
    public double collisionElasticity = 0.52;
    public TIntArrayList cachedPotentialHits;
    public BlockPos centerPotentialHit;
    private TIntArrayList cachedHitsToRemove = new TIntArrayList();
    private double ticksSinceCacheUpdate = 420.0;
    private boolean updateCollisionTasksCache = true;

    public WorldPhysicsCollider(PhysicsCalculations calculations) {
        this.calculator = calculations;
        this.parent = calculations.parent;
        this.worldObj = this.parent.worldObj;
    }

    public void runPhysCollision() {
        this.tickUpdatingTheCollisionCache();
        this.processPotentialCollisionsAccurately();
    }

    public void tickUpdatingTheCollisionCache() {
        this.ticksSinceCacheUpdate += 20.0 * this.calculator.physTickSpeed;
        TIntIterator iterator = this.cachedHitsToRemove.iterator();
        while (iterator.hasNext()) {
            this.cachedPotentialHits.remove(iterator.next());
        }
        this.cachedHitsToRemove.clear();
        if (this.shouldUpdateCollisonCache()) {
            this.updatePotentialCollisionCache();
            this.updateCollisionTasksCache = true;
        }
    }

    public void splitIntoCollisionTasks(ArrayList<ShipCollisionTask> toAdd) {
        if (this.updateCollisionTasksCache) {
            this.tasks.clear();
            int size = this.cachedPotentialHits.size();
            for (int index = 0; index < size; index += 45) {
                ShipCollisionTask task = new ShipCollisionTask(this, index);
                this.tasks.add(task);
            }
            this.updateCollisionTasksCache = false;
        }
        toAdd.addAll(this.tasks);
    }

    public void processCollisionTask(ShipCollisionTask task) {
        BlockPos.MutableBlockPos inWorldPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos inLocalPos = new BlockPos.MutableBlockPos();
        for (CollisionInformationHolder info : task.collisionInformationGenerated) {
            inWorldPos.func_181079_c(info.inWorldX, info.inWorldY, info.inWorldZ);
            inLocalPos.func_181079_c(info.inLocalX, info.inLocalY, info.inLocalZ);
            this.handleActualCollision(info.collider, (BlockPos)inWorldPos, (BlockPos)inLocalPos, info.inWorldState, info.inLocalState);
        }
        task.collisionInformationGenerated.clear();
    }

    private void processPotentialCollisionsAccurately() {
        BlockPos.MutableBlockPos localCollisionPos = new BlockPos.MutableBlockPos();
        Vector inWorld = new Vector();
        double rangeCheck = 0.65;
        TIntIterator intIterator = this.cachedPotentialHits.iterator();
        block0: while (intIterator.hasNext()) {
            SpatialDetector.setPosWithRespectTo(intIterator.next(), this.centerPotentialHit, this.mutablePos);
            inWorld.X = (double)this.mutablePos.func_177958_n() + 0.5;
            inWorld.Y = (double)this.mutablePos.func_177956_o() + 0.5;
            inWorld.Z = (double)this.mutablePos.func_177952_p() + 0.5;
            this.parent.coordTransform.fromGlobalToLocal(inWorld);
            int minX = MathHelper.func_76128_c((double)(inWorld.X - 0.65));
            int minY = MathHelper.func_76128_c((double)(inWorld.Y - 0.65));
            int minZ = MathHelper.func_76128_c((double)(inWorld.Z - 0.65));
            int maxX = MathHelper.func_76128_c((double)(inWorld.X + 0.65));
            int maxY = MathHelper.func_76128_c((double)(inWorld.Y + 0.65));
            int maxZ = MathHelper.func_76128_c((double)(inWorld.Z + 0.65));
            int minChunkX = minX >> 4;
            int minChunkY = minY >> 4;
            int minChunkZ = minZ >> 4;
            int maxChunkX = maxX >> 4;
            int maxChunkY = maxY >> 4;
            int maxChunkZ = maxZ >> 4;
            if (minChunkY > 15 || maxChunkY < 0) continue;
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (!this.parent.ownsChunk(chunkX, chunkZ)) continue;
                    Chunk chunkIn = this.parent.VKChunkCache.getChunkAt(chunkX, chunkZ);
                    int minXToCheck = chunkX << 4;
                    int maxXToCheck = minXToCheck + 15;
                    int minZToCheck = chunkZ << 4;
                    int maxZToCheck = minZToCheck + 15;
                    minXToCheck = Math.max(minXToCheck, minX);
                    maxXToCheck = Math.min(maxXToCheck, maxX);
                    minZToCheck = Math.max(minZToCheck, minZ);
                    maxZToCheck = Math.min(maxZToCheck, maxZ);
                    for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                        ExtendedBlockStorage storage = chunkIn.field_76652_q[chunkY];
                        if (storage == null) continue;
                        int minYToCheck = chunkY << 4;
                        int maxYToCheck = minYToCheck + 15;
                        minYToCheck = Math.max(minYToCheck, minY);
                        maxYToCheck = Math.min(maxYToCheck, maxY);
                        for (int x = minXToCheck; x <= maxXToCheck; ++x) {
                            for (int z = minZToCheck; z <= maxZToCheck; ++z) {
                                for (int y = minYToCheck; y <= maxYToCheck; ++y) {
                                    IBlockState state = storage.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
                                    if (!state.func_185904_a().func_76220_a()) continue;
                                    localCollisionPos.func_181079_c(x, y, z);
                                    boolean brokeAWorldBlock = this.handleLikelyCollision((BlockPos)this.mutablePos, (BlockPos)localCollisionPos, this.parent.surroundingWorldChunksCache.func_180495_p((BlockPos)this.mutablePos), state);
                                    if (!brokeAWorldBlock) continue;
                                    int positionRemoved = SpatialDetector.getHashWithRespectTo(this.mutablePos.func_177958_n(), this.mutablePos.func_177956_o(), this.mutablePos.func_177952_p(), this.centerPotentialHit);
                                    this.cachedHitsToRemove.add(positionRemoved);
                                    continue block0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean handleLikelyCollision(BlockPos inWorldPos, BlockPos inLocalPos, IBlockState inWorldState, IBlockState inLocalState) {
        AxisAlignedBB inLocalBB = new AxisAlignedBB((double)inLocalPos.func_177958_n(), (double)inLocalPos.func_177956_o(), (double)inLocalPos.func_177952_p(), (double)(inLocalPos.func_177958_n() + 1), (double)(inLocalPos.func_177956_o() + 1), (double)(inLocalPos.func_177952_p() + 1));
        AxisAlignedBB inGlobalBB = new AxisAlignedBB((double)inWorldPos.func_177958_n(), (double)inWorldPos.func_177956_o(), (double)inWorldPos.func_177952_p(), (double)(inWorldPos.func_177958_n() + 1), (double)(inWorldPos.func_177956_o() + 1), (double)(inWorldPos.func_177952_p() + 1));
        Polygon shipInWorld = new Polygon(inLocalBB, this.parent.coordTransform.lToWTransform);
        Polygon worldPoly = new Polygon(inGlobalBB);
        PhysPolygonCollider collider = new PhysPolygonCollider(shipInWorld, worldPoly, this.parent.coordTransform.normals);
        if (!collider.seperated) {
            return this.handleActualCollision(collider, inWorldPos, inLocalPos, inWorldState, inLocalState);
        }
        return false;
    }

    private boolean handleActualCollision(PhysPolygonCollider collider, BlockPos inWorldPos, BlockPos inLocalPos, IBlockState inWorldState, IBlockState inLocalState) {
        PhysCollisionObject toCollideWith = null;
        toCollideWith = collider.collisions[1];
        if (toCollideWith.penetrationDistance > axisTolerance || toCollideWith.penetrationDistance < -axisTolerance) {
            toCollideWith = collider.collisions[collider.minDistanceIndex];
        }
        BlockRammingManager.NestedBoolean didBlockBreakInShip = new BlockRammingManager.NestedBoolean(false);
        BlockRammingManager.NestedBoolean didBlockBreakInWorld = new BlockRammingManager.NestedBoolean(false);
        Vector positionInBody = collider.entity.getCenter();
        positionInBody.subtract(this.parent.wrapper.field_70165_t, this.parent.wrapper.field_70163_u, this.parent.wrapper.field_70161_v);
        Vector velocityAtPoint = this.calculator.getVelocityAtPoint(positionInBody);
        double collisionSpeed = velocityAtPoint.dot(toCollideWith.axis);
        double impulseApplied = BlockRammingManager.processBlockRamming(this.parent.wrapper, collisionSpeed, inLocalState, inWorldState, inLocalPos, inWorldPos, didBlockBreakInShip, didBlockBreakInWorld);
        Vector[] collisionPoints = PolygonCollisionPointFinder.getPointsOfCollisionForPolygons(collider, toCollideWith, velocityAtPoint);
        impulseApplied /= (double)collisionPoints.length;
        for (Vector collisionPos : collisionPoints) {
            Vector inBody = collisionPos.getSubtraction(new Vector(this.parent.wrapper.field_70165_t, this.parent.wrapper.field_70163_u, this.parent.wrapper.field_70161_v));
            inBody.multiply(-1.0);
            Vector momentumAtPoint = this.calculator.getVelocityAtPoint(inBody);
            Vector axis = toCollideWith.axis;
            Vector offsetVector = toCollideWith.getResponse();
            this.calculateCollisionImpulseForce(inBody, momentumAtPoint, axis, offsetVector, didBlockBreakInShip.getValue(), didBlockBreakInWorld.getValue(), impulseApplied);
        }
        if (didBlockBreakInShip.getValue()) {
            this.worldObj.func_175655_b(inLocalPos, true);
        }
        if (didBlockBreakInWorld.getValue()) {
            if (this.worldObj.func_180495_p(inWorldPos).func_177230_c() instanceof BlockAirMine) {
                double x = inWorldPos.func_177958_n();
                double y = inWorldPos.func_177956_o();
                double z = inWorldPos.func_177952_p();
                float size = 8.0f;
                float power = 0.0f;
                float blast = 0.0f;
                float damage = 100.0f;
                NewExp2 explosion1 = new NewExp2(this.worldObj, null, x, y, z, size, power, damage, blast, false, true);
                explosion1.newBoom(this.worldObj, null, x, y, z, size, power, damage, blast, false, true);
                this.worldObj.func_175698_g(inWorldPos);
            } else {
                this.worldObj.func_175655_b(inWorldPos, true);
            }
            return true;
        }
        return false;
    }

    private void calculateCollisionImpulseForce(Vector inBody, Vector momentumAtPoint, Vector axis, Vector offsetVector, boolean didBlockBreakInShip, boolean didBlockBreakInWorld, double impulseApplied) {
        Vector firstCross = inBody.cross(axis);
        RotationMatrices.applyTransform3by3(this.calculator.invFramedMOI, firstCross);
        Vector secondCross = firstCross.cross(inBody);
        double impulseMagnitude = -momentumAtPoint.dot(axis) * (this.collisionElasticity + 1.0) / (this.calculator.invMass + secondCross.dot(axis));
        Vector collisionImpulseForce = new Vector(axis, impulseMagnitude);
        if (didBlockBreakInShip || didBlockBreakInWorld) {
            collisionImpulseForce.multiply(impulseApplied);
        }
        if (collisionImpulseForce.dot(offsetVector) < 0.0) {
            double collisionVelocity = momentumAtPoint.dot(axis);
            this.addFrictionToNormalForce(momentumAtPoint, collisionImpulseForce);
            this.calculator.linearMomentum.add(collisionImpulseForce);
            Vector thirdCross = inBody.cross(collisionImpulseForce);
            RotationMatrices.applyTransform3by3(this.calculator.invFramedMOI, thirdCross);
            this.calculator.angularVelocity.add(thirdCross);
        }
    }

    private void addFrictionToNormalForce(Vector momentumAtPoint, Vector impulseVector) {
        double kineticFrictionMew = 0.1;
        Vector contactNormal = new Vector(impulseVector);
        contactNormal.normalize();
        Vector frictionVector = new Vector(momentumAtPoint);
        frictionVector.normalize();
        frictionVector.multiply(impulseVector.length() * kineticFrictionMew);
        if (frictionVector.dot(momentumAtPoint) > 0.0) {
            frictionVector.multiply(-1.0);
        }
        double frictionImpulseDot = frictionVector.dot(contactNormal);
        Vector toRemove = contactNormal.getProduct(frictionImpulseDot);
        frictionVector.subtract(toRemove);
        impulseVector.add(frictionVector);
    }

    private void calculateCoulumbFriction(Vector inBody, Vector momentumAtPoint, Vector axis, Vector offsetVector) {
        double coefficientOfFriction = 0.5;
        Vector tangentOfSliding = new Vector();
        double dotProduct = momentumAtPoint.dot(axis);
        tangentOfSliding = new Vector(momentumAtPoint);
        tangentOfSliding.subtract(axis.getProduct(dotProduct));
        tangentOfSliding.normalize();
        Vector firstCross = inBody.cross(tangentOfSliding);
        RotationMatrices.applyTransform3by3(this.calculator.invFramedMOI, firstCross);
        Vector secondCross = firstCross.cross(inBody);
        double magnitudeOfFriction = -momentumAtPoint.dot(tangentOfSliding);
        Vector simpleImpulse = new Vector(tangentOfSliding, magnitudeOfFriction /= this.calculator.invMass + secondCross.dot(tangentOfSliding));
        if (simpleImpulse.dot(offsetVector) < 0.0) {
            this.calculator.linearMomentum.add(simpleImpulse);
            Vector thirdCross = inBody.cross(simpleImpulse);
            RotationMatrices.applyTransform3by3(this.calculator.invFramedMOI, thirdCross);
            this.calculator.angularVelocity.add(thirdCross);
        }
    }

    private boolean shouldUpdateCollisonCache() {
        return this.ticksSinceCacheUpdate > this.collisionCacheTickUpdateFrequency;
    }

    private void updatePotentialCollisionCache() {
        AxisAlignedBB collisionBB = this.parent.collisionBB.func_72314_b(2.0, 2.0, 2.0).func_72321_a(this.calculator.linearMomentum.X * this.calculator.invMass, this.calculator.linearMomentum.Y * this.calculator.invMass, this.calculator.linearMomentum.Z * this.calculator.invMass);
        this.ticksSinceCacheUpdate = 0.0;
        if (Math.random() > 0.5) {
            this.ticksSinceCacheUpdate -= 0.05;
        }
        this.cachedPotentialHits = new TIntArrayList();
        if (collisionBB.field_72337_e < 0.0 || collisionBB.field_72338_b > 255.0) {
            return;
        }
        BlockPos min = new BlockPos(collisionBB.field_72340_a, Math.max(collisionBB.field_72338_b - 1.0, 0.0), collisionBB.field_72339_c);
        BlockPos max = new BlockPos(collisionBB.field_72336_d, Math.min(collisionBB.field_72337_e, 255.0), collisionBB.field_72334_f);
        this.centerPotentialHit = new BlockPos((double)(min.func_177958_n() + max.func_177958_n()) / 2.0, (double)(min.func_177956_o() + max.func_177956_o()) / 2.0, (double)(min.func_177952_p() + max.func_177952_p()) / 2.0);
        ChunkCache cache = this.parent.surroundingWorldChunksCache;
        Vector inLocal = new Vector();
        double rangeCheck = 1.8;
        if (ValkyrienWarfareMod.highAccuracyCollisions) {
            rangeCheck = 3.0;
        }
        int chunkMinX = min.func_177958_n() >> 4;
        int chunkMaxX = (max.func_177958_n() >> 4) + 1;
        int storageMinY = min.func_177956_o() >> 4;
        int storageMaxY = (max.func_177956_o() >> 4) + 1;
        int chunkMinZ = min.func_177952_p() >> 4;
        int chunkMaxZ = (max.func_177952_p() >> 4) + 1;
        int mmX = min.func_177958_n();
        int mmY = min.func_177956_o();
        int mmZ = min.func_177952_p();
        int mxX = max.func_177958_n();
        int mxY = max.func_177956_o();
        int mxZ = max.func_177952_p();
        Vector inBody = new Vector();
        Vector speedInBody = new Vector();
        for (int chunkX = chunkMinX; chunkX < chunkMaxX; ++chunkX) {
            for (int chunkZ = chunkMinZ; chunkZ < chunkMaxZ; ++chunkZ) {
                int arrayChunkX = chunkX - cache.field_72818_a;
                int arrayChunkZ = chunkZ - cache.field_72816_b;
                if (arrayChunkX < 0 || arrayChunkZ < 0 || arrayChunkX > cache.field_72817_c.length - 1 || arrayChunkZ > cache.field_72817_c[0].length - 1) continue;
                Chunk chunk = cache.field_72817_c[arrayChunkX][arrayChunkZ];
                for (int storageY = storageMinY; storageY < storageMaxY; ++storageY) {
                    ExtendedBlockStorage extendedblockstorage = chunk.field_76652_q[storageY];
                    if (extendedblockstorage == null) continue;
                    int minStorageX = chunkX << 4;
                    int minStorageY = storageY << 4;
                    int minStorageZ = chunkZ << 4;
                    int maxStorageX = minStorageX + 16;
                    int maxStorageY = minStorageY + 16;
                    int maxStorageZ = minStorageZ + 16;
                    minStorageX = Math.max(minStorageX, mmX);
                    minStorageY = Math.max(minStorageY, mmY);
                    minStorageZ = Math.max(minStorageZ, mmZ);
                    maxStorageX = Math.min(maxStorageX, mxX);
                    maxStorageY = Math.min(maxStorageY, mxY);
                    maxStorageZ = Math.min(maxStorageZ, mxZ);
                    for (int x = minStorageX; x < maxStorageX; ++x) {
                        for (int y = minStorageY; y < maxStorageY; ++y) {
                            block5: for (int z = minStorageZ; z < maxStorageZ; ++z) {
                                int maxZ;
                                int minZ;
                                int maxY;
                                int minY;
                                int maxX;
                                int minX;
                                IBlockState state = extendedblockstorage.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
                                if (!state.func_185904_a().func_76220_a()) continue;
                                inLocal.X = (double)x + 0.5;
                                inLocal.Y = (double)y + 0.5;
                                inLocal.Z = (double)z + 0.5;
                                this.parent.coordTransform.fromGlobalToLocal(inLocal);
                                inBody.setSubtraction(inLocal, this.parent.centerCoord);
                                this.parent.physicsProcessor.setVectorToVelocityAtPoint(inBody, speedInBody);
                                speedInBody.multiply(-this.parent.physicsProcessor.physRawSpeed);
                                if (ValkyrienWarfareMod.highAccuracyCollisions) {
                                    speedInBody.multiply(20.0);
                                }
                                if (speedInBody.X > 0.0) {
                                    minX = MathHelper.func_76128_c((double)(inLocal.X - rangeCheck));
                                    maxX = MathHelper.func_76128_c((double)(inLocal.X + rangeCheck + speedInBody.X));
                                } else {
                                    minX = MathHelper.func_76128_c((double)(inLocal.X - rangeCheck + speedInBody.X));
                                    maxX = MathHelper.func_76128_c((double)(inLocal.X + rangeCheck));
                                }
                                if (speedInBody.Y > 0.0) {
                                    minY = MathHelper.func_76128_c((double)(inLocal.Y - rangeCheck));
                                    maxY = MathHelper.func_76128_c((double)(inLocal.Y + rangeCheck + speedInBody.Y));
                                } else {
                                    minY = MathHelper.func_76128_c((double)(inLocal.Y - rangeCheck + speedInBody.Y));
                                    maxY = MathHelper.func_76128_c((double)(inLocal.Y + rangeCheck));
                                }
                                if (speedInBody.Z > 0.0) {
                                    minZ = MathHelper.func_76128_c((double)(inLocal.Z - rangeCheck));
                                    maxZ = MathHelper.func_76128_c((double)(inLocal.Z + rangeCheck + speedInBody.Z));
                                } else {
                                    minZ = MathHelper.func_76128_c((double)(inLocal.Z - rangeCheck + speedInBody.Z));
                                    maxZ = MathHelper.func_76128_c((double)(inLocal.Z + rangeCheck));
                                }
                                int shipChunkMinX = minX >> 4;
                                int shipChunkMinY = Math.max(minY >> 4, 0);
                                int shipChunkMinZ = minZ >> 4;
                                int shipChunkMaxX = maxX >> 4;
                                int shipChunkMaxY = Math.min(maxY >> 4, 15);
                                int shipChunkMaxZ = maxZ >> 4;
                                ++shipChunkMaxY;
                                if (++shipChunkMaxZ - shipChunkMinZ > 200 || ++shipChunkMaxX - shipChunkMinX > 200) {
                                    System.err.println("Wtf. This fucking error");
                                    return;
                                }
                                for (int shipChunkX = shipChunkMinX; shipChunkX < shipChunkMaxX; ++shipChunkX) {
                                    for (int shipChunkZ = shipChunkMinZ; shipChunkZ < shipChunkMaxZ; ++shipChunkZ) {
                                        if (!this.parent.ownsChunk(shipChunkX, shipChunkZ)) continue;
                                        Chunk chunkIn = this.parent.VKChunkCache.getChunkAt(shipChunkX, shipChunkZ);
                                        for (int shipChunkYStorage = shipChunkMinY; shipChunkYStorage < shipChunkMaxY; ++shipChunkYStorage) {
                                            ExtendedBlockStorage storage = chunkIn.field_76652_q[shipChunkYStorage];
                                            if (storage == null) continue;
                                            int shipStorageMinX = shipChunkX << 4;
                                            int shipStorageMinY = shipChunkYStorage << 4;
                                            int shipStorageMinZ = shipChunkZ << 4;
                                            int shipStorageMaxX = shipStorageMinX + 16;
                                            int shipStorageMaxY = shipStorageMinY + 16;
                                            int shipStorageMaxZ = shipStorageMinZ + 16;
                                            shipStorageMinX = Math.max(shipStorageMinX, minX);
                                            shipStorageMinY = Math.max(shipStorageMinY, minY);
                                            shipStorageMinZ = Math.max(shipStorageMinZ, minZ);
                                            shipStorageMaxX = Math.min(shipStorageMaxX, maxX);
                                            shipStorageMaxY = Math.min(shipStorageMaxY, maxY);
                                            shipStorageMaxZ = Math.min(shipStorageMaxZ, maxZ);
                                            for (int localX = shipStorageMinX; localX < shipStorageMaxX; ++localX) {
                                                for (int localY = shipStorageMinY; localY < shipStorageMaxY; ++localY) {
                                                    for (int localZ = shipStorageMinZ; localZ < shipStorageMaxZ; ++localZ) {
                                                        IBlockState localState = chunkIn.func_186032_a(localX, localY, localZ);
                                                        if (!localState.func_185904_a().func_76220_a()) continue;
                                                        this.cachedPotentialHits.add(SpatialDetector.getHashWithRespectTo(x, y, z, this.centerPotentialHit));
                                                        continue block5;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.cachedPotentialHits.shuffle(this.rand);
    }
}

