/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physics;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.api.IBlockForceProvider;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physics.Force;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class BlockForce {
    public static BlockForce basicForces = new BlockForce();
    public HashMap<Block, Force> blocksToForces = new HashMap();

    public static void registerBlockForce(Block block, Vector forceVec, boolean isLocal) {
        Force force = new Force(forceVec.X, forceVec.Y, forceVec.Z, isLocal);
        BlockForce.basicForces.blocksToForces.put(block, force);
    }

    public void getForceFromState(IBlockState state, BlockPos pos, World world, double secondsToApply, PhysicsObject obj, Vector toSet) {
        Block block = state.func_177230_c();
        if (block instanceof IBlockForceProvider) {
            Vector forceVector = ((IBlockForceProvider)block).getBlockForceInWorldSpace(world, pos, state, obj.wrapper, secondsToApply);
            if (forceVector == null) {
                toSet.zero();
                return;
            }
            toSet.X = forceVector.X;
            toSet.Y = forceVector.Y;
            toSet.Z = forceVector.Z;
            return;
        }
        Force force = BlockForce.basicForces.blocksToForces.get(block);
        if (force != null) {
            toSet.X = force.X * secondsToApply;
            toSet.Y = force.Y * secondsToApply;
            toSet.Z = force.Z * secondsToApply;
        } else {
            toSet.zero();
        }
    }

    public boolean isBlockProvidingForce(IBlockState state, BlockPos pos, World world) {
        Block block = state.func_177230_c();
        return BlockForce.basicForces.blocksToForces.containsKey(block) || block instanceof IBlockForceProvider;
    }
}

