/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physics;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.api.IBlockMassProvider;

public class BlockMass {
    private static final double defaultMass = 50.0;
    public static BlockMass basicMass = new BlockMass();
    public HashMap<Block, Double> blockToMass = new HashMap();
    public HashMap<Material, Double> materialMass = new HashMap();

    public BlockMass() {
        this.generateMaterialMasses();
    }

    public static void registerBlockMass(Block block, double mass) {
        BlockMass.basicMass.blockToMass.put(block, mass);
    }

    private void generateMaterialMasses() {
        this.materialMass.put(Material.field_151579_a, 0.0);
        this.materialMass.put(Material.field_151574_g, 200.0);
        this.materialMass.put(Material.field_175972_I, 0.0);
        this.materialMass.put(Material.field_151570_A, 15.0);
        this.materialMass.put(Material.field_151568_F, 10.0);
        this.materialMass.put(Material.field_151593_r, 5.0);
        this.materialMass.put(Material.field_151594_q, 15.0);
        this.materialMass.put(Material.field_151571_B, 40.0);
        this.materialMass.put(Material.field_151580_n, 20.0);
        this.materialMass.put(Material.field_151589_v, 70.0);
        this.materialMass.put(Material.field_151596_z, 20.0);
        this.materialMass.put(Material.field_151566_D, 20.0);
        this.materialMass.put(Material.field_151581_o, 0.0);
        this.materialMass.put(Material.field_151592_s, 20.0);
        this.materialMass.put(Material.field_151572_C, 50.0);
        this.materialMass.put(Material.field_151577_b, 30.0);
        this.materialMass.put(Material.field_151578_c, 70.0);
        this.materialMass.put(Material.field_151588_w, 50.0);
        this.materialMass.put(Material.field_151573_f, 250.0);
        this.materialMass.put(Material.field_151587_i, 0.0);
        this.materialMass.put(Material.field_151584_j, 10.0);
        this.materialMass.put(Material.field_151598_x, 40.0);
        this.materialMass.put(Material.field_76233_E, 15.0);
        this.materialMass.put(Material.field_151585_k, 10.0);
        this.materialMass.put(Material.field_151567_E, 0.0);
        this.materialMass.put(Material.field_151591_t, 10.0);
        this.materialMass.put(Material.field_151576_e, 220.0);
        this.materialMass.put(Material.field_151595_p, 45.0);
        this.materialMass.put(Material.field_151597_y, 20.0);
        this.materialMass.put(Material.field_151583_m, 20.0);
        this.materialMass.put(Material.field_189963_J, 0.0);
        this.materialMass.put(Material.field_151590_u, 30.0);
        this.materialMass.put(Material.field_151582_l, 5.0);
        this.materialMass.put(Material.field_151586_h, 0.0);
        this.materialMass.put(Material.field_151569_G, 10.0);
        this.materialMass.put(Material.field_151575_d, 25.0);
    }

    public double getMassFromState(IBlockState state, BlockPos pos, World world) {
        Block block = state.func_177230_c();
        if (block instanceof IBlockMassProvider) {
            return ((IBlockMassProvider)block).getBlockMass(world, pos, state);
        }
        Double fromMap = this.blockToMass.get(block);
        if (fromMap != null) {
            return fromMap;
        }
        Double newMass = this.generateMassForBlock(block);
        this.blockToMass.put(block, newMass);
        return newMass;
    }

    public double getMassFromMaterial(Material material) {
        Double mass = this.materialMass.get(material);
        if (mass == null) {
            mass = 50.0;
            this.materialMass.put(material, mass);
        }
        return mass;
    }

    public Double generateMassForBlock(Block block) {
        if (block instanceof BlockLiquid) {
            return 0.0;
        }
        Material material = block.field_149764_J;
        return this.getMassFromMaterial(material);
    }
}

