/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physics;

import java.util.ArrayList;
import java.util.Collections;
import javax.vecmath.Matrix3d;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.NBTUtils;
import valkyrienwarfare.PhysicsSettings;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.balloon.BalloonProcessor;
import valkyrienwarfare.addon.control.nodenetwork.IPhysicsProcessorNode;
import valkyrienwarfare.addon.control.nodenetwork.Node;
import valkyrienwarfare.api.IBlockForceProvider;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.math.BigBastardMath;
import valkyrienwarfare.math.Quaternion;
import valkyrienwarfare.physcollision.ShipPhysicsCollider;
import valkyrienwarfare.physcollision.WorldPhysicsCollider;
import valkyrienwarfare.physics.BlockForce;
import valkyrienwarfare.physics.BlockMass;
import valkyrienwarfare.physics.PhysicsQueuedForce;
import valkyrienwarfare.physicsmanagement.CoordTransformObject;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class PhysicsCalculations {
    public PhysicsObject parent;
    public PhysicsWrapperEntity wrapperEnt;
    public World worldObj;
    public WorldPhysicsCollider worldCollision;
    public ShipPhysicsCollider shipCollision;
    public Vector centerOfMass;
    public Vector linearMomentum;
    public Vector angularVelocity;
    public Vector torque;
    public double mass;
    public double invMass;
    public Vector gravity = new Vector(0.0, -9.8, 0.0);
    public double physRawSpeed;
    public int iterations = 5;
    public double physTickSpeed = this.physRawSpeed / (double)this.iterations;
    public double drag = 0.99;
    public ArrayList<BlockPos> activeForcePositions = new ArrayList();
    public double[] MoITensor;
    public double[] invMoITensor;
    public double[] framedMOI;
    public double[] invFramedMOI;
    public boolean actAsArchimedes = false;
    @Deprecated
    public boolean isShipPastBuild91 = false;
    private double blocksToMetersConversion = 1.8;

    public PhysicsCalculations(PhysicsObject toProcess) {
        this.parent = toProcess;
        this.wrapperEnt = this.parent.wrapper;
        this.worldObj = toProcess.worldObj;
        this.worldCollision = new WorldPhysicsCollider(this);
        this.shipCollision = new ShipPhysicsCollider(this);
        this.MoITensor = RotationMatrices.getZeroMatrix(3);
        this.invMoITensor = RotationMatrices.getZeroMatrix(3);
        this.framedMOI = RotationMatrices.getZeroMatrix(3);
        this.invFramedMOI = RotationMatrices.getZeroMatrix(3);
        this.centerOfMass = new Vector(toProcess.centerCoord);
        this.linearMomentum = new Vector();
        this.angularVelocity = new Vector();
        this.torque = new Vector();
    }

    public PhysicsCalculations(PhysicsCalculations toCopy) {
        this.parent = toCopy.parent;
        this.wrapperEnt = toCopy.wrapperEnt;
        this.worldObj = toCopy.worldObj;
        this.worldCollision = toCopy.worldCollision;
        this.shipCollision = toCopy.shipCollision;
        this.centerOfMass = toCopy.centerOfMass;
        this.linearMomentum = toCopy.linearMomentum;
        this.angularVelocity = toCopy.angularVelocity;
        this.torque = toCopy.torque;
        this.mass = toCopy.mass;
        this.invMass = toCopy.invMass;
        this.gravity = toCopy.gravity;
        this.physRawSpeed = toCopy.physRawSpeed;
        this.iterations = toCopy.iterations;
        this.physTickSpeed = toCopy.physTickSpeed;
        this.drag = toCopy.drag;
        this.activeForcePositions = toCopy.activeForcePositions;
        this.MoITensor = toCopy.MoITensor;
        this.invMoITensor = toCopy.invMoITensor;
        this.framedMOI = toCopy.framedMOI;
        this.invFramedMOI = toCopy.invFramedMOI;
        this.actAsArchimedes = toCopy.actAsArchimedes;
        this.isShipPastBuild91 = toCopy.isShipPastBuild91;
    }

    public void onSetBlockState(IBlockState oldState, IBlockState newState, BlockPos pos) {
        double newMassAtPos;
        double oldMassAtPos;
        if (newState == oldState) {
            return;
        }
        if (oldState.func_177230_c() == Blocks.field_150350_a) {
            if (BlockForce.basicForces.isBlockProvidingForce(newState, pos, this.worldObj)) {
                this.activeForcePositions.add(pos);
            }
        } else if (this.activeForcePositions.contains(pos)) {
            if (!BlockForce.basicForces.isBlockProvidingForce(newState, pos, this.worldObj)) {
                this.activeForcePositions.remove(pos);
            }
        } else if (BlockForce.basicForces.isBlockProvidingForce(newState, pos, this.worldObj)) {
            this.activeForcePositions.add(pos);
        }
        if (newState.func_177230_c() == Blocks.field_150350_a) {
            this.activeForcePositions.remove(pos);
        }
        if ((oldMassAtPos = BlockMass.basicMass.getMassFromState(oldState, pos, this.worldObj)) != (newMassAtPos = BlockMass.basicMass.getMassFromState(newState, pos, this.worldObj))) {
            double notAHalf = 0.4;
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.5;
            double z = (double)pos.func_177952_p() + 0.5;
            if (oldMassAtPos > 0.0) {
                this.addMassAt(x, y, z, oldMassAtPos /= -9.0);
                this.addMassAt(x + 0.4, y + 0.4, z + 0.4, oldMassAtPos);
                this.addMassAt(x + 0.4, y + 0.4, z - 0.4, oldMassAtPos);
                this.addMassAt(x + 0.4, y - 0.4, z + 0.4, oldMassAtPos);
                this.addMassAt(x + 0.4, y - 0.4, z - 0.4, oldMassAtPos);
                this.addMassAt(x - 0.4, y + 0.4, z + 0.4, oldMassAtPos);
                this.addMassAt(x - 0.4, y + 0.4, z - 0.4, oldMassAtPos);
                this.addMassAt(x - 0.4, y - 0.4, z + 0.4, oldMassAtPos);
                this.addMassAt(x - 0.4, y - 0.4, z - 0.4, oldMassAtPos);
            }
            if (newMassAtPos > 0.0) {
                this.addMassAt(x, y, z, newMassAtPos /= 9.0);
                this.addMassAt(x + 0.4, y + 0.4, z + 0.4, newMassAtPos);
                this.addMassAt(x + 0.4, y + 0.4, z - 0.4, newMassAtPos);
                this.addMassAt(x + 0.4, y - 0.4, z + 0.4, newMassAtPos);
                this.addMassAt(x + 0.4, y - 0.4, z - 0.4, newMassAtPos);
                this.addMassAt(x - 0.4, y + 0.4, z + 0.4, newMassAtPos);
                this.addMassAt(x - 0.4, y + 0.4, z - 0.4, newMassAtPos);
                this.addMassAt(x - 0.4, y - 0.4, z + 0.4, newMassAtPos);
                this.addMassAt(x - 0.4, y - 0.4, z - 0.4, newMassAtPos);
            }
        }
    }

    private void addMassAt(double x, double y, double z, double addedMass) {
        Vector prevCenterOfMass = new Vector(this.centerOfMass);
        if (this.mass > 1.0E-4) {
            this.centerOfMass.multiply(this.mass);
            this.centerOfMass.add(new Vector(x, y, z).getProduct(addedMass));
            this.centerOfMass.multiply(1.0 / (this.mass + addedMass));
        } else {
            this.centerOfMass = new Vector(x, y, z);
            this.MoITensor = RotationMatrices.getZeroMatrix(3);
        }
        double cmShiftX = prevCenterOfMass.X - this.centerOfMass.X;
        double cmShiftY = prevCenterOfMass.Y - this.centerOfMass.Y;
        double cmShiftZ = prevCenterOfMass.Z - this.centerOfMass.Z;
        double rx = x - this.centerOfMass.X;
        double ry = y - this.centerOfMass.Y;
        double rz = z - this.centerOfMass.Z;
        this.MoITensor[0] = this.MoITensor[0] + (cmShiftY * cmShiftY + cmShiftZ * cmShiftZ) * this.mass + (ry * ry + rz * rz) * addedMass;
        this.MoITensor[1] = this.MoITensor[1] - cmShiftX * cmShiftY * this.mass - rx * ry * addedMass;
        this.MoITensor[2] = this.MoITensor[2] - cmShiftX * cmShiftZ * this.mass - rx * rz * addedMass;
        this.MoITensor[3] = this.MoITensor[1];
        this.MoITensor[4] = this.MoITensor[4] + (cmShiftX * cmShiftX + cmShiftZ * cmShiftZ) * this.mass + (rx * rx + rz * rz) * addedMass;
        this.MoITensor[5] = this.MoITensor[5] - cmShiftY * cmShiftZ * this.mass - ry * rz * addedMass;
        this.MoITensor[6] = this.MoITensor[2];
        this.MoITensor[7] = this.MoITensor[5];
        this.MoITensor[8] = this.MoITensor[8] + (cmShiftX * cmShiftX + cmShiftY * cmShiftY) * this.mass + (rx * rx + ry * ry) * addedMass;
        this.mass += addedMass;
        this.invMass = 1.0 / this.mass;
        this.invMoITensor = RotationMatrices.inverse3by3(this.MoITensor);
    }

    public void rawPhysTickPreCol(double newPhysSpeed, int iters) {
        if (!this.isShipPastBuild91) {
            this.recalculateInertiaMatrices();
            this.isShipPastBuild91 = true;
        }
        if (this.parent.doPhysics) {
            this.updatePhysSpeedAndIters(newPhysSpeed, iters);
            this.updateParentCenterOfMass();
            this.calculateFramedMOITensor();
            if (!this.actAsArchimedes) {
                this.sendPhysicsProcessorsTicks();
                this.calculateForces();
            } else {
                this.calculateForcesArchimedes();
            }
        }
    }

    public void processWorldCollision() {
        if (this.parent.doPhysics) {
            this.worldCollision.runPhysCollision();
        }
    }

    public void rawPhysTickPostCol() {
        if (this.parent.doPhysics) {
            if (this.arePhysicsGoingWayTooFast()) {
                this.parent.doPhysics = false;
                this.linearMomentum.zero();
                this.angularVelocity.zero();
                return;
            }
            if (PhysicsSettings.doAirshipRotation) {
                this.applyAngularVelocity();
            }
            if (PhysicsSettings.doAirshipMovement) {
                this.applyLinearVelocity();
            }
        }
    }

    private boolean arePhysicsGoingWayTooFast() {
        if (this.angularVelocity.lengthSq() > 50000.0) {
            System.out.println("Ship tried moving too fast; freezing it and reseting velocities");
            return true;
        }
        if (this.linearMomentum.lengthSq() * this.invMass * this.invMass > 50000.0) {
            System.out.println("Ship tried moving too fast; freezing it and reseting velocities");
            return true;
        }
        return false;
    }

    public void updateParentCenterOfMass() {
        Vector parentCM = this.parent.centerCoord;
        if (!this.parent.centerCoord.equals(this.centerOfMass)) {
            Vector CMDif = this.centerOfMass.getSubtraction(parentCM);
            RotationMatrices.applyTransform(this.parent.coordTransform.lToWRotation, CMDif);
            this.parent.wrapper.field_70165_t -= CMDif.X;
            this.parent.wrapper.field_70163_u -= CMDif.Y;
            this.parent.wrapper.field_70161_v -= CMDif.Z;
            this.parent.centerCoord = new Vector(this.centerOfMass);
            this.parent.coordTransform.updateAllTransforms();
        }
    }

    public void calculateFramedMOITensor() {
        this.framedMOI = new double[9];
        Matrix3d pitch = new Matrix3d();
        Matrix3d yaw = new Matrix3d();
        Matrix3d roll = new Matrix3d();
        pitch.rotX(Math.toRadians(this.parent.wrapper.pitch));
        yaw.rotY(Math.toRadians(this.parent.wrapper.yaw));
        roll.rotZ(Math.toRadians(this.parent.wrapper.roll));
        pitch.mul(yaw);
        pitch.mul(roll);
        pitch.normalize();
        Matrix3d inertiaBodyFrame = new Matrix3d(this.MoITensor);
        Matrix3d multipled = new Matrix3d();
        multipled.mul(pitch, inertiaBodyFrame);
        pitch.transpose();
        multipled.mul(pitch);
        this.framedMOI[0] = multipled.m00;
        this.framedMOI[1] = multipled.m01;
        this.framedMOI[2] = multipled.m02;
        this.framedMOI[3] = multipled.m10;
        this.framedMOI[4] = multipled.m11;
        this.framedMOI[5] = multipled.m12;
        this.framedMOI[6] = multipled.m20;
        this.framedMOI[7] = multipled.m21;
        this.framedMOI[8] = multipled.m22;
        this.invFramedMOI = RotationMatrices.inverse3by3(this.framedMOI);
    }

    public void calculateForces() {
        double modifiedDrag = Math.pow(this.drag, this.physTickSpeed / 0.05);
        this.linearMomentum.multiply(modifiedDrag);
        this.angularVelocity.multiply(modifiedDrag);
        this.applyGravity();
        this.addQueuedForces();
        Collections.shuffle(this.activeForcePositions);
        Vector blockForce = new Vector();
        Vector inBodyWO = new Vector();
        Vector crossVector = new Vector();
        if (PhysicsSettings.doPhysicsBlocks) {
            for (Node node : this.parent.nodesWithinShip) {
                TileEntity nodeTile = node.parentTile;
                if (!(nodeTile instanceof IPhysicsProcessorNode)) continue;
                ((IPhysicsProcessorNode)nodeTile).onPhysicsTick(this.parent, this, this.physRawSpeed);
            }
            for (BlockPos pos : this.activeForcePositions) {
                Vector otherPosition;
                IBlockState state = this.parent.VKChunkCache.getBlockState(pos);
                Block blockAt = state.func_177230_c();
                BigBastardMath.getBodyPosWithOrientation(pos, this.centerOfMass, this.parent.coordTransform.lToWRotation, inBodyWO);
                BlockForce.basicForces.getForceFromState(state, pos, this.worldObj, this.physTickSpeed, this.parent, blockForce);
                if (blockForce == null) continue;
                if (blockAt instanceof IBlockForceProvider && (otherPosition = ((IBlockForceProvider)blockAt).getCustomBlockForcePosition(this.worldObj, pos, state, this.parent.wrapper, this.physTickSpeed)) != null) {
                    BigBastardMath.getBodyPosWithOrientation(otherPosition, this.centerOfMass, this.parent.coordTransform.lToWRotation, inBodyWO);
                }
                this.addForceAtPoint(inBodyWO, blockForce, crossVector);
            }
        }
        if (PhysicsSettings.doBalloons) {
            for (BalloonProcessor balloon : this.parent.balloonManager.balloonProcessors) {
                balloon.tickBalloonTemperatures(this.physTickSpeed, this);
                Vector balloonForce = balloon.getBalloonForce(this.physTickSpeed, this);
                Vector balloonCenterInBody = balloon.getForceCenter();
                BigBastardMath.getBodyPosWithOrientation(balloonCenterInBody, this.centerOfMass, this.parent.coordTransform.lToWRotation, inBodyWO);
                this.addForceAtPoint(inBodyWO, balloonForce, crossVector);
            }
        }
        this.convertTorqueToVelocity();
    }

    public void applyGravity() {
        if (PhysicsSettings.doGravity) {
            this.addForceAtPoint(new Vector(0.0, 0.0, 0.0), ValkyrienWarfareMod.gravity.getProduct(this.mass * this.physTickSpeed));
        }
    }

    public void calculateForcesArchimedes() {
        double modifiedDrag = Math.pow(this.drag, this.physTickSpeed / 0.05);
        this.linearMomentum.multiply(modifiedDrag);
        this.angularVelocity.multiply(modifiedDrag);
    }

    public void sendPhysicsProcessorsTicks() {
    }

    public void addQueuedForces() {
        Collections.shuffle(this.parent.queuedPhysForces);
        for (PhysicsQueuedForce queuedForce : this.parent.queuedPhysForces) {
            Vector forceVec = new Vector(queuedForce.force);
            if (queuedForce.isLocal) {
                RotationMatrices.doRotationOnly(this.parent.coordTransform.lToWRotation, forceVec);
            }
            forceVec.multiply(this.physTickSpeed);
            Vector posVec = new Vector(queuedForce.inBodyPos);
            posVec.X -= this.wrapperEnt.field_70165_t;
            posVec.Y -= this.wrapperEnt.field_70163_u;
            posVec.Z -= this.wrapperEnt.field_70161_v;
            this.addForceAtPoint(posVec, forceVec);
        }
    }

    public void convertTorqueToVelocity() {
        if (!this.torque.isZero()) {
            this.angularVelocity.add(RotationMatrices.get3by3TransformedVec(this.invFramedMOI, this.torque));
            this.torque.zero();
        }
    }

    public void addForceAtPoint(Vector inBodyWO, Vector forceToApply) {
        forceToApply.multiply(this.blocksToMetersConversion);
        this.torque.add(inBodyWO.cross(forceToApply));
        this.linearMomentum.add(forceToApply);
    }

    public void addForceAtPoint(Vector inBodyWO, Vector forceToApply, Vector crossVector) {
        forceToApply.multiply(this.blocksToMetersConversion);
        crossVector.setCross(inBodyWO, forceToApply);
        this.torque.add(crossVector);
        this.linearMomentum.add(forceToApply);
    }

    public void updatePhysSpeedAndIters(double newPhysSpeed, int iters) {
        this.physRawSpeed = newPhysSpeed;
        this.iterations = iters;
        this.physTickSpeed = this.physRawSpeed / (double)this.iterations;
    }

    public void applyAngularVelocity() {
        CoordTransformObject coordTrans = this.parent.coordTransform;
        double[] rotationChange = RotationMatrices.getRotationMatrix(this.angularVelocity.X, this.angularVelocity.Y, this.angularVelocity.Z, this.angularVelocity.length() * this.physTickSpeed);
        Quaternion original = Quaternion.QuaternionFromMatrix(coordTrans.lToWRotation);
        Quaternion faggot = Quaternion.QuaternionFromMatrix(RotationMatrices.getMatrixProduct(rotationChange, coordTrans.lToWRotation));
        double[] radians = (faggot = Quaternion.getBetweenQuat(original, faggot, 1.0)).toRadians();
        this.wrapperEnt.pitch = Double.isNaN(radians[0]) ? 0.0 : (double)((float)Math.toDegrees(radians[0]));
        this.wrapperEnt.yaw = Double.isNaN(radians[1]) ? 0.0 : (double)((float)Math.toDegrees(radians[1]));
        this.wrapperEnt.roll = Double.isNaN(radians[2]) ? 0.0 : (double)((float)Math.toDegrees(radians[2]));
        coordTrans.updateAllTransforms();
    }

    public void applyLinearVelocity() {
        if (this.mass > 0.0) {
            double momentMod = this.physTickSpeed * this.invMass;
            this.wrapperEnt.field_70165_t += this.linearMomentum.X * momentMod;
            this.wrapperEnt.field_70163_u += this.linearMomentum.Y * momentMod;
            this.wrapperEnt.field_70161_v += this.linearMomentum.Z * momentMod;
        }
        if (this.wrapperEnt.field_70163_u > ValkyrienWarfareMod.shipUpperLimit) {
            this.wrapperEnt.field_70163_u = ValkyrienWarfareMod.shipUpperLimit;
        }
        if (this.wrapperEnt.field_70163_u < ValkyrienWarfareMod.shipLowerLimit) {
            this.wrapperEnt.field_70163_u = ValkyrienWarfareMod.shipLowerLimit;
        }
    }

    public Vector getVelocityAtPoint(Vector inBodyWO) {
        Vector speed = this.angularVelocity.cross(inBodyWO);
        speed.X += this.linearMomentum.X * this.invMass;
        speed.Y += this.linearMomentum.Y * this.invMass;
        speed.Z += this.linearMomentum.Z * this.invMass;
        return speed;
    }

    public void setVectorToVelocityAtPoint(Vector inBodyWO, Vector toSet) {
        toSet.setCross(this.angularVelocity, inBodyWO);
        toSet.X += this.linearMomentum.X * this.invMass;
        toSet.Y += this.linearMomentum.Y * this.invMass;
        toSet.Z += this.linearMomentum.Z * this.invMass;
    }

    public void writeToNBTTag(NBTTagCompound compound) {
        compound.func_74780_a("mass", this.mass);
        NBTUtils.writeVectorToNBT("linear", this.linearMomentum, compound);
        NBTUtils.writeVectorToNBT("angularVelocity", this.angularVelocity, compound);
        NBTUtils.writeVectorToNBT("CM", this.centerOfMass, compound);
        NBTUtils.write3x3MatrixToNBT("MOI", this.MoITensor, compound);
        compound.func_74757_a("isShipPastBuild91", this.isShipPastBuild91);
    }

    public void readFromNBTTag(NBTTagCompound compound) {
        this.mass = compound.func_74769_h("mass");
        this.linearMomentum = NBTUtils.readVectorFromNBT("linear", compound);
        this.angularVelocity = NBTUtils.readVectorFromNBT("angularVelocity", compound);
        this.centerOfMass = NBTUtils.readVectorFromNBT("CM", compound);
        this.MoITensor = NBTUtils.read3x3MatrixFromNBT("MOI", compound);
        this.isShipPastBuild91 = compound.func_74767_n("isShipPastBuild91");
        this.processNBTRead();
    }

    public void processNBTRead() {
        this.invMoITensor = RotationMatrices.inverse3by3(this.MoITensor);
        this.invMass = 1.0 / this.mass;
    }

    public void processInitialPhysicsData() {
        IBlockState Air = Blocks.field_150350_a.func_176223_P();
        for (BlockPos pos : this.parent.blockPositions) {
            this.onSetBlockState(Air, this.parent.VKChunkCache.getBlockState(pos), pos);
        }
    }

    @Deprecated
    private void recalculateInertiaMatrices() {
        this.mass = 0.0;
        this.centerOfMass = new Vector((double)this.parent.refrenceBlockPos.func_177958_n() + 0.5, (double)this.parent.refrenceBlockPos.func_177956_o() + 0.5, (double)this.parent.refrenceBlockPos.func_177952_p() + 0.5);
        IBlockState airState = Blocks.field_150350_a.func_176223_P();
        this.activeForcePositions = new ArrayList();
        for (BlockPos pos : this.parent.blockPositions) {
            this.onSetBlockState(airState, this.parent.VKChunkCache.getBlockState(pos), pos);
        }
        System.out.println("Recalculated physics inertia matrix for an old Ship of size " + this.parent.blockPositions.size());
        this.processNBTRead();
    }
}

