/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physics;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import valkyrienwarfare.PhysicsSettings;
import valkyrienwarfare.addon.control.nodenetwork.IPhysicsProcessorNode;
import valkyrienwarfare.addon.control.nodenetwork.Node;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class PhysicsCalculationsManualControl
extends PhysicsCalculations {
    public double yawRate;
    public double forwardRate;
    public double upRate;
    public double setRoll = 0.01;
    public double setPitch = 0.01;
    public boolean useLinearMomentumForce;

    public PhysicsCalculationsManualControl(PhysicsObject toProcess) {
        super(toProcess);
    }

    public PhysicsCalculations downgradeToNormalCalculations() {
        PhysicsCalculations normalCalculations = new PhysicsCalculations(this);
        return normalCalculations;
    }

    @Override
    public void calculateForces() {
        double modifiedDrag = Math.pow(this.drag, this.physTickSpeed / 0.05);
        this.linearMomentum.multiply(modifiedDrag);
        this.angularVelocity.multiply(modifiedDrag);
        if (PhysicsSettings.doPhysicsBlocks) {
            for (Node node : this.parent.nodesWithinShip) {
                TileEntity nodeTile = node.parentTile;
                if (!(nodeTile instanceof IPhysicsProcessorNode)) continue;
                ((IPhysicsProcessorNode)nodeTile).onPhysicsTick(this.parent, this, this.physRawSpeed);
            }
        }
    }

    @Override
    public void applyGravity() {
    }

    @Override
    public void rawPhysTickPostCol() {
        this.applyLinearVelocity();
        double previousYaw = this.parent.wrapper.yaw;
        this.applyAngularVelocity();
        if (!this.actAsArchimedes) {
            this.parent.wrapper.pitch = this.setPitch;
            this.parent.wrapper.roll = this.setRoll;
            this.parent.wrapper.yaw = previousYaw;
            this.parent.wrapper.yaw -= this.yawRate * this.physTickSpeed;
        }
        double[] existingRotationMatrix = RotationMatrices.getRotationMatrix(0.0, this.parent.wrapper.yaw, 0.0);
        Vector linearForce = new Vector(this.forwardRate, this.upRate, 0.0, existingRotationMatrix);
        if (this.useLinearMomentumForce) {
            linearForce = new Vector(this.linearMomentum, this.invMass);
        }
        linearForce.multiply(this.physTickSpeed);
        this.parent.wrapper.field_70165_t += linearForce.X;
        this.parent.wrapper.field_70163_u += linearForce.Y;
        this.parent.wrapper.field_70161_v += linearForce.Z;
        this.parent.coordTransform.updateAllTransforms();
    }

    @Override
    public void writeToNBTTag(NBTTagCompound compound) {
        super.writeToNBTTag(compound);
        compound.func_74780_a("yawRate", this.yawRate);
        compound.func_74780_a("forwardRate", this.forwardRate);
        compound.func_74780_a("upRate", this.upRate);
    }

    @Override
    public void readFromNBTTag(NBTTagCompound compound) {
        super.readFromNBTTag(compound);
        this.yawRate = compound.func_74769_h("yawRate");
    }
}

