/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physics;

import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.math.Quaternion;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physicsmanagement.CoordTransformObject;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class PhysicsCalculationsOrbital
extends PhysicsCalculations {
    public boolean isOrbitalPhased = true;
    private Vector setLinearVel = new Vector();
    private Vector setAngularVel = new Vector();

    public PhysicsCalculationsOrbital(PhysicsObject toProcess) {
        super(toProcess);
    }

    @Override
    public void processWorldCollision() {
        if (!this.isOrbitalPhased) {
            super.processWorldCollision();
        }
    }

    @Override
    public void calculateForces() {
        this.isOrbitalPhased = true;
        if (!this.isOrbitalPhased) {
            super.calculateForces();
        } else {
            double modifiedDrag = Math.pow(this.drag, this.physTickSpeed / 0.05);
            this.setLinearVel.multiply(modifiedDrag);
            this.setAngularVel.multiply(modifiedDrag);
        }
    }

    @Override
    public void addQueuedForces() {
        if (!this.isOrbitalPhased) {
            super.addQueuedForces();
        }
    }

    @Override
    public void applyLinearVelocity() {
        if (!this.isOrbitalPhased) {
            super.applyLinearVelocity();
        } else {
            this.parent.wrapper.field_70165_t += this.physTickSpeed * this.setLinearVel.X;
            this.parent.wrapper.field_70163_u += this.physTickSpeed * this.setLinearVel.Y;
            this.parent.wrapper.field_70161_v += this.physTickSpeed * this.setLinearVel.Z;
        }
    }

    @Override
    public void applyAngularVelocity() {
        if (!this.isOrbitalPhased) {
            super.applyAngularVelocity();
        } else {
            CoordTransformObject coordTrans = this.parent.coordTransform;
            double[] rotationChange = RotationMatrices.getRotationMatrix(this.setAngularVel.X, this.setAngularVel.Y, this.setAngularVel.Z, this.angularVelocity.length() * this.physTickSpeed);
            Quaternion faggot = Quaternion.QuaternionFromMatrix(RotationMatrices.getMatrixProduct(rotationChange, coordTrans.lToWRotation));
            double[] radians = faggot.toRadians();
            this.wrapperEnt.pitch = Double.isNaN(radians[0]) ? 0.0 : (double)((float)Math.toDegrees(radians[0]));
            this.wrapperEnt.yaw = Double.isNaN(radians[1]) ? 0.0 : (double)((float)Math.toDegrees(radians[1]));
            this.wrapperEnt.roll = Double.isNaN(radians[2]) ? 0.0 : (double)((float)Math.toDegrees(radians[2]));
            coordTrans.updateAllTransforms();
        }
    }

    public void setLinearVel(Vector newLinearVel) {
        this.setLinearVel = newLinearVel;
    }

    public void setAngularVel(Vector newAngularVel) {
        this.setAngularVel = newAngularVel;
    }
}

