/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physics;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.physicsmanagement.PhysicsObject;

public class ShipFluidProcessor {
    public final PhysicsObject parent;
    public ArrayList<BlockPos> submergedAirPositions = new ArrayList();
    public ArrayList<BlockPos>[] solidPositionsAtYLevel = new ArrayList[256];

    public ShipFluidProcessor(PhysicsObject parent) {
        this.parent = parent;
    }

    public void updateSubmergedPositionsCalculations(float maxTime) {
        int yOceanLevel = this.getWaterLevelAtShip();
        Vector shipUpNormal = new Vector(0.0, 1.0, 0.0, this.parent.coordTransform.lToWRotation);
        int maxYToCheck = yOceanLevel;
        int minYToCheck = Math.max(MathHelper.func_76128_c((double)this.parent.wrapper.func_174813_aQ().field_72338_b), 0);
        for (int currentY = maxYToCheck; currentY > minYToCheck; ++currentY) {
        }
    }

    private int getWaterLevelAtShip() {
        return 45;
    }

    private boolean doesStateBlockWater(IBlockState state) {
        return state.func_185913_b();
    }

    public void generateYLevelData() {
        for (BlockPos pos : this.parent.blockPositions) {
            IBlockState state = this.parent.VKChunkCache.getBlockState(pos);
            if (!this.doesStateBlockWater(state)) continue;
            int yPos = pos.func_177956_o();
            ArrayList<Object> dataAtY = this.solidPositionsAtYLevel[yPos];
            if (dataAtY == null) {
                this.solidPositionsAtYLevel[yPos] = dataAtY = new ArrayList();
            }
            dataAtY.add(pos);
        }
    }

    public void onSetBlockState(BlockPos pos, IBlockState oldState, IBlockState newState) {
        boolean doesNewStateBlockWater;
        boolean doesOldStateBlockWater;
        int yPos = pos.func_177956_o();
        ArrayList<Object> dataAtY = this.solidPositionsAtYLevel[yPos];
        if (dataAtY == null) {
            dataAtY = new ArrayList();
            this.solidPositionsAtYLevel[yPos] = dataAtY;
        }
        if ((doesOldStateBlockWater = this.doesStateBlockWater(oldState)) != (doesNewStateBlockWater = this.doesStateBlockWater(newState))) {
            if (doesNewStateBlockWater) {
                dataAtY.add(pos);
            } else {
                dataAtY.remove(pos);
            }
        }
    }

    class NestedCrossSection {
        public final ArrayList<BlockPos> normalizedSolidPositions = new ArrayList();
        public final ArrayList<BlockPos> airPositions = new ArrayList();
        final int yLevelToSimulate;
        final Vector shipUpNormalVector;
        private final AxisAlignedBB shipBB;
        private final ArrayList<BlockPos>[] solidPositionsAtYLevel;
        private final double[] lToWTransform;
        public List<BlockPos> blockPositionsOfCrossSection;

        public NestedCrossSection(int yLevelToSimulate, Vector shipUpNormalVector, ArrayList<BlockPos>[] solidPositionsAtYLevel, AxisAlignedBB shipBB, double[] lToWTransform) {
            this.yLevelToSimulate = yLevelToSimulate;
            this.shipUpNormalVector = shipUpNormalVector;
            this.solidPositionsAtYLevel = solidPositionsAtYLevel;
            this.shipBB = shipBB;
            this.lToWTransform = lToWTransform;
        }

        public void runSimulation() {
        }
    }
}

