/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physicsmanagement;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.interaction.IDraggable;
import valkyrienwarfare.network.EntityRelativePositionMessage;
import valkyrienwarfare.network.PhysWrapperPositionMessage;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.physicsmanagement.ShipTransformationStack;

public class CoordTransformObject {
    public PhysicsObject parent;
    public double[] lToWRotation = RotationMatrices.getDoubleIdentity();
    public double[] wToLRotation = RotationMatrices.getDoubleIdentity();
    public double[] lToWTransform = RotationMatrices.getDoubleIdentity();
    public double[] wToLTransform = RotationMatrices.getDoubleIdentity();
    public double[] RlToWRotation = RotationMatrices.getDoubleIdentity();
    public double[] RwToLRotation = RotationMatrices.getDoubleIdentity();
    public double[] RlToWTransform = RotationMatrices.getDoubleIdentity();
    public double[] RwToLTransform = RotationMatrices.getDoubleIdentity();
    public double[] prevlToWTransform;
    public double[] prevwToLTransform;
    public double[] prevLToWRotation;
    public double[] prevWToLRotation;
    public Vector[] normals = Vector.generateAxisAlignedNorms();
    public ShipTransformationStack stack = new ShipTransformationStack();

    public CoordTransformObject(PhysicsObject object) {
        this.parent = object;
        this.updateAllTransforms();
        this.prevlToWTransform = this.lToWTransform;
        this.prevwToLTransform = this.wToLTransform;
    }

    public void updateMatricesOnly() {
        this.lToWTransform = RotationMatrices.getTranslationMatrix(this.parent.wrapper.field_70165_t, this.parent.wrapper.field_70163_u, this.parent.wrapper.field_70161_v);
        this.lToWTransform = RotationMatrices.rotateAndTranslate(this.lToWTransform, this.parent.wrapper.pitch, this.parent.wrapper.yaw, this.parent.wrapper.roll, this.parent.centerCoord);
        this.lToWRotation = RotationMatrices.getDoubleIdentity();
        this.lToWRotation = RotationMatrices.rotateOnly(this.lToWRotation, this.parent.wrapper.pitch, this.parent.wrapper.yaw, this.parent.wrapper.roll);
        this.wToLTransform = RotationMatrices.inverse(this.lToWTransform);
        this.wToLRotation = RotationMatrices.inverse(this.lToWRotation);
        this.RlToWTransform = this.lToWTransform;
        this.RwToLTransform = this.wToLTransform;
        this.RlToWRotation = this.lToWRotation;
        this.RwToLRotation = this.wToLRotation;
    }

    public void updateRenderMatrices(double x, double y, double z, double pitch, double yaw, double roll) {
        this.RlToWTransform = RotationMatrices.getTranslationMatrix(x, y, z);
        this.RlToWTransform = RotationMatrices.rotateAndTranslate(this.RlToWTransform, pitch, yaw, roll, this.parent.centerCoord);
        this.RwToLTransform = RotationMatrices.inverse(this.RlToWTransform);
        this.RlToWRotation = RotationMatrices.rotateOnly(RotationMatrices.getDoubleIdentity(), pitch, yaw, roll);
        this.RwToLRotation = RotationMatrices.inverse(this.RlToWRotation);
    }

    public void setPrevMatrices() {
        this.prevlToWTransform = this.lToWTransform;
        this.prevwToLTransform = this.wToLTransform;
        this.prevLToWRotation = this.lToWRotation;
        this.prevWToLRotation = this.wToLRotation;
    }

    public void updateAllTransforms() {
        this.updatePosRelativeToWorldBorder();
        this.updateMatricesOnly();
        this.updateParentAABB();
        this.updateParentNormals();
        this.updatePassengerPositions();
    }

    public void updatePosRelativeToWorldBorder() {
        WorldBorder border = this.parent.worldObj.func_175723_af();
        AxisAlignedBB shipBB = this.parent.collisionBB;
        if (shipBB.field_72336_d > border.func_177728_d()) {
            this.parent.wrapper.field_70165_t += border.func_177728_d() - shipBB.field_72336_d;
        }
        if (shipBB.field_72340_a < border.func_177726_b()) {
            this.parent.wrapper.field_70165_t += border.func_177726_b() - shipBB.field_72340_a;
        }
        if (shipBB.field_72334_f > border.func_177733_e()) {
            this.parent.wrapper.field_70161_v += border.func_177733_e() - shipBB.field_72334_f;
        }
        if (shipBB.field_72339_c < border.func_177736_c()) {
            this.parent.wrapper.field_70161_v += border.func_177736_c() - shipBB.field_72339_c;
        }
    }

    public void updatePassengerPositions() {
        for (Entity entity : this.parent.wrapper.field_184244_h) {
            this.parent.wrapper.func_184232_k(entity);
        }
    }

    public void sendPositionToPlayers() {
        PhysWrapperPositionMessage posMessage = new PhysWrapperPositionMessage(this.parent.wrapper);
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (Entity entity : this.parent.worldObj.field_72996_f) {
            IDraggable draggable;
            if (!(entity instanceof IDraggable) || (draggable = (IDraggable)entity).getWorldBelowFeet() != this.parent.wrapper) continue;
            entityList.add(entity);
        }
        EntityRelativePositionMessage otherPositionMessage = new EntityRelativePositionMessage(this.parent.wrapper, entityList);
        for (EntityPlayerMP player : this.parent.watchingPlayers) {
            ValkyrienWarfareMod.physWrapperNetwork.sendTo((IMessage)posMessage, player);
            ValkyrienWarfareMod.physWrapperNetwork.sendTo((IMessage)otherPositionMessage, player);
        }
    }

    public void updateParentNormals() {
        int i;
        this.normals = new Vector[15];
        Vector[] alignedNorms = Vector.generateAxisAlignedNorms();
        Vector[] rotatedNorms = this.generateRotationNormals();
        for (int i2 = 0; i2 < 6; ++i2) {
            Vector currentNorm = null;
            currentNorm = i2 < 3 ? alignedNorms[i2] : rotatedNorms[i2 - 3];
            this.normals[i2] = currentNorm;
        }
        int cont = 6;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Vector norm;
                this.normals[cont] = norm = this.normals[i].crossAndUnit(this.normals[j + 3]);
                ++cont;
            }
        }
        for (i = 0; i < this.normals.length; ++i) {
            if (!this.normals[i].isZero()) continue;
            this.normals[i] = new Vector(0.0, 1.0, 0.0);
        }
        this.normals[0] = new Vector(1.0, 0.0, 0.0);
        this.normals[1] = new Vector(0.0, 1.0, 0.0);
        this.normals[2] = new Vector(0.0, 0.0, 1.0);
    }

    public Vector[] generateRotationNormals() {
        Vector[] norms = Vector.generateAxisAlignedNorms();
        for (int i = 0; i < 3; ++i) {
            RotationMatrices.applyTransform(this.lToWRotation, norms[i]);
        }
        return norms;
    }

    public Vector[] getSeperatingAxisWithShip(PhysicsObject other) {
        Vector[] normals = new Vector[15];
        Vector[] otherNorms = other.coordTransform.normals;
        Vector[] rotatedNorms = normals;
        for (int i = 0; i < 6; ++i) {
            normals[i] = i < 3 ? otherNorms[i] : rotatedNorms[i - 3];
        }
        int cont = 6;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Vector norm = normals[i].crossAndUnit(normals[j + 3]);
                normals[cont] = !norm.isZero() ? norm : normals[1];
                ++cont;
            }
        }
        return normals;
    }

    public void updateParentAABB() {
        AxisAlignedBB enclosingBB;
        double mnX = 0.0;
        double mnY = 0.0;
        double mnZ = 0.0;
        double mxX = 0.0;
        double mxY = 0.0;
        double mxZ = 0.0;
        Vector currentLocation = new Vector();
        mnX = mxX = this.parent.wrapper.field_70165_t;
        mnY = mxY = this.parent.wrapper.field_70163_u;
        mnZ = mxZ = this.parent.wrapper.field_70161_v;
        for (BlockPos pos : this.parent.blockPositions) {
            currentLocation.X = (double)pos.func_177958_n() + 0.5;
            currentLocation.Y = (double)pos.func_177956_o() + 0.5;
            currentLocation.Z = (double)pos.func_177952_p() + 0.5;
            this.fromLocalToGlobal(currentLocation);
            if (currentLocation.X < mnX) {
                mnX = currentLocation.X;
            }
            if (currentLocation.X > mxX) {
                mxX = currentLocation.X;
            }
            if (currentLocation.Y < mnY) {
                mnY = currentLocation.Y;
            }
            if (currentLocation.Y > mxY) {
                mxY = currentLocation.Y;
            }
            if (currentLocation.Z < mnZ) {
                mnZ = currentLocation.Z;
            }
            if (!(currentLocation.Z > mxZ)) continue;
            mxZ = currentLocation.Z;
        }
        this.parent.collisionBB = enclosingBB = new AxisAlignedBB(mnX, mnY, mnZ, mxX, mxY, mxZ).func_72314_b(0.6, 0.6, 0.6);
    }

    public void fromGlobalToLocal(Vector inGlobal) {
        RotationMatrices.applyTransform(this.wToLTransform, inGlobal);
    }

    public void fromLocalToGlobal(Vector inLocal) {
        RotationMatrices.applyTransform(this.lToWTransform, inLocal);
    }
}

