/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physicsmanagement;

import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.chunkmanagement.PhysicsChunkManager;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.physicsmanagement.WorldPhysObjectManager;

public class DimensionPhysObjectManager {
    private HashMap<World, WorldPhysObjectManager> managerPerWorld = new HashMap();
    private WorldPhysObjectManager cachedManager;

    public void onShipPreload(PhysicsWrapperEntity toPreload) {
        this.getManagerForWorld(toPreload.field_70170_p).preloadPhysicsWrapperEntityMappings(toPreload);
    }

    public void onShipLoad(PhysicsWrapperEntity justLoaded) {
        this.getManagerForWorld(justLoaded.field_70170_p).onLoad(justLoaded);
    }

    public void onShipUnload(PhysicsWrapperEntity justUnloaded) {
        this.getManagerForWorld(justUnloaded.field_70170_p).onUnload(justUnloaded);
    }

    public void initWorld(World toInit) {
        if (!this.managerPerWorld.containsKey(toInit)) {
            this.managerPerWorld.put(toInit, new WorldPhysObjectManager(toInit));
        }
    }

    public WorldPhysObjectManager getManagerForWorld(World world) {
        if (world == null) {
            // empty if block
        }
        if (this.cachedManager == null || this.cachedManager.worldObj != world) {
            this.cachedManager = this.managerPerWorld.get(world);
        }
        if (this.cachedManager == null) {
            System.err.println("getManagerForWorld just requested for a World without one!!! Assuming that this is a new world, so making a new WorldPhysObjectManager for it.");
            this.cachedManager = new WorldPhysObjectManager(world);
            this.managerPerWorld.put(world, this.cachedManager);
        }
        return this.cachedManager;
    }

    public void removeWorld(World world) {
        if (this.managerPerWorld.containsKey(world)) {
            this.getManagerForWorld((World)world).physicsEntities.clear();
        }
        this.managerPerWorld.remove(world);
    }

    @Deprecated
    public PhysicsWrapperEntity getObjectManagingPos(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return null;
        }
        if (world.func_72863_F() == null) {
            return null;
        }
        if (!PhysicsChunkManager.isLikelyShipChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return null;
        }
        WorldPhysObjectManager physManager = this.getManagerForWorld(world);
        if (physManager == null) {
            return null;
        }
        return physManager.getManagingObjectForChunkPosition(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public boolean isEntityFixed(Entity entity) {
        return this.getManagerForWorld(entity.field_70170_p).isEntityFixed(entity);
    }

    public PhysicsWrapperEntity getShipFixedOnto(Entity entity) {
        return this.getManagerForWorld(entity.field_70170_p).getShipFixedOnto(entity, false);
    }
}

