/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physicsmanagement;

import gnu.trove.iterator.TIntIterator;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import valkyrienwarfare.BlockPhysicsRegistration;
import valkyrienwarfare.NBTUtils;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.ValkyrienWarfareControl;
import valkyrienwarfare.addon.control.balloon.ShipBalloonManager;
import valkyrienwarfare.addon.control.network.EntityFixMessage;
import valkyrienwarfare.addon.control.nodenetwork.INodeProvider;
import valkyrienwarfare.addon.control.nodenetwork.Node;
import valkyrienwarfare.api.EnumChangeOwnerResult;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.api.block.ethercompressor.TileEntityEtherCompressor;
import valkyrienwarfare.capability.IAirshipCounterCapability;
import valkyrienwarfare.chunkmanagement.ChunkSet;
import valkyrienwarfare.chunkmanagement.PhysicsChunkManager;
import valkyrienwarfare.network.PhysWrapperPositionMessage;
import valkyrienwarfare.physics.BlockForce;
import valkyrienwarfare.physics.PhysicsCalculations;
import valkyrienwarfare.physics.PhysicsCalculationsManualControl;
import valkyrienwarfare.physics.PhysicsCalculationsOrbital;
import valkyrienwarfare.physics.PhysicsQueuedForce;
import valkyrienwarfare.physicsmanagement.CoordTransformObject;
import valkyrienwarfare.physicsmanagement.PhysCollisionCallable;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.physicsmanagement.ShipTransformData;
import valkyrienwarfare.physicsmanagement.ShipType;
import valkyrienwarfare.physicsmanagement.WorldPhysObjectManager;
import valkyrienwarfare.relocation.DetectorManager;
import valkyrienwarfare.relocation.SpatialDetector;
import valkyrienwarfare.relocation.VWChunkCache;
import valkyrienwarfare.render.PhysObjectRenderManager;
import valkyrienwarfare.schematics.SchematicReader;

public class PhysicsObject {
    public World worldObj;
    public PhysicsWrapperEntity wrapper;
    public ArrayList<EntityPlayerMP> watchingPlayers = new ArrayList();
    public ArrayList<EntityPlayerMP> newWatchers = new ArrayList();
    public BlockPos refrenceBlockPos;
    public Vector centerCoord;
    public Vector lastTickCenterCoord;
    public CoordTransformObject coordTransform;
    public PhysObjectRenderManager renderer;
    public PhysicsCalculations physicsProcessor;
    public HashSet<BlockPos> blockPositions = new HashSet();
    public AxisAlignedBB collisionBB = PhysicsWrapperEntity.field_174836_a;
    public ArrayList<PhysicsQueuedForce> queuedPhysForces = new ArrayList();
    public ArrayList<BlockPos> explodedPositionsThisTick = new ArrayList();
    public boolean doPhysics = true;
    public boolean fromSplit = false;
    public String creator;
    public PhysCollisionCallable collisionCallable = new PhysCollisionCallable(this);
    public int lastMessageTick;
    public int detectorID;
    public ChunkCache surroundingWorldChunksCache;
    public boolean blocksChanged = false;
    public ChunkSet ownedChunks;
    public Chunk[][] claimedChunks;
    public VWChunkCache VKChunkCache;
    public PlayerChunkMapEntry[][] claimedChunksEntries;
    public ShipBalloonManager balloonManager;
    public HashMap<Integer, Vector> entityLocalPositions = new HashMap();
    public ArrayList<String> allowedUsers = new ArrayList();
    public ArrayList<Entity> queuedEntitiesToMount = new ArrayList();
    public boolean claimedChunksInMap = false;
    public boolean isNameCustom = false;
    public ShipType shipType;
    public HashSet<Node> nodesWithinShip = new HashSet();

    public PhysicsObject(PhysicsWrapperEntity host) {
        this.wrapper = host;
        this.worldObj = host.field_70170_p;
        if (host.field_70170_p.field_72995_K) {
            this.renderer = new PhysObjectRenderManager(this);
        } else {
            this.balloonManager = new ShipBalloonManager(this);
        }
    }

    public void onSetBlockState(IBlockState oldState, IBlockState newState, BlockPos posAt) {
        boolean isNewAir;
        boolean oldStateOnBlackList = false;
        boolean newStateOnBlackList = false;
        if (oldState != null && BlockPhysicsRegistration.blocksToNotPhysicise.contains(oldState.func_177230_c())) {
            oldState = Blocks.field_150350_a.func_176223_P();
            oldStateOnBlackList = true;
        }
        if (newState != null && BlockPhysicsRegistration.blocksToNotPhysicise.contains(newState.func_177230_c())) {
            newState = Blocks.field_150350_a.func_176223_P();
            newStateOnBlackList = true;
        }
        boolean isOldAir = oldState == null || oldState.func_177230_c().equals(Blocks.field_150350_a);
        boolean bl = isNewAir = newState == null || newState.func_177230_c().equals(Blocks.field_150350_a);
        if (!this.ownedChunks.isChunkEnclosedInMaxSet(posAt.func_177958_n() >> 4, posAt.func_177952_p() >> 4)) {
            return;
        }
        if (!this.ownedChunks.isChunkEnclosedInSet(posAt.func_177958_n() >> 4, posAt.func_177952_p() >> 4)) {
            return;
        }
        this.blocksChanged = true;
        if (isNewAir) {
            this.blockPositions.remove(posAt);
            if (!this.worldObj.field_72995_K) {
                this.balloonManager.onBlockPositionRemoved(posAt);
            }
        }
        if (isOldAir && !isNewAir) {
            if (!this.worldObj.field_72995_K) {
                this.balloonManager.onBlockPositionAdded(posAt);
                this.blockPositions.add(posAt);
            } else if (!this.blockPositions.contains(posAt)) {
                this.blockPositions.add(posAt);
            }
            int chunkX = (posAt.func_177958_n() >> 4) - this.claimedChunks[0][0].field_76635_g;
            int chunkZ = (posAt.func_177952_p() >> 4) - this.claimedChunks[0][0].field_76647_h;
            this.ownedChunks.chunkOccupiedInLocal[chunkX][chunkZ] = true;
        }
        if (this.blockPositions.isEmpty()) {
            block18: {
                try {
                    if (this.worldObj.field_72995_K || this.creator == null) break block18;
                    EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(this.creator));
                    if (player != null) {
                        ((IAirshipCounterCapability)player.getCapability(ValkyrienWarfareMod.airshipCounter, null)).onLose();
                    } else {
                        try {
                            File f = new File(DimensionManager.getCurrentSaveRootDirectory(), "playerdata/" + this.creator + ".dat");
                            NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)f);
                            NBTTagCompound capsTag = tag.func_74775_l("ForgeCaps");
                            capsTag.func_74768_a("valkyrienwarfare:IAirshipCounter", capsTag.func_74762_e("valkyrienwarfare:IAirshipCounter") - 1);
                            CompressedStreamTools.func_74793_a((NBTTagCompound)tag, (File)f);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    ValkyrienWarfareMod.chunkManager.getManagerForWorld((World)this.worldObj).data.avalibleChunkKeys.add(this.ownedChunks.centerX);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.destroy();
        }
        if (!this.worldObj.field_72995_K && this.physicsProcessor != null) {
            this.physicsProcessor.onSetBlockState(oldState, newState, posAt);
        }
    }

    public void destroy() {
        this.wrapper.func_70106_y();
        ArrayList watchersCopy = (ArrayList)this.watchingPlayers.clone();
        for (EntityPlayerMP wachingPlayer : watchersCopy) {
            for (int x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
                for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
                    SPacketUnloadChunk unloadPacket = new SPacketUnloadChunk(x, z);
                    wachingPlayer.field_71135_a.func_147359_a((Packet)unloadPacket);
                }
            }
        }
        this.watchingPlayers.clear();
        ValkyrienWarfareMod.chunkManager.removeRegistedChunksForShip(this.wrapper);
        ValkyrienWarfareMod.chunkManager.removeShipPosition(this.wrapper);
        ValkyrienWarfareMod.chunkManager.removeShipNameRegistry(this.wrapper);
        ValkyrienWarfareMod.physicsManager.onShipUnload(this.wrapper);
    }

    public void claimNewChunks(int radius) {
        this.ownedChunks = ValkyrienWarfareMod.chunkManager.getManagerForWorld(this.wrapper.field_70170_p).getNextAvaliableChunkSet(radius);
        ValkyrienWarfareMod.chunkManager.registerChunksForShip(this.wrapper);
        this.claimedChunksInMap = true;
    }

    public void processChunkClaims(EntityPlayer player) {
        BlockPos centerInWorld = new BlockPos(this.wrapper.field_70165_t, this.wrapper.field_70163_u, this.wrapper.field_70161_v);
        SpatialDetector detector = DetectorManager.getDetectorFor(this.detectorID, centerInWorld, this.worldObj, ValkyrienWarfareMod.maxShipSize + 1, true);
        if (detector.foundSet.size() > ValkyrienWarfareMod.maxShipSize || detector.cleanHouse) {
            if (player != null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Ship construction canceled because its exceeding the ship size limit (Raise with /physSettings maxShipSize <number>) ; Or because it's attatched to bedrock)"));
            }
            this.wrapper.func_70106_y();
            return;
        }
        this.assembleShip(player, detector, centerInWorld);
    }

    public void processChunkClaims(SchematicReader.Schematic toFollow) {
        BlockPos centerInWorld = new BlockPos(-(toFollow.width / 2), 128 - toFollow.height / 2, -(toFollow.length / 2));
        int radiusNeeded = Math.max(toFollow.length, toFollow.width) / 16 + 2;
        this.claimNewChunks(radiusNeeded);
        ValkyrienWarfareMod.physicsManager.onShipPreload(this.wrapper);
        this.claimedChunks = new Chunk[this.ownedChunks.radius * 2 + 1][this.ownedChunks.radius * 2 + 1];
        this.claimedChunksEntries = new PlayerChunkMapEntry[this.ownedChunks.radius * 2 + 1][this.ownedChunks.radius * 2 + 1];
        for (int x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
                Chunk chunk = new Chunk(this.worldObj, x, z);
                this.injectChunkIntoWorld(chunk, x, z, true);
                this.claimedChunks[x - this.ownedChunks.minX][z - this.ownedChunks.minZ] = chunk;
            }
        }
        this.replaceOuterChunksWithAir();
        this.VKChunkCache = new VWChunkCache(this.worldObj, this.claimedChunks);
        int minChunkX = this.claimedChunks[0][0].field_76635_g;
        int minChunkZ = this.claimedChunks[0][0].field_76647_h;
        this.refrenceBlockPos = this.getRegionCenter();
        this.centerCoord = new Vector(this.refrenceBlockPos.func_177958_n(), this.refrenceBlockPos.func_177956_o(), this.refrenceBlockPos.func_177952_p());
        this.createPhysicsCalculations();
        this.physicsProcessor.isShipPastBuild91 = true;
        BlockPos centerDifference = this.refrenceBlockPos.func_177973_b((Vec3i)centerInWorld);
        toFollow.placeBlockAndTilesInWorld(this.worldObj, centerDifference);
        this.detectBlockPositions();
        for (int x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
            }
        }
        this.coordTransform = new CoordTransformObject(this);
        this.physicsProcessor.processInitialPhysicsData();
        this.physicsProcessor.updateParentCenterOfMass();
        this.coordTransform.updateAllTransforms();
    }

    private void createPhysicsCalculations() {
        if (this.physicsProcessor == null) {
            this.physicsProcessor = this.shipType == ShipType.Oribtal || this.shipType == ShipType.Semi_Unlocked_Orbital ? new PhysicsCalculationsOrbital(this) : (this.shipType == ShipType.Zepplin || this.shipType == ShipType.Dungeon_Sky ? new PhysicsCalculationsManualControl(this) : new PhysicsCalculations(this));
        }
    }

    private void assembleShip(EntityPlayer player, SpatialDetector detector, BlockPos centerInWorld) {
        int x;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        TIntIterator iter = detector.foundSet.iterator();
        int radiusNeeded = 1;
        while (iter.hasNext()) {
            int i = iter.next();
            SpatialDetector.setPosWithRespectTo(i, BlockPos.field_177992_a, pos);
            int xRad = Math.abs(pos.func_177958_n() >> 4);
            int zRad = Math.abs(pos.func_177952_p() >> 4);
            radiusNeeded = Math.max(Math.max(zRad, xRad), radiusNeeded + 1);
        }
        iter = detector.foundSet.iterator();
        ValkyrienWarfareMod.chunkManager.getManagerForWorld(this.wrapper.field_70170_p);
        radiusNeeded = Math.min(radiusNeeded, PhysicsChunkManager.maxChunkRadius);
        this.claimNewChunks(radiusNeeded);
        ValkyrienWarfareMod.physicsManager.onShipPreload(this.wrapper);
        this.claimedChunks = new Chunk[this.ownedChunks.radius * 2 + 1][this.ownedChunks.radius * 2 + 1];
        this.claimedChunksEntries = new PlayerChunkMapEntry[this.ownedChunks.radius * 2 + 1][this.ownedChunks.radius * 2 + 1];
        for (int x2 = this.ownedChunks.minX; x2 <= this.ownedChunks.maxX; ++x2) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
                Chunk chunk = new Chunk(this.worldObj, x2, z);
                this.injectChunkIntoWorld(chunk, x2, z, true);
                this.claimedChunks[x2 - this.ownedChunks.minX][z - this.ownedChunks.minZ] = chunk;
            }
        }
        this.replaceOuterChunksWithAir();
        this.VKChunkCache = new VWChunkCache(this.worldObj, this.claimedChunks);
        int minChunkX = this.claimedChunks[0][0].field_76635_g;
        int minChunkZ = this.claimedChunks[0][0].field_76647_h;
        this.refrenceBlockPos = this.getRegionCenter();
        this.centerCoord = new Vector(this.refrenceBlockPos.func_177958_n(), this.refrenceBlockPos.func_177956_o(), this.refrenceBlockPos.func_177952_p());
        this.createPhysicsCalculations();
        this.physicsProcessor.isShipPastBuild91 = true;
        BlockPos centerDifference = this.refrenceBlockPos.func_177973_b((Vec3i)centerInWorld);
        while (iter.hasNext()) {
            Field[] fields;
            int i = iter.next();
            SpatialDetector.setPosWithRespectTo(i, centerInWorld, pos);
            IBlockState state = detector.cache.getBlockState((BlockPos)pos);
            TileEntity worldTile = detector.cache.getTileEntity((BlockPos)pos);
            pos.func_181079_c(pos.func_177958_n() + centerDifference.func_177958_n(), pos.func_177956_o() + centerDifference.func_177956_o(), pos.func_177952_p() + centerDifference.func_177952_p());
            this.ownedChunks.chunkOccupiedInLocal[(pos.func_177958_n() >> 4) - minChunkX][(pos.func_177952_p() >> 4) - minChunkZ] = true;
            Chunk chunkToSet = this.claimedChunks[(pos.func_177958_n() >> 4) - minChunkX][(pos.func_177952_p() >> 4) - minChunkZ];
            int storageIndex = pos.func_177956_o() >> 4;
            if (chunkToSet.field_76652_q[storageIndex] == Chunk.field_186036_a) {
                chunkToSet.field_76652_q[storageIndex] = new ExtendedBlockStorage(storageIndex << 4, true);
            }
            chunkToSet.field_76652_q[storageIndex].func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
            if (worldTile == null) continue;
            NBTTagCompound tileEntNBT = new NBTTagCompound();
            tileEntNBT = worldTile.func_189515_b(tileEntNBT);
            tileEntNBT.func_74768_a("x", pos.func_177958_n());
            tileEntNBT.func_74768_a("y", pos.func_177956_o());
            tileEntNBT.func_74768_a("z", pos.func_177952_p());
            if (worldTile instanceof INodeProvider) {
                int[] backingPositionArray = tileEntNBT.func_74759_k("connectednodesarray");
                for (int cont = 0; cont < backingPositionArray.length; cont += 3) {
                    backingPositionArray[cont] = backingPositionArray[cont] + centerDifference.func_177958_n();
                    backingPositionArray[cont + 1] = backingPositionArray[cont + 1] + centerDifference.func_177956_o();
                    backingPositionArray[cont + 2] = backingPositionArray[cont + 2] + centerDifference.func_177952_p();
                }
                tileEntNBT.func_74783_a("connectednodesarray", backingPositionArray);
            }
            if (worldTile instanceof TileEntityEtherCompressor) {
                int controllerPosX = tileEntNBT.func_74762_e("controllerPosX");
                int controllerPosY = tileEntNBT.func_74762_e("controllerPosY");
                int controllerPosZ = tileEntNBT.func_74762_e("controllerPosZ");
                tileEntNBT.func_74768_a("controllerPosX", controllerPosX + centerDifference.func_177958_n());
                tileEntNBT.func_74768_a("controllerPosY", controllerPosY + centerDifference.func_177956_o());
                tileEntNBT.func_74768_a("controllerPosZ", controllerPosZ + centerDifference.func_177952_p());
            }
            TileEntity newInstance = TileEntity.func_190200_a((World)this.worldObj, (NBTTagCompound)tileEntNBT);
            newInstance.func_145829_t();
            Class<?> tileClass = newInstance.getClass();
            for (Field field : fields = tileClass.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    Object o = field.get(newInstance);
                    if (o == null || !(o instanceof BlockPos)) continue;
                    BlockPos inTilePos = (BlockPos)o;
                    int hash = SpatialDetector.getHashWithRespectTo(inTilePos.func_177958_n(), inTilePos.func_177956_o(), inTilePos.func_177952_p(), detector.firstBlock);
                    if (!detector.foundSet.contains(hash)) continue;
                    if (!(o instanceof BlockPos.MutableBlockPos)) {
                        inTilePos = inTilePos.func_177982_a(centerDifference.func_177958_n(), centerDifference.func_177956_o(), centerDifference.func_177952_p());
                        field.set(newInstance, inTilePos);
                        continue;
                    }
                    BlockPos.MutableBlockPos mutable = (BlockPos.MutableBlockPos)o;
                    mutable.func_181079_c(inTilePos.func_177958_n() + centerDifference.func_177958_n(), inTilePos.func_177956_o() + centerDifference.func_177956_o(), inTilePos.func_177952_p() + centerDifference.func_177952_p());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (newInstance instanceof INodeProvider) {
                ((INodeProvider)newInstance).getNode().updateParentEntity(this);
            }
            this.worldObj.func_175690_a(newInstance.func_174877_v(), newInstance);
            if (newInstance instanceof INodeProvider) {
                this.nodesWithinShip.add(((INodeProvider)newInstance).getNode());
            }
            newInstance.func_70296_d();
        }
        iter = detector.foundSet.iterator();
        short[][] changes = new short[this.claimedChunks.length][this.claimedChunks[0].length];
        while (iter.hasNext()) {
            int i = iter.next();
            SpatialDetector.setPosWithRespectTo(i, centerInWorld, pos);
            TileEntity tile = this.worldObj.func_175625_s((BlockPos)pos);
            if (tile != null) {
                tile.func_145843_s();
            }
            this.worldObj.func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
                this.claimedChunks[x - this.ownedChunks.minX][z - this.ownedChunks.minZ].field_76646_k = true;
                this.claimedChunks[x - this.ownedChunks.minX][z - this.ownedChunks.minZ].func_76603_b();
                this.claimedChunks[x - this.ownedChunks.minX][z - this.ownedChunks.minZ].func_150809_p();
            }
        }
        this.detectBlockPositions();
        for (x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
            }
        }
        this.coordTransform = new CoordTransformObject(this);
        this.physicsProcessor.processInitialPhysicsData();
        this.physicsProcessor.updateParentCenterOfMass();
    }

    public void injectChunkIntoWorld(Chunk chunk, int x, int z, boolean putInId2ChunkMap) {
        ChunkProviderServer provider = (ChunkProviderServer)this.worldObj.func_72863_F();
        chunk.field_76636_d = true;
        chunk.field_76643_l = true;
        this.claimedChunks[x - this.ownedChunks.minX][z - this.ownedChunks.minZ] = chunk;
        if (putInId2ChunkMap) {
            provider.field_73244_f.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
        }
        PlayerChunkMap map = ((WorldServer)this.worldObj).func_184164_w();
        PlayerChunkMapEntry entry = new PlayerChunkMapEntry(map, x, z){};
        long i = PlayerChunkMap.func_187307_d((int)x, (int)z);
        map.field_72700_c.put(i, (Object)entry);
        map.field_111193_e.add(entry);
        entry.field_187290_j = true;
        entry.field_187283_c = this.watchingPlayers;
        this.claimedChunksEntries[x - this.ownedChunks.minX][z - this.ownedChunks.minZ] = entry;
    }

    private void replaceOuterChunksWithAir() {
        for (int x = this.ownedChunks.minX - 1; x <= this.ownedChunks.maxX + 1; ++x) {
            for (int z = this.ownedChunks.minZ - 1; z <= this.ownedChunks.maxZ + 1; ++z) {
                if (x != this.ownedChunks.minX - 1 && x != this.ownedChunks.maxX + 1 && z != this.ownedChunks.minZ - 1 && z != this.ownedChunks.maxZ + 1) continue;
                Chunk chunk = new Chunk(this.worldObj, x, z);
                ChunkProviderServer provider = (ChunkProviderServer)this.worldObj.func_72863_F();
                chunk.field_76643_l = true;
                provider.field_73244_f.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
            }
        }
    }

    public void preloadNewPlayers() {
        Set newWatchers = this.getPlayersThatJustWatched();
        Chunk[][] chunkArray = this.claimedChunks;
        int n = chunkArray.length;
        for (int i = 0; i < n; ++i) {
            Chunk[] chunkArray2;
            for (Chunk chunk : chunkArray2 = chunkArray[i]) {
                SPacketChunkData data = new SPacketChunkData(chunk, 65535);
                for (EntityPlayerMP player : newWatchers) {
                    player.field_71135_a.func_147359_a((Packet)data);
                    ((WorldServer)this.worldObj).func_73039_n().func_85172_a(player, chunk);
                }
            }
        }
    }

    public BlockPos getRegionCenter() {
        return new BlockPos(this.claimedChunks[this.ownedChunks.radius + 1][this.ownedChunks.radius + 1].field_76635_g * 16 - 8, 127, this.claimedChunks[this.ownedChunks.radius + 1][this.ownedChunks.radius + 1].field_76647_h * 16 - 8);
    }

    public void onPlayerUntracking(EntityPlayer untracking) {
        this.watchingPlayers.remove(untracking);
        for (int x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
                SPacketUnloadChunk unloadPacket = new SPacketUnloadChunk(x, z);
                ((EntityPlayerMP)untracking).field_71135_a.func_147359_a((Packet)unloadPacket);
            }
        }
    }

    public void onThisUnload() {
        if (!this.worldObj.field_72995_K) {
            this.unloadShipChunksFromWorld();
        } else {
            this.renderer.killRenderers();
        }
    }

    public void unloadShipChunksFromWorld() {
        ChunkProviderServer provider = (ChunkProviderServer)this.worldObj.func_72863_F();
        WorldPhysObjectManager manager = ValkyrienWarfareMod.physicsManager.getManagerForWorld(this.worldObj);
        for (int x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
                provider.func_189549_a(this.claimedChunks[x - this.ownedChunks.minX][z - this.ownedChunks.minZ]);
            }
        }
    }

    private Set getPlayersThatJustWatched() {
        HashSet<EntityPlayerMP> newPlayers = new HashSet<EntityPlayerMP>();
        for (Object o : ((WorldServer)this.worldObj).func_73039_n().getTrackingPlayers((Entity)this.wrapper)) {
            EntityPlayerMP player = (EntityPlayerMP)o;
            if (this.watchingPlayers.contains(player)) continue;
            newPlayers.add(player);
            this.watchingPlayers.add(player);
        }
        return newPlayers;
    }

    public void onTick() {
        if (!this.worldObj.field_72995_K) {
            this.balloonManager.onPostTick();
            for (Entity e : this.queuedEntitiesToMount) {
                if (e == null) continue;
                e.func_184205_a((Entity)this.wrapper, true);
            }
            this.queuedEntitiesToMount.clear();
        }
    }

    public void queueForce(PhysicsQueuedForce toQueue) {
        this.queuedPhysForces.add(toQueue);
    }

    public void onPostTick() {
        this.tickQueuedForces();
        this.explodedPositionsThisTick.clear();
        if (!this.wrapper.field_70128_L && !this.wrapper.field_70170_p.field_72995_K) {
            ValkyrienWarfareMod.chunkManager.updateShipPosition(this.wrapper);
            if (!this.claimedChunksInMap) {
                ValkyrienWarfareMod.chunkManager.registerChunksForShip(this.wrapper);
                System.out.println("Old ship detected, adding to the registered Chunks map");
                this.claimedChunksInMap = true;
            }
        }
    }

    public void tickQueuedForces() {
        for (int i = 0; i < this.queuedPhysForces.size(); ++i) {
            PhysicsQueuedForce queue = this.queuedPhysForces.get(i);
            if (queue.ticksToApply <= 0) {
                this.queuedPhysForces.remove(i);
                --i;
            }
            --queue.ticksToApply;
        }
    }

    public void onPostTickClient() {
        this.wrapper.prevPitch = this.wrapper.pitch;
        this.wrapper.prevYaw = this.wrapper.yaw;
        this.wrapper.prevRoll = this.wrapper.roll;
        this.wrapper.field_70142_S = this.wrapper.field_70165_t;
        this.wrapper.field_70137_T = this.wrapper.field_70163_u;
        this.wrapper.field_70136_U = this.wrapper.field_70161_v;
        this.lastTickCenterCoord = this.centerCoord;
        ShipTransformData toUse = this.coordTransform.stack.getDataForTick(this.lastMessageTick);
        if (toUse != null) {
            this.lastMessageTick = toUse.relativeTick;
            if (this.wrapper.yaw != toUse.yaw || this.wrapper.pitch == toUse.pitch) {
                // empty if block
            }
            Vector CMDif = toUse.centerOfRotation.getSubtraction(this.centerCoord);
            RotationMatrices.applyTransform(this.coordTransform.lToWRotation, CMDif);
            this.wrapper.field_70142_S -= CMDif.X;
            this.wrapper.field_70137_T -= CMDif.Y;
            this.wrapper.field_70136_U -= CMDif.Z;
            toUse.applyToPhysObject(this);
        }
        this.coordTransform.setPrevMatrices();
        this.coordTransform.updateAllTransforms();
    }

    public void updateChunkCache() {
        BlockPos min = new BlockPos(this.collisionBB.field_72340_a, Math.max(this.collisionBB.field_72338_b, 0.0), this.collisionBB.field_72339_c);
        BlockPos max = new BlockPos(this.collisionBB.field_72336_d, Math.min(this.collisionBB.field_72337_e, 255.0), this.collisionBB.field_72334_f);
        this.surroundingWorldChunksCache = new ChunkCache(this.worldObj, min, max, 0);
    }

    public void loadClaimedChunks() {
        Node node;
        ArrayList<TileEntity> nodeTileEntitiesToUpdate = new ArrayList<TileEntity>();
        ValkyrienWarfareMod.physicsManager.onShipPreload(this.wrapper);
        this.claimedChunks = new Chunk[this.ownedChunks.radius * 2 + 1][this.ownedChunks.radius * 2 + 1];
        this.claimedChunksEntries = new PlayerChunkMapEntry[this.ownedChunks.radius * 2 + 1][this.ownedChunks.radius * 2 + 1];
        for (int x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
                Chunk chunk = this.worldObj.func_72964_e(x, z);
                if (chunk == null) {
                    System.out.println("Just a loaded a null chunk");
                    chunk = new Chunk(this.worldObj, x, z);
                }
                if (!this.worldObj.field_72995_K) {
                    this.injectChunkIntoWorld(chunk, x, z, false);
                }
                for (Map.Entry entry : chunk.field_150816_i.entrySet()) {
                    TileEntity tile = (TileEntity)entry.getValue();
                    if (!(tile instanceof INodeProvider)) continue;
                    nodeTileEntitiesToUpdate.add(tile);
                }
                this.claimedChunks[x - this.ownedChunks.minX][z - this.ownedChunks.minZ] = chunk;
            }
        }
        this.VKChunkCache = new VWChunkCache(this.worldObj, this.claimedChunks);
        this.refrenceBlockPos = this.getRegionCenter();
        this.coordTransform = new CoordTransformObject(this);
        if (!this.worldObj.field_72995_K) {
            this.createPhysicsCalculations();
        }
        this.detectBlockPositions();
        for (TileEntity tile : nodeTileEntitiesToUpdate) {
            node = ((INodeProvider)tile).getNode();
            if (node != null) {
                node.updateParentEntity(this);
                continue;
            }
            System.err.println("How the fuck did we get a null node?");
        }
        for (TileEntity tile : nodeTileEntitiesToUpdate) {
            node = ((INodeProvider)tile).getNode();
            if (node != null) {
                node.updateBuildState();
                continue;
            }
            System.err.println("How the fuck did we get a null node?");
        }
        this.coordTransform.updateAllTransforms();
    }

    public void detectBlockPositions() {
        for (int chunkX = this.claimedChunks.length - 1; chunkX > -1; --chunkX) {
            for (int chunkZ = this.claimedChunks[0].length - 1; chunkZ > -1; --chunkZ) {
                Chunk chunk = this.claimedChunks[chunkX][chunkZ];
                if (chunk == null || !this.ownedChunks.chunkOccupiedInLocal[chunkX][chunkZ]) continue;
                for (int index = 0; index < 16; ++index) {
                    ExtendedBlockStorage storage = chunk.func_76587_i()[index];
                    if (storage == null) continue;
                    for (int y = 0; y < 16; ++y) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                if (storage.field_177488_d.field_186021_b.func_188142_a(y << 8 | z << 4 | x) == ValkyrienWarfareMod.airStateIndex) continue;
                                BlockPos pos = new BlockPos(chunk.field_76635_g * 16 + x, index * 16 + y, chunk.field_76647_h * 16 + z);
                                this.blockPositions.add(pos);
                                if (this.worldObj.field_72995_K || !BlockForce.basicForces.isBlockProvidingForce(this.worldObj.func_180495_p(pos), pos, this.worldObj)) continue;
                                this.physicsProcessor.activeForcePositions.add(pos);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean ownsChunk(int chunkX, int chunkZ) {
        return this.ownedChunks.isChunkEnclosedInSet(chunkX, chunkZ);
    }

    public void queueEntityForMounting(Entity toMount) {
        this.queuedEntitiesToMount.add(toMount);
    }

    public void fixEntity(Entity toFix, Vector posInLocal) {
        EntityFixMessage entityFixingMessage = new EntityFixMessage(this.wrapper, toFix, true, posInLocal);
        for (EntityPlayerMP watcher : this.watchingPlayers) {
            ValkyrienWarfareControl.controlNetwork.sendTo((IMessage)entityFixingMessage, watcher);
        }
        this.entityLocalPositions.put(toFix.getPersistentID().hashCode(), posInLocal);
    }

    public void unFixEntity(Entity toUnfix) {
        EntityFixMessage entityUnfixingMessage = new EntityFixMessage(this.wrapper, toUnfix, false, null);
        for (EntityPlayerMP watcher : this.watchingPlayers) {
            ValkyrienWarfareControl.controlNetwork.sendTo((IMessage)entityUnfixingMessage, watcher);
        }
        this.entityLocalPositions.remove(toUnfix.getPersistentID().hashCode());
    }

    public void fixEntityUUID(int uuidHash, Vector localPos) {
        this.entityLocalPositions.put(uuidHash, localPos);
    }

    public void removeEntityUUID(int uuidHash) {
        this.entityLocalPositions.remove(uuidHash);
    }

    public boolean isEntityFixed(Entity toCheck) {
        return this.entityLocalPositions.containsKey(toCheck.getPersistentID().hashCode());
    }

    public Vector getLocalPositionForEntity(Entity getPositionFor) {
        int uuidHash = getPositionFor.getPersistentID().hashCode();
        return this.entityLocalPositions.get(uuidHash);
    }

    public void writeToNBTTag(NBTTagCompound compound) {
        this.ownedChunks.writeToNBT(compound);
        NBTUtils.writeVectorToNBT("c", this.centerCoord, compound);
        compound.func_74780_a("pitch", this.wrapper.pitch);
        compound.func_74780_a("yaw", this.wrapper.yaw);
        compound.func_74780_a("roll", this.wrapper.roll);
        compound.func_74757_a("doPhysics", this.doPhysics);
        for (int row = 0; row < this.ownedChunks.chunkOccupiedInLocal.length; ++row) {
            boolean[] curArray = this.ownedChunks.chunkOccupiedInLocal[row];
            for (int column = 0; column < curArray.length; ++column) {
                compound.func_74757_a("CC:" + row + ":" + column, curArray[column]);
            }
        }
        NBTUtils.writeEntityPositionHashMapToNBT("entityPosHashMap", this.entityLocalPositions, compound);
        this.physicsProcessor.writeToNBTTag(compound);
        Iterator<String> iter = this.allowedUsers.iterator();
        StringBuilder result = new StringBuilder("");
        while (iter.hasNext()) {
            result.append(iter.next() + (iter.hasNext() ? ";" : ""));
        }
        compound.func_74778_a("allowedUsers", result.toString());
        compound.func_74778_a("owner", this.creator);
        compound.func_74757_a("claimedChunksInMap", this.claimedChunksInMap);
        compound.func_74757_a("isNameCustom", this.isNameCustom);
        compound.func_74778_a("shipType", this.shipType.name());
    }

    public void readFromNBTTag(NBTTagCompound compound) {
        String[] toAllow;
        this.ownedChunks = new ChunkSet(compound);
        this.lastTickCenterCoord = this.centerCoord = NBTUtils.readVectorFromNBT("c", compound);
        this.wrapper.pitch = compound.func_74769_h("pitch");
        this.wrapper.yaw = compound.func_74769_h("yaw");
        this.wrapper.roll = compound.func_74769_h("roll");
        this.doPhysics = compound.func_74767_n("doPhysics");
        for (int row = 0; row < this.ownedChunks.chunkOccupiedInLocal.length; ++row) {
            boolean[] curArray = this.ownedChunks.chunkOccupiedInLocal[row];
            for (int column = 0; column < curArray.length; ++column) {
                curArray[column] = compound.func_74767_n("CC:" + row + ":" + column);
            }
        }
        String shipTypeName = compound.func_74779_i("shipType");
        this.shipType = !shipTypeName.equals("") ? ShipType.valueOf(ShipType.class, shipTypeName) : ShipType.Full_Unlocked;
        this.loadClaimedChunks();
        this.entityLocalPositions = NBTUtils.readEntityPositionMap("entityPosHashMap", compound);
        this.physicsProcessor.readFromNBTTag(compound);
        for (String s : toAllow = compound.func_74779_i("allowedUsers").split(";")) {
            this.allowedUsers.add(s);
        }
        this.creator = compound.func_74779_i("owner");
        this.claimedChunksInMap = compound.func_74767_n("claimedChunksInMap");
        for (int x = this.ownedChunks.minX; x <= this.ownedChunks.maxX; ++x) {
            for (int z = this.ownedChunks.minZ; z <= this.ownedChunks.maxZ; ++z) {
                this.worldObj.func_72964_e(x, z);
            }
        }
        this.isNameCustom = compound.func_74767_n("isNameCustom");
        this.wrapper.field_70180_af.func_187227_b(PhysicsWrapperEntity.IS_NAME_CUSTOM, (Object)this.isNameCustom);
    }

    public void readSpawnData(ByteBuf additionalData) {
        PacketBuffer modifiedBuffer = new PacketBuffer(additionalData);
        this.ownedChunks = new ChunkSet(modifiedBuffer.readInt(), modifiedBuffer.readInt(), modifiedBuffer.readInt());
        this.wrapper.field_70165_t = modifiedBuffer.readDouble();
        this.wrapper.field_70163_u = modifiedBuffer.readDouble();
        this.wrapper.field_70161_v = modifiedBuffer.readDouble();
        this.wrapper.pitch = modifiedBuffer.readDouble();
        this.wrapper.yaw = modifiedBuffer.readDouble();
        this.wrapper.roll = modifiedBuffer.readDouble();
        this.wrapper.prevPitch = this.wrapper.pitch;
        this.wrapper.prevYaw = this.wrapper.yaw;
        this.wrapper.prevRoll = this.wrapper.roll;
        this.wrapper.field_70142_S = this.wrapper.field_70165_t;
        this.wrapper.field_70137_T = this.wrapper.field_70163_u;
        this.wrapper.field_70136_U = this.wrapper.field_70161_v;
        this.centerCoord = new Vector((ByteBuf)modifiedBuffer);
        for (boolean[] array : this.ownedChunks.chunkOccupiedInLocal) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = modifiedBuffer.readBoolean();
            }
        }
        this.loadClaimedChunks();
        this.renderer.updateOffsetPos(this.refrenceBlockPos);
        this.coordTransform.stack.pushMessage(new PhysWrapperPositionMessage(this));
        try {
            NBTTagCompound entityFixedPositionNBT = modifiedBuffer.func_150793_b();
            this.entityLocalPositions = NBTUtils.readEntityPositionMap("entityFixedPosMap", entityFixedPositionNBT);
        }
        catch (IOException e) {
            System.err.println("Couldn't load the entityFixedPosNBT; this is really bad.");
            e.printStackTrace();
        }
        this.isNameCustom = modifiedBuffer.readBoolean();
        this.shipType = (ShipType)modifiedBuffer.func_179257_a(ShipType.class);
    }

    public void writeSpawnData(ByteBuf buffer) {
        PacketBuffer modifiedBuffer = new PacketBuffer(buffer);
        modifiedBuffer.writeInt(this.ownedChunks.centerX);
        modifiedBuffer.writeInt(this.ownedChunks.centerZ);
        modifiedBuffer.writeInt(this.ownedChunks.radius);
        modifiedBuffer.writeDouble(this.wrapper.field_70165_t);
        modifiedBuffer.writeDouble(this.wrapper.field_70163_u);
        modifiedBuffer.writeDouble(this.wrapper.field_70161_v);
        modifiedBuffer.writeDouble(this.wrapper.pitch);
        modifiedBuffer.writeDouble(this.wrapper.yaw);
        modifiedBuffer.writeDouble(this.wrapper.roll);
        this.centerCoord.writeToByteBuf((ByteBuf)modifiedBuffer);
        boolean[][] blArray = this.ownedChunks.chunkOccupiedInLocal;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean[] array;
            for (boolean b : array = blArray[i]) {
                modifiedBuffer.writeBoolean(b);
            }
        }
        NBTTagCompound entityFixedPositionNBT = new NBTTagCompound();
        NBTUtils.writeEntityPositionHashMapToNBT("entityFixedPosMap", this.entityLocalPositions, entityFixedPositionNBT);
        modifiedBuffer.func_150786_a(entityFixedPositionNBT);
        modifiedBuffer.writeBoolean(this.isNameCustom);
        modifiedBuffer.func_179249_a((Enum)this.shipType);
    }

    public EnumChangeOwnerResult changeOwner(EntityPlayer newOwner) {
        if (!ValkyrienWarfareMod.canChangeAirshipCounter(true, newOwner)) {
            return EnumChangeOwnerResult.ERROR_NEWOWNER_NOT_ENOUGH;
        }
        if (newOwner.field_96093_i.toString().equals(this.creator)) {
            return EnumChangeOwnerResult.ALREADY_CLAIMED;
        }
        EntityPlayerMP player = null;
        try {
            player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(this.creator));
        }
        catch (NullPointerException e) {
            newOwner.func_145747_a((ITextComponent)new TextComponentString("That airship doesn't have an owner, you get to have it :D"));
            ((IAirshipCounterCapability)newOwner.getCapability(ValkyrienWarfareMod.airshipCounter, null)).onCreate();
            this.allowedUsers.clear();
            this.creator = newOwner.field_96093_i.toString();
            return EnumChangeOwnerResult.SUCCESS;
        }
        if (player != null) {
            ((IAirshipCounterCapability)player.getCapability(ValkyrienWarfareMod.airshipCounter, null)).onLose();
        } else {
            try {
                File f = new File(DimensionManager.getCurrentSaveRootDirectory(), "playerdata/" + this.creator + ".dat");
                NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)f);
                NBTTagCompound capsTag = tag.func_74775_l("ForgeCaps");
                capsTag.func_74768_a("valkyrienwarfare:IAirshipCounter", capsTag.func_74762_e("valkyrienwarfare:IAirshipCounter") - 1);
                CompressedStreamTools.func_74793_a((NBTTagCompound)tag, (File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ((IAirshipCounterCapability)newOwner.getCapability(ValkyrienWarfareMod.airshipCounter, null)).onCreate();
        this.allowedUsers.clear();
        this.creator = newOwner.field_96093_i.toString();
        return EnumChangeOwnerResult.SUCCESS;
    }
}

