/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physicsmanagement;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.minecraft.world.World;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.interaction.EntityDraggable;
import valkyrienwarfare.optimization.ShipCollisionTask;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.physicsmanagement.WorldPhysObjectManager;

public class PhysicsTickHandler {
    public static void onWorldTickStart(World world) {
        WorldPhysObjectManager manager = ValkyrienWarfareMod.physicsManager.getManagerForWorld(world);
        ArrayList toUnload = (ArrayList)manager.physicsEntitiesToUnload.clone();
        for (Object wrapper : toUnload) {
            manager.onUnload((PhysicsWrapperEntity)((Object)wrapper));
        }
        ArrayList<PhysicsWrapperEntity> physicsEntities = manager.getTickablePhysicsEntities();
        if (!ValkyrienWarfareMod.doSplitting) {
            for (PhysicsWrapperEntity wrapper : physicsEntities) {
                wrapper.wrapping.coordTransform.setPrevMatrices();
                wrapper.wrapping.updateChunkCache();
            }
        }
        int iters = ValkyrienWarfareMod.physIter;
        double newPhysSpeed = ValkyrienWarfareMod.physSpeed;
        Vector newGravity = ValkyrienWarfareMod.gravity;
        PhysicsTickThreadTask physicsThreadTask = new PhysicsTickThreadTask(iters, physicsEntities, manager);
        try {
            manager.physicsThreadStatus = ValkyrienWarfareMod.PhysicsMasterThread.submit(physicsThreadTask);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onWorldTickEnd(World world) {
        WorldPhysObjectManager manager = ValkyrienWarfareMod.physicsManager.getManagerForWorld(world);
        ArrayList<PhysicsWrapperEntity> physicsEntities = manager.getTickablePhysicsEntities();
        if (manager.physicsThreadStatus != null && !manager.physicsThreadStatus.isDone()) {
            try {
                manager.physicsThreadStatus.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (PhysicsWrapperEntity wrapper : physicsEntities) {
            wrapper.wrapping.coordTransform.sendPositionToPlayers();
        }
        EntityDraggable.tickAddedVelocityForWorld(world);
        for (PhysicsWrapperEntity wrapperEnt : physicsEntities) {
            wrapperEnt.wrapping.onPostTick();
        }
    }

    public static void runPhysicsIteration(ArrayList<PhysicsWrapperEntity> physicsEntities, WorldPhysObjectManager manager) {
        double newPhysSpeed = ValkyrienWarfareMod.physSpeed;
        Vector newGravity = ValkyrienWarfareMod.gravity;
        int iters = ValkyrienWarfareMod.physIter;
        ArrayList<ShipCollisionTask> collisionTasks = new ArrayList<ShipCollisionTask>(physicsEntities.size() * 2);
        for (PhysicsWrapperEntity wrapper : physicsEntities) {
            if (wrapper.field_70148_d) continue;
            wrapper.wrapping.physicsProcessor.gravity = newGravity;
            wrapper.wrapping.physicsProcessor.rawPhysTickPreCol(newPhysSpeed, iters);
            wrapper.wrapping.physicsProcessor.worldCollision.tickUpdatingTheCollisionCache();
            wrapper.wrapping.physicsProcessor.worldCollision.splitIntoCollisionTasks(collisionTasks);
        }
        try {
            ValkyrienWarfareMod.MultiThreadExecutor.invokeAll(collisionTasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (ShipCollisionTask task : collisionTasks) {
            PhysicsWrapperEntity wrapper = task.toTask.parent.wrapper;
            if (wrapper.field_70148_d) continue;
            task.toTask.processCollisionTask(task);
        }
        for (PhysicsWrapperEntity wrapper : physicsEntities) {
            if (!wrapper.field_70148_d) {
                wrapper.wrapping.physicsProcessor.rawPhysTickPostCol();
                continue;
            }
            wrapper.wrapping.coordTransform.updateAllTransforms();
        }
    }

    private static class PhysicsTickThreadTask
    implements Callable<Void> {
        int iters;
        ArrayList physicsEntities;
        WorldPhysObjectManager manager;

        public PhysicsTickThreadTask(int iters, ArrayList physicsEntities, WorldPhysObjectManager manager) {
            this.iters = iters;
            this.physicsEntities = physicsEntities;
            this.manager = manager;
        }

        @Override
        public Void call() throws Exception {
            for (int pass = 0; pass < this.iters; ++pass) {
                PhysicsTickHandler.runPhysicsIteration(this.physicsEntities, this.manager);
            }
            return null;
        }
    }
}

