/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physicsmanagement;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.combat.entity.EntityMountingWeaponBase;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.capability.IAirshipCounterCapability;
import valkyrienwarfare.collision.Polygon;
import valkyrienwarfare.interaction.ShipNameUUIDData;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.physicsmanagement.ShipType;
import valkyrienwarfare.schematics.SchematicReader;

public class PhysicsWrapperEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Boolean> IS_NAME_CUSTOM = EntityDataManager.func_187226_a(Entity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final AxisAlignedBB zeroBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public PhysicsObject wrapping;
    public double pitch;
    public double yaw;
    public double roll;
    public double prevPitch;
    public double prevYaw;
    public double prevRoll;

    public PhysicsWrapperEntity(World worldIn) {
        super(worldIn);
        this.wrapping = new PhysicsObject(this);
        this.field_70180_af.func_187214_a(IS_NAME_CUSTOM, (Object)false);
    }

    public PhysicsWrapperEntity(World worldIn, double x, double y, double z, @Nullable EntityPlayer creator, int detectorID, ShipType shipType) {
        this(worldIn);
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.wrapping.creator = creator.field_96093_i.toString();
        this.wrapping.detectorID = detectorID;
        this.wrapping.shipType = shipType;
        this.wrapping.processChunkClaims(creator);
        IAirshipCounterCapability counter = (IAirshipCounterCapability)creator.getCapability(ValkyrienWarfareMod.airshipCounter, null);
        counter.onCreate();
        this.setCustomNameTagInitial(creator.func_70005_c_() + ":" + counter.getAirshipCountEver());
        ShipNameUUIDData.get(worldIn).placeShipInRegistry(this, this.func_95999_t());
    }

    public PhysicsWrapperEntity(World worldIn, double x, double y, double z, ShipType type, SchematicReader.Schematic schematic) {
        super(worldIn);
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.wrapping = new PhysicsObject(this);
        this.wrapping.creator = "god";
        this.wrapping.detectorID = 0;
        this.wrapping.shipType = type;
        this.wrapping.processChunkClaims(schematic);
        this.setCustomNameTagInitial("Obummer:" + Math.random() * 1.0E7);
        ShipNameUUIDData.get(worldIn).placeShipInRegistry(this, this.func_95999_t());
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.wrapping.isNameCustom = (Boolean)this.field_70180_af.func_187225_a(IS_NAME_CUSTOM);
        }
        this.wrapping.onTick();
        this.field_70148_d = false;
    }

    public void func_184232_k(Entity passenger) {
        Vector inLocal = this.wrapping.getLocalPositionForEntity(passenger);
        if (inLocal != null) {
            Vector newEntityPosition = new Vector(inLocal);
            float f = passenger.field_70130_N / 2.0f;
            float f1 = passenger.field_70131_O;
            AxisAlignedBB inLocalAABB = new AxisAlignedBB(newEntityPosition.X - (double)f, newEntityPosition.Y, newEntityPosition.Z - (double)f, newEntityPosition.X + (double)f, newEntityPosition.Y + (double)f1, newEntityPosition.Z + (double)f);
            this.wrapping.coordTransform.fromLocalToGlobal(newEntityPosition);
            passenger.func_70107_b(newEntityPosition.X, newEntityPosition.Y, newEntityPosition.Z);
            Polygon entityBBPoly = new Polygon(inLocalAABB, this.wrapping.coordTransform.lToWTransform);
            AxisAlignedBB newEntityBB = entityBBPoly.getEnclosedAABB();
            passenger.func_174826_a(newEntityBB);
            if (passenger instanceof EntityMountingWeaponBase) {
                passenger.func_70071_h_();
                for (Entity e : passenger.field_184244_h) {
                    Vector inLocalAgain;
                    if (!this.wrapping.isEntityFixed(e) || (inLocalAgain = this.wrapping.getLocalPositionForEntity(e)) == null) continue;
                    Vector newEntityPositionAgain = new Vector(inLocalAgain);
                    this.wrapping.coordTransform.fromLocalToGlobal(newEntityPositionAgain);
                    e.func_70107_b(newEntityPositionAgain.X, newEntityPositionAgain.Y, newEntityPositionAgain.Z);
                }
            }
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
    }

    protected void func_184225_p(Entity toRemove) {
        super.func_184225_p(toRemove);
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.wrapping.collisionBB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.wrapping.collisionBB;
    }

    public void func_70107_b(double x, double y, double z) {
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
    }

    protected boolean func_184219_q(Entity passenger) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_94059_bO() {
        return this.wrapping.isNameCustom;
    }

    public void setCustomNameTagInitial(String name) {
        super.func_96094_a(name);
    }

    public void func_96094_a(String name) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_95999_t() != null && !this.func_95999_t().equals("")) {
                boolean didRenameSuccessful = ShipNameUUIDData.get(this.field_70170_p).renameShipInRegsitry(this, name, this.func_95999_t());
                if (didRenameSuccessful) {
                    super.func_96094_a(name);
                    this.wrapping.isNameCustom = true;
                    this.field_70180_af.func_187227_b(IS_NAME_CUSTOM, (Object)true);
                }
            } else {
                super.func_96094_a(name);
            }
        } else {
            super.func_96094_a(name);
        }
    }

    public void func_70634_a(double x, double y, double z) {
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        this.wrapping.readFromNBTTag(tagCompound);
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        this.wrapping.writeToNBTTag(tagCompound);
    }

    public void writeSpawnData(ByteBuf buffer) {
        this.wrapping.preloadNewPlayers();
        this.wrapping.writeSpawnData(buffer);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.wrapping.readSpawnData(additionalData);
    }
}

