/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.physicsmanagement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class WorldPhysObjectManager {
    public final ForgeChunkManager.Ticket chunkLoadingTicket;
    public final HashMap<ChunkPos, PhysicsWrapperEntity> chunkPosToPhysicsEntityMap = new HashMap();
    public World worldObj;
    public ArrayList<PhysicsWrapperEntity> physicsEntities = new ArrayList();
    public ArrayList<PhysicsWrapperEntity> physicsEntitiesToUnload = new ArrayList();
    public ArrayList<Callable<Void>> physCollisonCallables = new ArrayList();
    public Future physicsThreadStatus = null;

    public WorldPhysObjectManager(World toManage) {
        this.worldObj = toManage;
        this.chunkLoadingTicket = ForgeChunkManager.requestTicket((Object)ValkyrienWarfareMod.INSTANCE, (World)toManage, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
    }

    public ArrayList<PhysicsWrapperEntity> getTickablePhysicsEntities() {
        ArrayList list = (ArrayList)this.physicsEntities.clone();
        ArrayList<PhysicsWrapperEntity> frozenShips = new ArrayList<PhysicsWrapperEntity>();
        if (this.worldObj instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)this.worldObj;
            for (PhysicsWrapperEntity wrapper : list) {
                if (!wrapper.field_70128_L) {
                    if (wrapper.wrapping.surroundingWorldChunksCache == null) continue;
                    int chunkCacheX = MathHelper.func_76128_c((double)(wrapper.field_70165_t / 16.0)) - wrapper.wrapping.surroundingWorldChunksCache.field_72818_a;
                    int chunkCacheZ = MathHelper.func_76128_c((double)(wrapper.field_70161_v / 16.0)) - wrapper.wrapping.surroundingWorldChunksCache.field_72816_b;
                    Chunk chunk = wrapper.wrapping.surroundingWorldChunksCache.field_72817_c[chunkCacheX = Math.max(0, Math.min(chunkCacheX, wrapper.wrapping.surroundingWorldChunksCache.field_72817_c.length - 1))][chunkCacheZ = Math.max(0, Math.min(chunkCacheZ, wrapper.wrapping.surroundingWorldChunksCache.field_72817_c[0].length - 1))];
                    if (chunk == null || worldServer.field_73063_M.func_152621_a(chunk.field_76635_g, chunk.field_76647_h)) continue;
                    frozenShips.add(wrapper);
                    continue;
                }
                frozenShips.add(wrapper);
            }
        }
        ArrayList<PhysicsWrapperEntity> dumbShips = new ArrayList<PhysicsWrapperEntity>();
        for (PhysicsWrapperEntity wrapper : list) {
            if (!wrapper.field_70128_L && wrapper.wrapping != null && (wrapper.wrapping.physicsProcessor != null || wrapper.field_70170_p.field_72995_K)) continue;
            dumbShips.add(wrapper);
        }
        list.removeAll(frozenShips);
        list.removeAll(dumbShips);
        return list;
    }

    public void onLoad(PhysicsWrapperEntity loaded) {
        if (!loaded.wrapping.fromSplit) {
            if (loaded.field_70170_p.field_72995_K) {
                ArrayList<PhysicsWrapperEntity> potentialMatches = new ArrayList<PhysicsWrapperEntity>();
                for (PhysicsWrapperEntity wrapper : this.physicsEntities) {
                    if (!wrapper.getPersistentID().equals(loaded.getPersistentID())) continue;
                    potentialMatches.add(wrapper);
                }
                for (PhysicsWrapperEntity caught : potentialMatches) {
                    this.physicsEntities.remove((Object)caught);
                    this.physCollisonCallables.remove(caught.wrapping.collisionCallable);
                    caught.wrapping.onThisUnload();
                }
            }
            loaded.field_70128_L = false;
            this.physicsEntities.add(loaded);
            this.physCollisonCallables.add(loaded.wrapping.collisionCallable);
        } else {
            loaded.wrapping.fromSplit = false;
        }
    }

    public void preloadPhysicsWrapperEntityMappings(PhysicsWrapperEntity loaded) {
        for (int x = loaded.wrapping.ownedChunks.minX; x <= loaded.wrapping.ownedChunks.maxX; ++x) {
            for (int z = loaded.wrapping.ownedChunks.minZ; z <= loaded.wrapping.ownedChunks.maxZ; ++z) {
                this.chunkPosToPhysicsEntityMap.put(new ChunkPos(x, z), loaded);
            }
        }
    }

    public void onUnload(PhysicsWrapperEntity loaded) {
        if (!loaded.field_70170_p.field_72995_K) {
            this.physicsEntities.remove((Object)loaded);
            this.physCollisonCallables.remove(loaded.wrapping.collisionCallable);
            loaded.wrapping.onThisUnload();
            Chunk[][] chunkArray = loaded.wrapping.claimedChunks;
            int n = chunkArray.length;
            for (int i = 0; i < n; ++i) {
                Chunk[] chunks;
                for (Chunk chunk : chunks = chunkArray[i]) {
                    this.chunkPosToPhysicsEntityMap.remove(chunk.func_76632_l());
                }
            }
        } else {
            loaded.field_70128_L = true;
        }
    }

    @Deprecated
    public PhysicsWrapperEntity getManagingObjectForChunk(Chunk chunk) {
        return this.getManagingObjectForChunkPosition(chunk.field_76635_g, chunk.field_76647_h);
    }

    public PhysicsWrapperEntity getManagingObjectForChunkPosition(int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        return this.chunkPosToPhysicsEntityMap.get(chunkPos);
    }

    public List<PhysicsWrapperEntity> getNearbyPhysObjects(AxisAlignedBB toCheck) {
        ArrayList<PhysicsWrapperEntity> ships = new ArrayList<PhysicsWrapperEntity>();
        AxisAlignedBB expandedCheck = toCheck.func_72314_b(6.0, 6.0, 6.0);
        for (PhysicsWrapperEntity wrapper : this.physicsEntities) {
            if (!wrapper.wrapping.collisionBB.func_72326_a(expandedCheck)) continue;
            ships.add(wrapper);
        }
        return ships;
    }

    public boolean isEntityFixed(Entity entity) {
        return this.getShipFixedOnto(entity, false) != null;
    }

    public PhysicsWrapperEntity getShipFixedOnto(Entity entity, boolean considerUUID) {
        for (PhysicsWrapperEntity wrapper : this.physicsEntities) {
            if (!wrapper.wrapping.isEntityFixed(entity)) continue;
            if (considerUUID && wrapper.wrapping.entityLocalPositions.containsKey(entity.getPersistentID().hashCode())) {
                return wrapper;
            }
            if (wrapper.field_184244_h.contains(entity)) {
                return wrapper;
            }
            for (Entity e : wrapper.field_184244_h) {
                if (e.field_70128_L || !e.field_184244_h.contains(entity)) continue;
                return wrapper;
            }
        }
        return null;
    }
}

