/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.relocation;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class VWChunkCache {
    public Chunk[][] cachedChunks;
    public boolean[][] isChunkLoaded;
    public boolean allLoaded = true;
    public World worldFor;
    int minChunkX;
    int minChunkZ;
    int maxChunkX;
    int maxChunkZ;

    public VWChunkCache(World world, int mnX, int mnZ, int mxX, int mxZ) {
        this.worldFor = world;
        this.minChunkX = mnX >> 4;
        this.minChunkZ = mnZ >> 4;
        this.maxChunkX = mxX >> 4;
        this.maxChunkZ = mxZ >> 4;
        this.cachedChunks = new Chunk[this.maxChunkX - this.minChunkX + 1][this.maxChunkZ - this.minChunkZ + 1];
        this.isChunkLoaded = new boolean[this.maxChunkX - this.minChunkX + 1][this.maxChunkZ - this.minChunkZ + 1];
        for (int x = this.minChunkX; x <= this.maxChunkX; ++x) {
            for (int z = this.minChunkZ; z <= this.maxChunkZ; ++z) {
                this.cachedChunks[x - this.minChunkX][z - this.minChunkZ] = world.func_72964_e(x, z);
                boolean bl = this.isChunkLoaded[x - this.minChunkX][z - this.minChunkZ] = !this.cachedChunks[x - this.minChunkX][z - this.minChunkZ].func_76621_g();
                if (this.isChunkLoaded[x - this.minChunkX][z - this.minChunkZ]) continue;
                this.allLoaded = false;
            }
        }
    }

    public VWChunkCache(World world, Chunk[][] toCache) {
        this.minChunkX = toCache[0][0].field_76635_g;
        this.minChunkZ = toCache[0][0].field_76647_h;
        this.maxChunkX = toCache[toCache.length - 1][toCache[0].length - 1].field_76635_g;
        this.maxChunkZ = toCache[toCache.length - 1][toCache[0].length - 1].field_76647_h;
        this.cachedChunks = new Chunk[this.maxChunkX - this.minChunkX + 1][this.maxChunkZ - this.minChunkZ + 1];
        this.isChunkLoaded = new boolean[this.maxChunkX - this.minChunkX + 1][this.maxChunkZ - this.minChunkZ + 1];
        this.cachedChunks = (Chunk[][])toCache.clone();
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos) {
        int i = (pos.func_177958_n() >> 4) - this.minChunkX;
        int j = (pos.func_177952_p() >> 4) - this.minChunkZ;
        if (i < 0 || i >= this.cachedChunks.length || j < 0 || j >= this.cachedChunks[i].length) {
            return null;
        }
        if (this.cachedChunks[i][j] == null) {
            return null;
        }
        return this.cachedChunks[i][j].func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE);
    }

    public boolean containsPos(BlockPos pos) {
        int i = (pos.func_177958_n() >> 4) - this.minChunkX;
        int j = (pos.func_177952_p() >> 4) - this.minChunkZ;
        return i >= 0 && i < this.cachedChunks.length && j >= 0 && j < this.cachedChunks[i].length;
    }

    public Chunk getChunkAt(int x, int z) {
        return this.cachedChunks[x - this.minChunkX][z - this.minChunkZ];
    }

    public IBlockState getBlockState(BlockPos pos) {
        Chunk chunkForPos = this.cachedChunks[(pos.func_177958_n() >> 4) - this.minChunkX][(pos.func_177952_p() >> 4) - this.minChunkZ];
        return chunkForPos.func_177435_g(pos);
    }

    public IBlockState getBlockState(int x, int y, int z) {
        Chunk chunkForPos = this.cachedChunks[(x >> 4) - this.minChunkX][(z >> 4) - this.minChunkZ];
        return chunkForPos.func_186032_a(x, y, z);
    }

    public void setBlockState(BlockPos pos, IBlockState state) {
        Chunk chunkForPos = this.cachedChunks[(pos.func_177958_n() >> 4) - this.minChunkX][(pos.func_177952_p() >> 4) - this.minChunkZ];
        chunkForPos.func_177436_a(pos, state);
    }

    public boolean isBlockLoaded(BlockPos pos) {
        return this.isChunkLoaded[(pos.func_177958_n() >> 4) - this.minChunkX][(pos.func_177952_p() >> 4) - this.minChunkZ];
    }

    public boolean canSeeSky(BlockPos pos) {
        Chunk chunkForPos = this.cachedChunks[(pos.func_177958_n() >> 4) - this.minChunkX][(pos.func_177952_p() >> 4) - this.minChunkZ];
        return chunkForPos.func_177444_d(pos);
    }

    public int getLightFor(EnumSkyBlock type, BlockPos pos) {
        Chunk chunkForPos = this.cachedChunks[(pos.func_177958_n() >> 4) - this.minChunkX][(pos.func_177952_p() >> 4) - this.minChunkZ];
        return chunkForPos.func_177413_a(type, pos);
    }

    public void setLightFor(EnumSkyBlock p_177431_1_, BlockPos pos, int value) {
        Chunk chunkForPos = this.cachedChunks[(pos.func_177958_n() >> 4) - this.minChunkX][(pos.func_177952_p() >> 4) - this.minChunkZ];
        chunkForPos.func_177431_a(p_177431_1_, pos, value);
    }
}

