/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class FastBlockModelRenderer {
    public static HashMap<IBlockState, VertexBuffer.State> blockstateToVertexData = new HashMap();
    public static HashMap<IBlockState, Map<Integer, Integer>> highRamGLList = new HashMap();

    public static void renderBlockModel(VertexBuffer vertexbuffer, Tessellator tessellator, World world, IBlockState blockstateToRender, int brightness) {
        FastBlockModelRenderer.renderBlockModelHighQualityHighRam(vertexbuffer, tessellator, world, blockstateToRender, brightness);
    }

    private static void renderBlockModelHighQualityHighRam(VertexBuffer vertexbuffer, Tessellator tessellator, World world, IBlockState blockstateToRender, int brightness) {
        Integer glListForBrightness;
        Map<Integer, Integer> brightnessToGLListMap = highRamGLList.get(blockstateToRender);
        if (brightnessToGLListMap == null) {
            highRamGLList.put(blockstateToRender, new HashMap());
            brightnessToGLListMap = highRamGLList.get(blockstateToRender);
        }
        if ((glListForBrightness = brightnessToGLListMap.get(brightness)) == null) {
            GL11.glPushMatrix();
            int glList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)glList, (int)4864);
            FastBlockModelRenderer.renderBlockModelHighQuality(vertexbuffer, tessellator, world, blockstateToRender, brightness);
            GL11.glEndList();
            GL11.glPopMatrix();
            glListForBrightness = glList;
            brightnessToGLListMap.put(brightness, glList);
        }
        GL11.glPushMatrix();
        GL11.glCallList((int)glListForBrightness);
        GL11.glPopMatrix();
    }

    private static void renderBlockModelHighQuality(VertexBuffer vertexbuffer, Tessellator tessellator, World world, IBlockState blockstateToRender, int brightness) {
        VertexBuffer.State vertexData = blockstateToVertexData.get(blockstateToRender);
        double oldX = vertexbuffer.field_179004_l;
        double oldY = vertexbuffer.field_179005_m;
        double oldZ = vertexbuffer.field_179002_n;
        if (vertexData == null) {
            FastBlockModelRenderer.generateRenderDataFor(vertexbuffer, tessellator, world, blockstateToRender);
            vertexData = blockstateToVertexData.get(blockstateToRender);
        }
        FastBlockModelRenderer.renderVertexState(vertexData, vertexbuffer, tessellator, brightness);
    }

    private static void renderVertexState(VertexBuffer.State data, VertexBuffer vertexbuffer, Tessellator tessellator, int brightness) {
        GL11.glPushMatrix();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        vertexbuffer.func_178993_a(data);
        int j = vertexbuffer.field_179011_q.func_177338_f() >> 2;
        int cont = vertexbuffer.func_178989_h();
        int offsetUV = vertexbuffer.field_179011_q.func_177344_b(1) / 4;
        int bufferNextSize = vertexbuffer.field_179011_q.func_181719_f();
        for (int contont = 0; contont < cont; contont += 4) {
            try {
                int i = contont * bufferNextSize + offsetUV;
                vertexbuffer.field_178999_b.put(i, brightness);
                vertexbuffer.field_178999_b.put(i + j, brightness);
                vertexbuffer.field_178999_b.put(i + j * 2, brightness);
                vertexbuffer.field_178999_b.put(i + j * 3, brightness);
                if (contont + 4 >= cont) continue;
                i = (contont += 4) * bufferNextSize + offsetUV;
                vertexbuffer.field_178999_b.put(i, brightness);
                vertexbuffer.field_178999_b.put(i + j, brightness);
                vertexbuffer.field_178999_b.put(i + j * 2, brightness);
                vertexbuffer.field_178999_b.put(i + j * 3, brightness);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    private static void generateRenderDataFor(VertexBuffer vertexbuffer, Tessellator tessellator, World world, IBlockState state) {
        GL11.glPushMatrix();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)world, blockrendererdispatcher.func_184389_a(state), state, BlockPos.field_177992_a, vertexbuffer, false, 0L);
        VertexBuffer.State toReturn = vertexbuffer.func_181672_a();
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        blockstateToVertexData.put(state, toReturn);
    }
}

