/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.render;

import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.api.RotationMatrices;
import valkyrienwarfare.api.Vector;
import valkyrienwarfare.math.Quaternion;
import valkyrienwarfare.physicsmanagement.PhysicsObject;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;
import valkyrienwarfare.proxy.ClientProxy;
import valkyrienwarfare.render.PhysRenderChunk;

public class PhysObjectRenderManager {
    public static boolean renderingMountedEntities = false;
    public int glCallListSolid = -1;
    public int glCallListTranslucent = -1;
    public int glCallListCutout = -1;
    public int glCallListCutoutMipped = -1;
    public PhysicsObject parent;
    public BlockPos offsetPos;
    public double curPartialTick;
    public PhysRenderChunk[][] renderChunks;
    private FloatBuffer transformBuffer = null;

    public PhysObjectRenderManager(PhysicsObject toRender) {
        this.parent = toRender;
    }

    public void updateOffsetPos(BlockPos newPos) {
        this.offsetPos = newPos;
    }

    public void renderBlockLayer(BlockRenderLayer layerToRender, double partialTicks, int pass) {
        if (this.renderChunks == null) {
            if (this.parent.claimedChunks == null) {
                return;
            }
            this.renderChunks = new PhysRenderChunk[this.parent.claimedChunks.length][this.parent.claimedChunks[0].length];
            for (int xChunk = 0; xChunk < this.parent.claimedChunks.length; ++xChunk) {
                for (int zChunk = 0; zChunk < this.parent.claimedChunks.length; ++zChunk) {
                    this.renderChunks[xChunk][zChunk] = new PhysRenderChunk(this.parent, this.parent.claimedChunks[xChunk][zChunk]);
                }
            }
        }
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        this.setupTranslation(partialTicks);
        PhysRenderChunk[][] physRenderChunkArray = this.renderChunks;
        int n = physRenderChunkArray.length;
        for (int i = 0; i < n; ++i) {
            PhysRenderChunk[] chunkArray;
            for (PhysRenderChunk renderChunk : chunkArray = physRenderChunkArray[i]) {
                renderChunk.renderBlockLayer(layerToRender, partialTicks, pass);
            }
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GL11.glPopMatrix();
    }

    public void killRenderers() {
        if (this.renderChunks != null) {
            PhysRenderChunk[][] physRenderChunkArray = this.renderChunks;
            int n = physRenderChunkArray.length;
            for (int i = 0; i < n; ++i) {
                PhysRenderChunk[] chunks;
                for (PhysRenderChunk chunk : chunks = physRenderChunkArray[i]) {
                    chunk.killRenderChunk();
                }
            }
        }
    }

    public void updateRange(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.renderChunks == null || this.parent == null || this.parent.ownedChunks == null) {
            return;
        }
        int size = (maxX + 1 - minX) * (maxZ + 1 - minZ) * (maxY + 1 - minY);
        if (size > 65535) {
            return;
        }
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        int minBlockArrayY = Math.max(0, minY >> 4);
        int maxBlockArrayY = Math.min(15, maxY >> 4);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                try {
                    if (chunkX < this.parent.ownedChunks.minX || chunkZ < this.parent.ownedChunks.minZ || chunkX - this.parent.ownedChunks.minX >= this.renderChunks.length || chunkZ - this.parent.ownedChunks.minZ >= this.renderChunks[0].length) continue;
                    PhysRenderChunk renderChunk = this.renderChunks[chunkX - this.parent.ownedChunks.minX][chunkZ - this.parent.ownedChunks.minZ];
                    renderChunk.updateLayers(minBlockArrayY, maxBlockArrayY);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void renderTileEntities(float partialTicks) {
        for (BlockPos pos : this.parent.blockPositions) {
            TileEntity tileEnt = this.parent.worldObj.func_175625_s(pos);
            if (tileEnt == null) continue;
            try {
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEnt, partialTicks, -1);
            }
            catch (Exception exception) {}
        }
    }

    public boolean shouldRender() {
        ClientProxy cfr_ignored_0 = (ClientProxy)ValkyrienWarfareMod.proxy;
        ICamera camera = ClientProxy.lastCamera;
        return camera == null || camera.func_78546_a(this.parent.collisionBB);
    }

    public void setupTranslation(double partialTicks) {
        this.updateTranslation(partialTicks);
    }

    public void updateTranslation(double partialTicks) {
        PhysicsWrapperEntity entity = this.parent.wrapper;
        Vector centerOfRotation = entity.wrapping.centerCoord;
        this.curPartialTick = partialTicks;
        double moddedX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * partialTicks;
        double moddedY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * partialTicks;
        double moddedZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * partialTicks;
        double p0 = Minecraft.func_71410_x().field_71439_g.field_70142_S + (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70142_S) * partialTicks;
        double p1 = Minecraft.func_71410_x().field_71439_g.field_70137_T + (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70137_T) * partialTicks;
        double p2 = Minecraft.func_71410_x().field_71439_g.field_70136_U + (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70136_U) * partialTicks;
        Quaternion smoothRotation = this.getSmoothRotationQuat(partialTicks);
        double[] radians = smoothRotation.toRadians();
        double moddedPitch = Math.toDegrees(radians[0]);
        double moddedYaw = Math.toDegrees(radians[1]);
        double moddedRoll = Math.toDegrees(radians[2]);
        this.parent.coordTransform.updateRenderMatrices(moddedX, moddedY, moddedZ, moddedPitch, moddedYaw, moddedRoll);
        if (this.offsetPos != null) {
            double offsetX = (double)this.offsetPos.func_177958_n() - centerOfRotation.X;
            double offsetY = (double)this.offsetPos.func_177956_o() - centerOfRotation.Y;
            double offsetZ = (double)this.offsetPos.func_177952_p() - centerOfRotation.Z;
            GlStateManager.func_179137_b((double)(-p0 + moddedX), (double)(-p1 + moddedY), (double)(-p2 + moddedZ));
            GL11.glRotated((double)moddedPitch, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)moddedYaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)moddedRoll, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)offsetX, (double)offsetY, (double)offsetZ);
        }
    }

    public Quaternion getSmoothRotationQuat(double partialTick) {
        PhysicsWrapperEntity entity = this.parent.wrapper;
        double[] oldRotation = RotationMatrices.getDoubleIdentity();
        oldRotation = RotationMatrices.rotateAndTranslate(oldRotation, entity.prevPitch, entity.prevYaw, entity.prevRoll, new Vector());
        Quaternion oneTickBefore = Quaternion.QuaternionFromMatrix(oldRotation);
        double[] newRotation = RotationMatrices.getDoubleIdentity();
        newRotation = RotationMatrices.rotateAndTranslate(newRotation, entity.pitch, entity.yaw, entity.roll, new Vector());
        Quaternion nextQuat = Quaternion.QuaternionFromMatrix(newRotation);
        return Quaternion.getBetweenQuat(oneTickBefore, nextQuat, partialTick);
    }

    public void inverseTransform(double partialTicks) {
        PhysicsWrapperEntity entity = this.parent.wrapper;
        Vector centerOfRotation = entity.wrapping.centerCoord;
        this.curPartialTick = partialTicks;
        double moddedX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * partialTicks;
        double moddedY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * partialTicks;
        double moddedZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * partialTicks;
        double p0 = Minecraft.func_71410_x().field_71439_g.field_70142_S + (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70142_S) * partialTicks;
        double p1 = Minecraft.func_71410_x().field_71439_g.field_70137_T + (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70137_T) * partialTicks;
        double p2 = Minecraft.func_71410_x().field_71439_g.field_70136_U + (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70136_U) * partialTicks;
        Quaternion smoothRotation = this.getSmoothRotationQuat(partialTicks);
        double[] radians = smoothRotation.toRadians();
        double moddedPitch = Math.toDegrees(radians[0]);
        double moddedYaw = Math.toDegrees(radians[1]);
        double moddedRoll = Math.toDegrees(radians[2]);
        if (this.offsetPos != null) {
            double offsetX = (double)this.offsetPos.func_177958_n() - centerOfRotation.X;
            double offsetY = (double)this.offsetPos.func_177956_o() - centerOfRotation.Y;
            double offsetZ = (double)this.offsetPos.func_177952_p() - centerOfRotation.Z;
            GL11.glTranslated((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
            GL11.glRotated((double)(-moddedRoll), (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)(-moddedYaw), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-moddedPitch), (double)1.0, (double)0.0, (double)0.0);
            GlStateManager.func_179137_b((double)(p0 - moddedX), (double)(p1 - moddedY), (double)(p2 - moddedZ));
        }
    }
}

