/*
 * Decompiled with CFR 0.152.
 */
package valkyrienwarfare.schematics;

import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import valkyrienwarfare.ValkyrienWarfareMod;
import valkyrienwarfare.addon.control.nodenetwork.INodeProvider;
import valkyrienwarfare.physicsmanagement.PhysicsWrapperEntity;

public class SchematicReader {
    public static HashMap<String, Schematic> schematicCache = new HashMap();

    public static Schematic get(String schemname) {
        if (schematicCache.containsKey(schemname)) {
            Schematic tryCached = schematicCache.get(schemname);
            return tryCached;
        }
        try {
            InputStream is = ValkyrienWarfareMod.INSTANCE.getClass().getClassLoader().getResourceAsStream("assets/valkyrienwarfareworld/schematics/" + schemname);
            NBTTagCompound nbtdata = CompressedStreamTools.func_74796_a((InputStream)is);
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            byte[] addId = new byte[]{};
            short[] blocksCombined = new short[blocks.length];
            if (nbtdata.func_74770_j("AddBlocks") != null) {
                addId = nbtdata.func_74770_j("AddBlocks");
            } else {
                System.out.println("fuck");
            }
            for (int index = 0; index < blocks.length; ++index) {
                blocksCombined[index] = index >> 1 >= addId.length ? (short)(blocks[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blocks[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blocks[index] & 0xFF)));
            }
            NBTTagList tileentities = nbtdata.func_150295_c("TileEntities", 10);
            is.close();
            Schematic toReturn = new Schematic(tileentities, width, height, length, blocks, data, blocksCombined);
            schematicCache.put(schemname, toReturn);
            return toReturn;
        }
        catch (Exception e) {
            System.out.println("I can't load schematic, because " + e.toString());
            schematicCache.put(schemname, null);
            return null;
        }
    }

    public static final class Schematic {
        public final NBTTagList tileentities;
        public final short width;
        public final short height;
        public final short length;
        public final byte[] blocks;
        public final byte[] data;
        public final short[] blocksCombined;

        private Schematic(NBTTagList tileentities, short width, short height, short length, byte[] blocks, byte[] data, short[] blocksCombined) {
            this.tileentities = tileentities;
            this.width = width;
            this.height = height;
            this.length = length;
            this.blocks = blocks;
            this.data = data;
            this.blocksCombined = blocksCombined;
        }

        public void placeBlockAndTilesInWorld(World worldObj, BlockPos centerDifference) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    for (int z = 0; z < this.length; ++z) {
                        int index = y * this.width * this.length + z * this.width + x;
                        short id = this.blocksCombined[index];
                        byte dataVal = this.data[index];
                        Block b = Block.func_149729_e((int)id);
                        IBlockState state = b.func_176203_a((int)dataVal);
                        if (state.func_177230_c() == Blocks.field_150350_a) continue;
                        worldObj.func_180501_a(new BlockPos(x + centerDifference.func_177958_n(), y + centerDifference.func_177956_o(), z + centerDifference.func_177952_p()), state, 2);
                    }
                }
            }
            PhysicsWrapperEntity wrapperEntity = ValkyrienWarfareMod.physicsManager.getObjectManagingPos(worldObj, centerDifference);
            for (int i = 0; i < this.tileentities.func_74745_c(); ++i) {
                NBTTagCompound tileData = this.tileentities.func_150305_b(i).func_74737_b();
                int x = tileData.func_74762_e("x") + centerDifference.func_177958_n();
                int y = tileData.func_74762_e("y") + centerDifference.func_177956_o();
                int z = tileData.func_74762_e("z") + centerDifference.func_177952_p();
                tileData.func_74768_a("x", x);
                tileData.func_74768_a("y", y);
                tileData.func_74768_a("z", z);
                TileEntity newInstance = TileEntity.func_190200_a((World)worldObj, (NBTTagCompound)tileData);
                newInstance.func_145829_t();
                worldObj.func_175690_a(newInstance.func_174877_v(), newInstance);
                if (wrapperEntity != null && newInstance instanceof INodeProvider) {
                    wrapperEntity.wrapping.nodesWithinShip.add(((INodeProvider)newInstance).getNode());
                }
                newInstance.func_70296_d();
            }
        }
    }
}

