/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus;

import com.bigdious.risus.client.RisusClientEvents;
import com.bigdious.risus.data.BiomeTagsGenerator;
import com.bigdious.risus.data.BlockModelGenerator;
import com.bigdious.risus.data.BlockTagGenerator;
import com.bigdious.risus.data.CraftingGenerator;
import com.bigdious.risus.data.DamageTypeTagGenerator;
import com.bigdious.risus.data.EntityTagGenerator;
import com.bigdious.risus.data.FluidTagGenerator;
import com.bigdious.risus.data.ItemModelGenerator;
import com.bigdious.risus.data.ItemTagGenerator;
import com.bigdious.risus.data.LootGenerator;
import com.bigdious.risus.data.RegistryDataGenerator;
import com.bigdious.risus.data.RisusAdvancementProvider;
import com.bigdious.risus.data.RisusDataMaps;
import com.bigdious.risus.data.RisusSoundDefinitions;
import com.bigdious.risus.data.SpriteReferenceGenerator;
import com.bigdious.risus.data.StructureUpdater;
import com.bigdious.risus.event.RisusEvents;
import com.bigdious.risus.init.RisusArmorMaterials;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusDataAttachments;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusMenuType;
import com.bigdious.risus.init.RisusMobEffects;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusPotions;
import com.bigdious.risus.init.RisusRecipes;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusStructures;
import com.bigdious.risus.init.RisusTab;
import com.bigdious.risus.init.RisusTags;
import com.bigdious.risus.network.CreateCritParticlePacket;
import com.bigdious.risus.network.UnyieldingTotemPacket;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameRules;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="risus")
public class Risus {
    public static final String MODID = "risus";
    public static final GameRules.Key<GameRules.BooleanValue> HOLDERS_STEAL_FROM_MONSTERS = GameRules.register((String)"holdersStealFromMonsters", (GameRules.Category)GameRules.Category.MOBS, (GameRules.Type)GameRules.BooleanValue.create((boolean)true));
    public static final Logger LOGGER = LogManager.getLogger();

    public Risus(IEventBus bus, Dist dist) {
        RisusBlockEntities.BLOCK_ENTITIES.register(bus);
        RisusBlocks.BLOCKS.register(bus);
        RisusDataAttachments.ATTACHMENT_TYPES.register(bus);
        RisusArmorMaterials.ARMOR_MATERIALS.register(bus);
        RisusEntities.ENTITIES.register(bus);
        RisusItems.ITEMS.register(bus);
        RisusMobEffects.MOB_EFFECTS.register(bus);
        RisusMenuType.MENU_TYPES.register(bus);
        RisusParticles.PARTICLES.register(bus);
        RisusRecipes.RECIPE_SERIALIZERS.register(bus);
        RisusRecipes.RECIPE_TYPES.register(bus);
        RisusPotions.POTIONS.register(bus);
        RisusEntities.SPAWN_EGGS.register(bus);
        RisusTab.CREATIVE_TABS.register(bus);
        RisusSoundEvents.SOUNDS.register(bus);
        RisusFluids.FLUIDS.register(bus);
        RisusFluids.FLUID_TYPES.register(bus);
        RisusStructures.STRUCTURES.register(bus);
        bus.addListener(this::registerPackets);
        bus.addListener(this::gatherData);
        RisusEvents.initEvents(bus);
        if (dist.isClient()) {
            RisusClientEvents.initEvents(bus);
        }
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playToClient(CreateCritParticlePacket.TYPE, CreateCritParticlePacket.STREAM_CODEC, CreateCritParticlePacket::handle);
        registrar.playToClient(UnyieldingTotemPacket.TYPE, UnyieldingTotemPacket.STREAM_CODEC, UnyieldingTotemPacket::handle);
    }

    private void gatherData(GatherDataEvent event) {
        PackOutput packOutput = event.getGenerator().getPackOutput();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(packOutput, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean isServer = event.includeServer();
        boolean isClient = event.includeClient();
        event.getGenerator().addProvider(isServer, (DataProvider)new RisusAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
        event.getGenerator().addProvider(isClient, (DataProvider)new BlockModelGenerator(packOutput, existingFileHelper));
        event.getGenerator().addProvider(isServer, (DataProvider)new RisusTags.BannerPatternTagGenerator(packOutput, lookupProvider, existingFileHelper));
        event.getGenerator().addProvider(isClient, (DataProvider)new StructureUpdater("structures", packOutput, existingFileHelper));
        event.getGenerator().addProvider(isClient, (DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        event.getGenerator().addProvider(isServer, (DataProvider)new LootGenerator(packOutput, lookupProvider));
        event.getGenerator().addProvider(isServer, (DataProvider)new CraftingGenerator(packOutput, lookupProvider));
        BlockTagGenerator blocktags = new BlockTagGenerator(packOutput, lookupProvider, existingFileHelper);
        event.getGenerator().addProvider(isServer, (DataProvider)blocktags);
        event.getGenerator().addProvider(isServer, (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blocktags.contentsGetter(), existingFileHelper));
        event.getGenerator().addProvider(isServer, (DataProvider)new BiomeTagsGenerator(packOutput, lookupProvider, existingFileHelper));
        event.getGenerator().addProvider(isServer, (DataProvider)new FluidTagGenerator(packOutput, lookupProvider, existingFileHelper));
        event.getGenerator().addProvider(isServer, (DataProvider)new EntityTagGenerator(packOutput, lookupProvider, existingFileHelper));
        event.getGenerator().addProvider(isServer, (DataProvider)new RisusDataMaps(packOutput, lookupProvider));
        event.getGenerator().addProvider(isServer, (DataProvider)new RisusSoundDefinitions(packOutput, existingFileHelper));
        RegistryDataGenerator registryDataGenerator = new RegistryDataGenerator(packOutput, lookupProvider);
        event.getGenerator().addProvider(isServer, (DataProvider)registryDataGenerator);
        event.getGenerator().addProvider(isServer, (DataProvider)new DamageTypeTagGenerator(packOutput, registryDataGenerator.getRegistryProvider(), existingFileHelper));
        event.getGenerator().addProvider(isClient, (DataProvider)new SpriteReferenceGenerator(packOutput, lookupProvider, existingFileHelper));
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }
}

